/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.partitions;

import fr.devinsy.util.StringList;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.partitions.Interval;
import org.tip.puck.util.MathUtils;

public class Intervals
extends ArrayList<Interval> {
    private static final long serialVersionUID = 2789574687542101744L;
    private static final Logger logger = LoggerFactory.getLogger(Intervals.class);

    public Interval find(Double value) {
        Interval result;
        if (value == null) {
            result = null;
        } else {
            result = null;
            boolean ended = false;
            int index = 0;
            while (!ended) {
                if (index < this.size()) {
                    Interval interval = (Interval)this.get(index);
                    if (interval.matches(value)) {
                        ended = true;
                        result = interval;
                        continue;
                    }
                    ++index;
                    continue;
                }
                ended = true;
                result = null;
            }
        }
        return result;
    }

    public String toBasicStepString() {
        StringList buffer = new StringList();
        int intervalIndex = 0;
        while (intervalIndex < this.size()) {
            Interval interval = (Interval)this.get(intervalIndex);
            buffer.append(MathUtils.toString(interval.getMin()));
            buffer.append(" ");
            if (intervalIndex == this.size() - 1) {
                buffer.append(MathUtils.toString(interval.getMax()));
            }
            ++intervalIndex;
        }
        String result = buffer.toString();
        return result;
    }

    public String toStepString() {
        StringList buffer = new StringList();
        buffer.append("(");
        int intervalIndex = 0;
        while (intervalIndex < this.size()) {
            Interval interval = (Interval)this.get(intervalIndex);
            buffer.append(MathUtils.toString(interval.getMin()));
            buffer.append(",");
            if (intervalIndex == this.size() - 1) {
                buffer.append(MathUtils.toString(interval.getMax()));
            }
            ++intervalIndex;
        }
        buffer.append(")");
        String result = buffer.toString();
        return result;
    }

    @Override
    public String toString() {
        StringList buffer = new StringList();
        for (Interval interval : this) {
            buffer.append(interval.toString());
        }
        String result = buffer.toString();
        return result;
    }
}

