/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net.workers;

import org.apache.commons.lang3.StringUtils;

public class AttributeType {
    private Scope scope;
    private String relationModelName;

    public AttributeType(Scope scope) {
        this.scope = scope;
        this.relationModelName = null;
    }

    public AttributeType(String relationModelName) {
        if (StringUtils.isBlank((CharSequence)relationModelName)) {
            throw new IllegalArgumentException("Blank parameter relationModelName.");
        }
        this.scope = Scope.RELATION;
        this.relationModelName = relationModelName;
    }

    public String getRelationModelName() {
        return this.relationModelName;
    }

    public Scope getScope() {
        return this.scope;
    }

    public boolean isActors() {
        boolean result = AttributeType.isActors(this);
        return result;
    }

    public boolean isCorpus() {
        boolean result = AttributeType.isCorpus(this);
        return result;
    }

    public boolean isFamilies() {
        boolean result = AttributeType.isFamilies(this);
        return result;
    }

    public boolean isIndividuals() {
        boolean result = AttributeType.isIndividuals(this);
        return result;
    }

    public boolean isRelation() {
        boolean result = AttributeType.isRelation(this);
        return result;
    }

    public void setRelationModelName(String relationModelName) {
        this.relationModelName = relationModelName;
    }

    public void setScope(Scope scope) {
        this.scope = scope;
    }

    public static boolean isActors(AttributeType source) {
        boolean result = source != null && source.getScope() == Scope.ACTORS;
        return result;
    }

    public static boolean isCanonical(AttributeType source) {
        boolean result;
        if (source == null) {
            result = false;
        } else {
            switch (source.getScope()) {
                case CORPUS: 
                case INDIVIDUALS: 
                case FAMILIES: {
                    result = true;
                    break;
                }
                default: {
                    result = false;
                }
            }
        }
        return result;
    }

    public static boolean isCorpus(AttributeType source) {
        boolean result = source != null && source.getScope() == Scope.CORPUS;
        return result;
    }

    public static boolean isFamilies(AttributeType source) {
        boolean result = source != null && source.getScope() == Scope.FAMILIES;
        return result;
    }

    public static boolean isIndividuals(AttributeType source) {
        boolean result = source != null && source.getScope() == Scope.INDIVIDUALS;
        return result;
    }

    public static boolean isRelation(AttributeType source) {
        boolean result = source != null && source.getScope() == Scope.RELATION;
        return result;
    }

    public static enum Scope {
        CORPUS,
        INDIVIDUALS,
        FAMILIES,
        RELATION,
        ACTORS;

    }
}

