/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.matrix;

import java.util.ArrayList;
import org.tip.puck.graphs.random.DistributionType;
import org.tip.puck.matrix.Matrix;
import umontreal.iro.lecuyer.randvar.ParetoGen;
import umontreal.iro.lecuyer.randvar.PowerGen;
import umontreal.iro.lecuyer.randvar.RandomVariateGen;
import umontreal.iro.lecuyer.rng.RandomStream;
import umontreal.iro.lecuyer.rng.WELL607;

public class RandomMatrix
extends Matrix {
    private boolean comment = false;
    private RandomVariateGen rvg;
    private ArrayList<Integer> rowIndex;
    private ArrayList<Integer> columnIndex;
    private int[][] countdown;
    private DistributionType dist;

    public RandomMatrix(Matrix m, boolean exactSums) {
        super(m.getRowDim());
        this.sum = m.getSum();
        this.index = m.index;
        if (exactSums) {
            this.rows = m.rows;
            this.columns = m.columns;
            this.initialize();
            this.redistribute();
        } else {
            this.map = m.map;
            this.fill();
        }
        if (!this.comment) {
            return;
        }
        this.comment("The resulting matrix");
        int i = 0;
        while (i < this.matrix.length) {
            String s = "";
            int j = 0;
            while (j < this.matrix.length) {
                s = String.valueOf(s) + this.matrix[i][j] + "\t";
                ++j;
            }
            this.comment(s);
            ++i;
        }
    }

    private void comment(String s) {
        if (this.comment) {
            System.out.println(s);
        }
    }

    private void draw() {
        int a = (int)(Math.random() * (double)this.rowIndex.size());
        int b = (int)(Math.random() * (double)this.columnIndex.size());
        int i = this.rowIndex.get(a);
        int j = this.columnIndex.get(b);
        int[] nArray = this.matrix[i];
        int n = j;
        nArray[n] = nArray[n] + 1;
        int[] nArray2 = this.countdown[0];
        int n2 = i;
        nArray2[n2] = nArray2[n2] - 1;
        int[] nArray3 = this.countdown[1];
        int n3 = j;
        nArray3[n3] = nArray3[n3] - 1;
        if (this.countdown[0][i] == 0) {
            this.rowIndex.remove(a);
        }
        if (this.countdown[1][j] == 0) {
            this.columnIndex.remove(b);
        }
    }

    private void fill() {
        int k = 0;
        while (k < this.sum) {
            int[] i = new int[2];
            if (this.map == null) {
                i = new int[]{(int)(Math.random() * (double)this.getRowDim()), (int)(Math.random() * (double)this.getColDim())};
            } else {
                int d = (int)(Math.random() * (double)this.sum * (double)this.sum);
                i = (int[])this.map.get(this.map.ceilingKey(d));
            }
            this.augment(i[0], i[1]);
            ++k;
        }
    }

    public void augment(int i, int j) {
        int[] nArray = this.matrix[i];
        int n = j;
        nArray[n] = nArray[n] + 1;
        if (this.dist != null) {
            return;
        }
        int n2 = i;
        this.rows[n2] = this.rows[n2] + 1;
        int n3 = j;
        this.columns[n3] = this.columns[n3] + 1;
    }

    private void fill(int[] a, DistributionType dist) {
        int n = a.length;
        if (dist == DistributionType.BERNOULLI) {
            int k = 0;
            while (k < this.sum) {
                int i;
                int n2 = i = (int)((double)n * Math.random());
                a[n2] = a[n2] + 1;
                ++k;
            }
        } else {
            int i = 0;
            while (i < n) {
                a[i] = (int)this.rvg.nextDouble();
                ++i;
            }
        }
    }

    private void initialize() {
        this.rowIndex = new ArrayList();
        this.columnIndex = new ArrayList();
        this.countdown = new int[2][this.getRowDim()];
        int i = 0;
        while (i < this.getRowDim()) {
            if (this.rows[i] + this.columns[i] >= 2) {
                if (this.rows[i] > 0) {
                    this.rowIndex.add(i);
                }
                if (this.columns[i] > 0) {
                    this.columnIndex.add(i);
                }
                this.countdown[0][i] = this.rows[i];
                this.countdown[1][i] = this.columns[i];
            }
            ++i;
        }
    }

    private void redistribute() {
        while (this.rowIndex.size() > 0 && this.columnIndex.size() > 0) {
            this.draw();
        }
    }

    private void setRandomVariateGenerator(DistributionType dist, int vertices, int factor) {
        WELL607 s = new WELL607();
        switch (dist) {
            case PARETO: {
                double b = this.sum / vertices * (factor + 1) / factor;
                this.rvg = new PowerGen((RandomStream)s, 0.0, b, (double)factor);
            }
            case POWER: {
                this.rvg = new ParetoGen((RandomStream)s, -1.0 - (double)factor, 1.0);
            }
        }
    }
}

