/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.kinoath;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckException;
import org.tip.puck.kinoath.IndividualGroup;
import org.tip.puck.kinoath.IndividualGroups;
import org.tip.puck.segmentation.Segment;

public class SegmentationWorker {
    private static final Logger logger = LoggerFactory.getLogger(SegmentationWorker.class);

    public static IndividualGroups convert(Segment source) {
        IndividualGroups result = new IndividualGroups();
        if (source != null) {
            int currentClusterIndex = source.getCurrentClusterIndex();
            logger.debug("Initial index=" + currentClusterIndex);
            logger.debug("Cluster count=" + source.getClusterCount());
            try {
                try {
                    int clusterIndex = 0;
                    while (clusterIndex < source.getClusterCount()) {
                        source.selectCluster(clusterIndex);
                        IndividualGroup group = new IndividualGroup(result.size() + 1, source.getLabel());
                        group.put(source.getCurrentIndividuals());
                        result.add(group);
                        ++clusterIndex;
                    }
                    source.selectOutOfPartitionCluster();
                    IndividualGroup group = new IndividualGroup(result.size() + 1, source.getLabel());
                    group.put(source.getCurrentIndividuals());
                    result.add(group);
                }
                catch (PuckException exception) {
                    exception.printStackTrace();
                    try {
                        source.selectCluster(currentClusterIndex);
                        logger.debug("Initial index set.");
                    }
                    catch (PuckException exception2) {
                        logger.debug("Very embarassing");
                        exception2.printStackTrace();
                    }
                }
            }
            finally {
                try {
                    source.selectCluster(currentClusterIndex);
                    logger.debug("Initial index set.");
                }
                catch (PuckException exception) {
                    logger.debug("Very embarassing");
                    exception.printStackTrace();
                }
            }
        }
        return result;
    }
}

