/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.geo2;

import fr.devinsy.util.StringList;
import fr.devinsy.util.StringSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.geo2.IndexOfToponyms;
import org.tip.puck.geo2.Place2;
import org.tip.puck.geo2.Places2;
import org.tip.puck.net.Attributes;

public class Geography2 {
    private static final Logger logger = LoggerFactory.getLogger(Geography2.class);
    private String label;
    private Places2 places = new Places2();
    private IndexOfToponyms indexOfToponyms = new IndexOfToponyms();
    private Attributes attributes = new Attributes();

    public Place2 addPlace(Place2 place) {
        if (place != null) {
            this.places.add(place);
            this.indexOfToponyms.index(place);
        }
        return place;
    }

    public Attributes attributes() {
        return this.attributes;
    }

    public void clear() {
        this.label = "";
        this.attributes.clear();
        this.places.clear();
        this.indexOfToponyms.clear();
    }

    public boolean contains(String toponym) {
        boolean result = toponym == null ? false : this.get(toponym) != null;
        return result;
    }

    public int countOfConflictedPlaces() {
        int result = this.getConflictedPlaces().size();
        return result;
    }

    public int countOfGeocodedPlaces() {
        int result = this.getGeocodedPlaces().size();
        return result;
    }

    public int countOfHomonyms() {
        int result = 0;
        for (Place2 place : this.places) {
            result += place.getHomonyms().size();
        }
        return result;
    }

    public int countOfPlaces() {
        int result = this.places.size();
        return result;
    }

    public int countOfSingleHomonyms() {
        int result = this.getHomonyms().size();
        return result;
    }

    public int countOfToponyms() {
        int result = this.indexOfToponyms.size();
        return result;
    }

    public int countOfUngeocodedPlaces() {
        int result = this.getUngeocodedPlaces().size();
        return result;
    }

    public Place2 get(String toponym) {
        Place2 result = toponym == null ? null : this.indexOfToponyms.get(toponym);
        return result;
    }

    public Places2 getBlankPlaces() {
        Places2 result = new Places2();
        for (Place2 place : this.places) {
            if (!StringUtils.isBlank((CharSequence)place.getComment()) || !place.getHomonyms().isEmpty() || place.getCoordinate() != null) continue;
            result.add(place);
        }
        return result;
    }

    public Places2 getConflictedPlaces() {
        HashSet<Place2> conflictedPlaces = new HashSet<Place2>();
        for (Place2 place : this.places) {
            StringList names = new StringList(1 + place.getHomonyms().size());
            names.add((Object)place.getToponym());
            names.addAll((Collection)((Object)place.getHomonyms()));
            for (String name : names) {
                Place2 reference = this.indexOfToponyms.get(name);
                if (reference == place || reference == null) continue;
                conflictedPlaces.add(reference);
                conflictedPlaces.add(place);
            }
        }
        Places2 result = new Places2();
        for (Place2 place : conflictedPlaces) {
            result.add(place);
        }
        return result;
    }

    public Places2 getGeocodedPlaces() {
        Places2 result = new Places2();
        for (Place2 place : this.places) {
            if (place.getCoordinate() == null) continue;
            result.add(place);
        }
        return result;
    }

    public StringList getHomonyms() {
        StringSet names = new StringSet();
        for (Place2 place : this.places) {
            names.addAll((Collection)((Object)place.getHomonyms()));
        }
        StringList result = names.toStringList();
        return result;
    }

    public String getLabel() {
        return this.label;
    }

    public StringSet getMainToponyms() {
        StringSet result = new StringSet();
        for (Place2 place : this.places) {
            result.add(place.getToponym());
        }
        return result;
    }

    public Places2 getPlaces() {
        Places2 result = new Places2(this.places);
        return result;
    }

    public Status getStatus() {
        Status result = this.isLacking() ? (this.isConflicted() ? Status.UNWORKABLE : (this.countOfUngeocodedPlaces() == this.countOfPlaces() ? Status.UNWORKABLE : Status.WORKABLE)) : (this.isConflicted() ? Status.UNWORKABLE : (this.isEmpty() ? Status.UNWORKABLE : Status.COMPLETE));
        return result;
    }

    public StringList getToponyms() {
        StringList result = new StringList();
        for (String toponym : this.indexOfToponyms.getToponyms()) {
            result.add((Object)toponym);
        }
        return result;
    }

    public Places2 getUngeocodedPlaces() {
        Places2 result = new Places2();
        for (Place2 place : this.places) {
            if (place.getCoordinate() != null) continue;
            result.add(place);
        }
        return result;
    }

    public boolean isConflicted() {
        boolean ended = false;
        StringSet toponyms = new StringSet();
        Iterator iterator = this.places.iterator();
        boolean result = true;
        while (!ended) {
            if (iterator.hasNext()) {
                Place2 place = (Place2)iterator.next();
                if (toponyms.contains((Object)place.getToponym())) {
                    ended = true;
                    result = true;
                    continue;
                }
                boolean ended2 = false;
                Iterator iterator2 = place.getHomonyms().iterator();
                while (!ended2) {
                    if (iterator2.hasNext()) {
                        String homonym = (String)iterator2.next();
                        if (!toponyms.contains((Object)homonym)) continue;
                        ended2 = true;
                        ended = true;
                        result = true;
                        continue;
                    }
                    ended2 = true;
                    toponyms.put(place.getToponym());
                    toponyms.put((StringList)place.getHomonyms());
                }
                continue;
            }
            ended = true;
            result = false;
        }
        return result;
    }

    public boolean isEmpty() {
        boolean result = this.places.isEmpty();
        return result;
    }

    public boolean isLacking() {
        boolean result = false;
        boolean ended = false;
        Iterator iterator = this.places.iterator();
        while (!ended) {
            if (iterator.hasNext()) {
                Place2 place = (Place2)iterator.next();
                if (place.getCoordinate() != null) continue;
                ended = true;
                result = true;
                continue;
            }
            ended = true;
            result = false;
        }
        return result;
    }

    public boolean isNotConflicted() {
        boolean result = !this.isConflicted();
        return result;
    }

    public boolean isNotLacking() {
        boolean result = !this.isLacking();
        return result;
    }

    public boolean isVoid() {
        boolean result = this.places.isEmpty() && this.attributes.isEmpty();
        return result;
    }

    public void rebuildIndexes() {
        this.indexOfToponyms.clear();
        this.indexOfToponyms.index(this.places);
    }

    public void removePlace(Place2 place) {
        this.places.remove(place);
        this.rebuildIndexes();
    }

    public Place2 searchByToponym(String toponym) {
        Place2 result = toponym == null ? null : this.indexOfToponyms.get(toponym);
        return result;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public static enum Status {
        PERFECT,
        COMPLETE,
        WORKABLE,
        UNWORKABLE;

    }
}

