/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.evo;

import java.util.Vector;
import org.tip.puck.evo.EvoGen;
import org.tip.puck.evo.Generator;
import org.tip.puck.evo.PopGenerator;
import org.tip.puck.util.RandomGenerator;

public class Tournament
implements PopGenerator {
    private int popSize;
    private int tournamentSize;
    private double recombProb;
    private double mutProb;

    public Tournament(int popSize, int tournamentSize, double mutProb, double recombProb) {
        this.popSize = popSize;
        this.tournamentSize = tournamentSize;
        this.mutProb = mutProb;
        this.recombProb = recombProb;
    }

    @Override
    public int popSize() {
        return this.popSize;
    }

    @Override
    public Vector<Generator> newGeneration(EvoGen evo) {
        Vector<Generator> newPopulation = new Vector<Generator>();
        int j = 0;
        while (j < evo.getPopulationSize()) {
            Generator child;
            Generator parent1 = this.selectParent(evo);
            if (RandomGenerator.instance().random.nextDouble() < this.recombProb) {
                Generator parent2 = this.selectParent(evo);
                child = parent1.recombine(parent2);
            } else {
                child = parent1.cloneProgs();
            }
            if (RandomGenerator.instance().random.nextDouble() < this.mutProb) {
                Generator childm;
                parent1 = child.clone();
                parent1.initProgsRandom();
                child = childm = child.recombine(parent1);
            }
            newPopulation.add(child);
            ++j;
        }
        return newPopulation;
    }

    private Generator selectParent(EvoGen evo) {
        int bestIndex = -1;
        double bestFitness = 0.0;
        int i = 0;
        while (i < this.tournamentSize) {
            int index = RandomGenerator.instance().random.nextInt(evo.getPopulationSize());
            if (i == 0 || evo.getPopulation().get((int)index).postFitness < bestFitness) {
                bestFitness = evo.getPopulation().get((int)index).postFitness;
                bestIndex = index;
            }
            ++i;
        }
        return evo.getPopulation().get(bestIndex);
    }

    @Override
    public String infoString() {
        String tmpstr = "";
        tmpstr = String.valueOf(tmpstr) + "Algorithm: Genetic Algorithm with Tournament Selection\n";
        tmpstr = String.valueOf(tmpstr) + "recombination probability: " + this.recombProb + "\n";
        tmpstr = String.valueOf(tmpstr) + "mutation probability: " + this.mutProb + "\n";
        return tmpstr;
    }
}

