/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net.relations.workers;

import fr.devinsy.util.StringList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang3.ArrayUtils;
import org.tip.puck.PuckException;
import org.tip.puck.census.chains.Chain;
import org.tip.puck.census.chains.Notation;
import org.tip.puck.census.workers.CensusCriteria;
import org.tip.puck.census.workers.CircuitFinder;
import org.tip.puck.graphs.Graph;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Individuals;
import org.tip.puck.net.Net;
import org.tip.puck.net.relations.Actor;
import org.tip.puck.net.relations.Actors;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.net.relations.RelationModel;
import org.tip.puck.net.relations.Relations;
import org.tip.puck.net.relations.Role;
import org.tip.puck.net.relations.workers.AddChildRolesCriteria;
import org.tip.puck.net.relations.workers.RelationValuator;
import org.tip.puck.net.workers.IndividualValuator;
import org.tip.puck.net.workers.NetUtils;
import org.tip.puck.partitions.Cluster;
import org.tip.puck.segmentation.Segmentation;
import org.tip.puck.util.MathUtils;
import org.tip.puck.util.ToolBox;
import org.tip.puck.util.Value;

public class RelationWorker {
    public static void addChildRoles(Net net, AddChildRolesCriteria criteria) {
        if (net != null && criteria != null) {
            RelationModel model = net.relationModels().getByName(criteria.getRelationModelName());
            String egoRoleName = criteria.getEgoRoleName();
            StringList roleNames = criteria.getAlterRoleNames();
            int maxAge = criteria.getMaxAge();
            String dateLabel = criteria.getDateLabel();
            if (model != null) {
                model.roles().add(new Role(String.valueOf(egoRoleName) + "_CHILD", 0));
                Relations relations = net.relations().getByModel(model);
                for (Relation event : relations) {
                    Integer eventYear;
                    if (RelationValuator.isBirth(event) || RelationValuator.isDeath(event) || (eventYear = IndividualValuator.extractYearAsInt(event.getAttributeValue(dateLabel))) == null) continue;
                    for (Actor actor : event.actors().toList()) {
                        Individual ego;
                        int age;
                        if (!actor.getRole().getName().equals(egoRoleName) || (age = IndividualValuator.ageAtYear(ego = actor.getIndividual(), eventYear).intValue()) <= -1 || age >= maxAge || !event.getRoleNames(ego).contains(egoRoleName) || RelationValuator.isBirth(event) || RelationValuator.isDeath(event)) continue;
                        for (String alterRoleName : roleNames) {
                            if (event.getIndividuals(alterRoleName).contains(ego.getFather()) || event.getIndividuals(alterRoleName).contains(ego.getMother())) continue;
                            event.actors().add(new Actor(ego, new Role(String.valueOf(egoRoleName) + "_CHILD")));
                        }
                    }
                }
            }
        }
    }

    private static Set<List<String>> getLinkChains(List<String> ancestorList, Actor referent, Actors ascendants, Relation relation, String treeType, int[] maxDegrees) {
        HashSet<List<String>> result = new HashSet<List<String>>();
        Actors dependants = relation.getDependants(referent);
        ascendants.add(referent);
        if (dependants.size() > 0) {
            for (Actor descendant : dependants) {
                if (ascendants.contains(descendant)) {
                    System.err.println("Cyclic referent structure : " + referent + " for " + descendant + " " + referent + " in " + relation);
                    continue;
                }
                ArrayList<String> list = new ArrayList<String>();
                list.addAll(ancestorList);
                Individual individual = descendant.getIndividual();
                if (treeType.equals("GENDER")) {
                    list.add(String.valueOf(individual.getGender().toChar()));
                } else if (treeType.equals("ID")) {
                    list.add(String.valueOf(individual.getId()));
                } else if (treeType.equals("KIN")) {
                    list.add(String.valueOf(individual.getGender().toChar()));
                }
                for (List<String> chain : RelationWorker.getLinkChains(list, descendant, ascendants, relation, treeType, maxDegrees)) {
                    result.add(chain);
                }
            }
        } else {
            result.add(ancestorList);
        }
        return result;
    }

    public static Set<List<String>> getLinkChains(Relation relation, String treeType, String pattern) {
        HashSet<List<String>> result = new HashSet<List<String>>();
        int[] maxDegrees = ToolBox.stringsToInts(pattern);
        for (Actor actor : relation.actors()) {
            Individual referent = actor.getReferent();
            if (referent != null) continue;
            ArrayList<String> ancestorList = new ArrayList<String>();
            Individual individual = actor.getIndividual();
            if (treeType.equals("GENDER")) {
                ancestorList.add(String.valueOf(individual.getGender().toChar()));
            } else if (treeType.equals("ID")) {
                ancestorList.add(String.valueOf(individual.getId()));
            } else if (treeType.equals("KIN")) {
                ancestorList.add(String.valueOf(individual.getGender().toChar()));
            }
            for (List<String> chain : RelationWorker.getLinkChains(ancestorList, actor, new Actors(), relation, treeType, maxDegrees)) {
                result.add(chain);
            }
        }
        return result;
    }

    public static String getLinkChainsAsString(Relation relation, String treeType, String pattern) {
        String result = "";
        Set<List<String>> chains = RelationWorker.getLinkChains(relation, treeType, pattern);
        ArrayList<String> chainsAsStrings = new ArrayList<String>();
        for (List<String> chain : chains) {
            chainsAsStrings.add(chain.toString());
        }
        Collections.sort(chainsAsStrings);
        result = ((Object)chainsAsStrings).toString();
        return result;
    }

    private static String getLinkTree(Actor referent, Individuals ascendants, Relation relation, boolean reduced, String treeType, int[] maxDegrees) {
        String result = "";
        Actors dependants = relation.getDependants(referent);
        ascendants.add(referent.getIndividual());
        if (dependants.size() > 0) {
            result = "[";
            ArrayList<String> list = new ArrayList<String>();
            for (Actor descendant : dependants.toSortedList()) {
                if (ascendants.contains(descendant.getIndividual())) {
                    System.err.println("Cyclic referent structure : " + referent + " for " + descendant + " " + referent + " in " + relation);
                    continue;
                }
                String item = RelationWorker.getLinkTree(descendant, ascendants, relation, reduced, treeType, maxDegrees);
                if (treeType.equals("GENDER")) {
                    item = String.valueOf(descendant.getIndividual().getGender().toChar()) + item;
                } else if (treeType.equals("ID")) {
                    item = String.valueOf(descendant.getIndividual().getId()) + " " + item;
                } else if (treeType.equals("KIN")) {
                    item = String.valueOf(NetUtils.getAlterRole(descendant.getIndividual(), referent.getIndividual(), maxDegrees, null)) + " " + item;
                }
                if (reduced && list.contains(item)) continue;
                list.add(item);
            }
            for (String item : list) {
                result = String.valueOf(result) + item;
            }
            result = String.valueOf(result) + "]";
        }
        return result;
    }

    public static String getLinkTrees(Relation relation, boolean reduced, String treeType, String pattern) {
        String result = "";
        int[] maxDegrees = ToolBox.stringsToInts(pattern);
        ArrayList<String> list = new ArrayList<String>();
        if (relation != null) {
            for (Actor actor : relation.actors().toSortedList()) {
                Individual individual = actor.getIndividual();
                Individual referent = actor.getReferent();
                if (referent != null) continue;
                String item = RelationWorker.getLinkTree(actor, new Individuals(), relation, reduced, treeType, maxDegrees);
                if (treeType.equals("GENDER")) {
                    item = String.valueOf(individual.getGender().toChar()) + item;
                } else if (treeType.equals("ID")) {
                    item = String.valueOf(individual.getId()) + " " + item;
                } else if (treeType.equals("KIN")) {
                    item = String.valueOf(individual.getGender().toChar()) + " " + item;
                }
                if (reduced && list.contains(item)) continue;
                list.add(item);
            }
        }
        for (String item : list) {
            result = String.valueOf(result) + item + " ";
        }
        return result;
    }

    public static Graph<Individual> getReferentGraph(Relation relation) {
        Graph<Individual> result = new Graph<Individual>();
        if (relation != null) {
            for (Actor actor : relation.actors()) {
                Individual ego = actor.getIndividual();
                Individual alter = actor.getReferent();
                if (ego != null && alter != null) {
                    result.addArc(ego, alter, 1.0);
                    continue;
                }
                if (ego == null) continue;
                result.addNode(ego);
            }
            result.setLabel(relation.getName());
        }
        return result;
    }

    public static Map<String, Value> getAllKinCensus(Segmentation segmentation, Relation relation, CensusCriteria censusCriteria) {
        HashMap<String, Value> result = new HashMap<String, Value>();
        if (relation != null) {
            Segmentation domain = new Segmentation(relation.getIndividuals(), segmentation.getAllFamilies(), segmentation.getAllRelations());
            int size = relation.getIndividuals().size();
            try {
                CircuitFinder finder = new CircuitFinder(domain, censusCriteria);
                finder.findCircuits();
                for (Cluster<Chain> cluster : finder.getCircuits().getClusters()) {
                    result.put("" + cluster.getValue(), new Value(cluster.size()));
                    result.put(cluster.getValue() + "%", new Value(new Double(cluster.size()) / new Double(1.0 * (double)size * (double)(size - 1) / 2.0)));
                }
            }
            catch (PuckException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static Actor getClosestHomologue(Relation relation, Actor actor, String dateLabel, String direction) {
        Actor result = null;
        if (relation != null && actor != null) {
            Relation closestRelation = null;
            Integer date = relation.getTime(dateLabel);
            Integer closestDate = null;
            if (date != null) {
                for (Relation otherRelation : actor.getIndividual().relations().getByModel(relation.getModel())) {
                    Integer otherDate;
                    if (otherRelation.equals(relation) || (otherDate = otherRelation.getTime(dateLabel)) == null || (!direction.equals("OUT") || otherDate <= date || closestDate != null && otherDate >= closestDate) && (!direction.equals("IN") || otherDate >= date || closestDate != null && otherDate <= closestDate)) continue;
                    closestRelation = otherRelation;
                    closestDate = otherDate;
                }
                if (closestRelation != null) {
                    result = closestRelation.actors().get(actor.getIndividual().getId(), actor.getRole());
                }
            }
        }
        return result;
    }

    public static Map<String, Value> getReferentChainCensus(Relation relation, String affiliationLabel) {
        HashMap<String, Value> result = new HashMap<String, Value>();
        if (relation != null) {
            result.put("Types", Value.valueOf(RelationWorker.getReferentChainTypes(relation)));
            result.put("Types_Order", Value.valueOf(RelationWorker.getReferentChainTypeOrder(relation)));
            result.put("Types_Vector", Value.valueOf(Arrays.toString(RelationWorker.getReferentChainPercentageVector(relation))));
            for (Actor actor : relation.actors().toSortedList()) {
                String chain = RelationWorker.getReferentChainGenderString(actor, affiliationLabel, relation);
                Value count = (Value)result.get(chain);
                if (count == null) {
                    result.put(chain, new Value(1.0));
                    continue;
                }
                result.put(chain, new Value(((Value)result.get(chain)).doubleValue() + 1.0));
            }
        }
        return result;
    }

    public static String getReferentChainTypeOrder(Relation relation) {
        int[] vector = RelationWorker.getReferentChainVector(relation);
        TreeMap countMap = new TreeMap(Collections.reverseOrder());
        int i = 0;
        while (i < vector.length) {
            if (vector[i] != 0) {
                String numbers = (String)countMap.get(vector[i]);
                numbers = numbers == null ? String.valueOf(i) : String.valueOf(numbers) + "-" + i;
                countMap.put(vector[i], numbers);
            }
            ++i;
        }
        String result = "";
        for (String numbers : countMap.values()) {
            result = String.valueOf(result) + numbers + ">";
        }
        return result;
    }

    public static String getReferentChainTypes(Relation relation) {
        int[] vector = RelationWorker.getReferentChainVector(relation);
        String result = "";
        int i = 0;
        while (i < vector.length) {
            if (vector[i] != 0) {
                result = String.valueOf(result) + i + " ";
            }
            ++i;
        }
        return result;
    }

    public static int[] getReferentChainVector(Relation relation) {
        TreeMap<Integer, Integer> countMap = new TreeMap<Integer, Integer>();
        int max = -1;
        if (relation != null) {
            for (Actor actor : relation.actors().toSortedList()) {
                int number = RelationWorker.getReferentChainNumber(actor, relation);
                Object count = countMap.get(number);
                if (count == null) {
                    countMap.put(number, 1);
                } else {
                    countMap.put(number, (Integer)countMap.get(number) + 1);
                }
                if (number <= max) continue;
                max = number;
            }
        }
        int[] result = new int[max + 1];
        Iterator<Actor> iterator = countMap.keySet().iterator();
        while (iterator.hasNext()) {
            int key = (Integer)((Object)iterator.next());
            result[key] = (Integer)countMap.get(key);
        }
        return result;
    }

    public static double[] getReferentChainPercentageVector(Relation relation) {
        int[] vector = RelationWorker.getReferentChainVector(relation);
        double[] result = new double[vector.length];
        int sum = 0;
        int[] nArray = vector;
        int n = vector.length;
        int n2 = 0;
        while (n2 < n) {
            int number = nArray[n2];
            sum += number;
            ++n2;
        }
        int i = 0;
        while (i < vector.length) {
            result[i] = MathUtils.percent(vector[i], sum);
            ++i;
        }
        return result;
    }

    public static Chain getReferentChain(Actor actor, Relation relation) {
        Individual ego = actor.getIndividual();
        Individual alter = actor.getReferent();
        Individuals previous = new Individuals();
        previous.add(ego);
        Chain result = new Chain(ego);
        while (alter != null) {
            if (previous.contains(alter)) {
                System.err.println("Cyclic referent chain: " + previous);
                break;
            }
            result.add(alter, 1);
            Actor alterActor = relation.actors().get(alter.getId(), actor.getRole());
            if (alterActor != null) {
                previous.add(alter);
                ego = alter;
                alter = alterActor.getReferent();
                continue;
            }
            System.err.println("Nonresident referent for " + relation + "\t" + alter);
            alter = null;
        }
        return result;
    }

    public static String getReferentChainGenderString(Actor actor, String affiliationLabel, Relation relation) {
        String status;
        Chain chain = RelationWorker.getReferentChain(actor, relation);
        String result = chain.signature(Notation.POSITIONAL).replaceAll("\\(", "").replaceAll("\\)", "");
        if (result.length() > 0 && (status = RelationWorker.getHouseStatus(chain.getLast(), affiliationLabel, relation)) != null) {
            if (status.equals("OWNER")) {
                result = String.valueOf(result) + "*";
            } else if (status.equals("OWNER_SPOUSE")) {
                result = String.valueOf(result) + "\ufffd";
            }
        }
        return result;
    }

    public static int getReferentChainNumber(Actor actor, Relation relation) {
        Chain chain = RelationWorker.getReferentChain(actor, relation);
        int result = chain.getCharacteristicNumber();
        return result;
    }

    public static String getReferentChainGenderString1(Actor actor, String affiliationLabel, Relation relation) {
        Individual ego = actor.getIndividual();
        Individual alter = actor.getReferent();
        Individuals previous = new Individuals();
        previous.add(ego);
        String chain = String.valueOf(ego.getGender().toChar());
        if (alter == null) {
            String status = RelationWorker.getHouseStatus(ego, affiliationLabel, relation);
            if (status.equals("OWNER")) {
                chain = "+";
            } else if (status.equals("OWNER_SPOUSE")) {
                chain = "-";
            }
        }
        while (alter != null) {
            if (previous.contains(alter)) {
                System.err.println("Cyclic referent chain: " + previous);
                break;
            }
            chain = String.valueOf(chain) + alter.getGender().toChar();
            Actor alterActor = relation.actors().get(alter.getId(), actor.getRole());
            if (alterActor != null) {
                previous.add(alter);
                ego = alter;
                alter = alterActor.getReferent();
                if (alter != null) continue;
                String status = RelationWorker.getHouseStatus(ego, affiliationLabel, relation);
                if (status.equals("OWNER")) {
                    chain = String.valueOf(chain) + "+";
                    continue;
                }
                if (!status.equals("OWNER_SPOUSE")) continue;
                chain = String.valueOf(chain) + "-";
                continue;
            }
            System.err.println("Nonresident referent for " + relation + "\t" + alter);
            alter = null;
        }
        return chain;
    }

    private static String getHouseStatus(Individual ego, String affiliationLabel, Relation relation) {
        String egoAttributeValue = ego.getAttributeValue(affiliationLabel);
        String relationAttributeValue = relation.getAttributeValue(affiliationLabel);
        String result = "NONE";
        if (egoAttributeValue != null && egoAttributeValue.equals(relationAttributeValue)) {
            result = "OWNER";
        } else {
            for (Individual spouse : ego.spouses()) {
                String spouseAttributeValue = spouse.getAttributeValue(affiliationLabel);
                if (spouseAttributeValue == null || !spouseAttributeValue.equals(relationAttributeValue)) continue;
                result = "OWNER_SPOUSE";
                break;
            }
        }
        return result;
    }

    public static String getReferentRole(Actor actor, String pattern, String affiliationLabel, Relation relation) {
        int[] maxDegrees = ToolBox.stringsToInts(pattern);
        Individual ego = actor.getIndividual();
        Individual alter = actor.getReferent();
        String result = alter == null ? RelationWorker.getHouseStatus(ego, affiliationLabel, relation) : NetUtils.getAlterRole(ego, alter, maxDegrees, null);
        return result;
    }

    public static String getReferentRoleShort(Actor actor, String pattern, String affiliationLabel, Relation relation) {
        String result = RelationWorker.shortCut(RelationWorker.getReferentRole(actor, pattern, affiliationLabel, relation));
        return result;
    }

    public static Map<String, Value> getReferentKinCensus(Relation relation, String pattern, String affiliationLabel) {
        HashMap<String, Value> result = new HashMap<String, Value>();
        if (relation != null) {
            result.put("Types", Value.valueOf(RelationWorker.getReferentKinTypes(relation, pattern, affiliationLabel)));
            for (Actor actor : relation.actors().toSortedList()) {
                String alterRole = RelationWorker.getReferentRole(actor, pattern, affiliationLabel, relation);
                Value count = (Value)result.get(alterRole);
                if (count == null) {
                    result.put(alterRole, new Value(1.0));
                    continue;
                }
                result.put(alterRole, new Value(count.doubleValue() + 1.0));
            }
            for (String key : result.keySet()) {
                if (key.equals("Types")) continue;
                result.put(key, new Value(MathUtils.percent(((Value)result.get(key)).doubleValue(), (double)relation.actors().size())));
            }
        }
        return result;
    }

    private static String shortCut(String kinType) {
        String result = kinType.equals("AFFINE") ? "N" : (kinType.equals("RELATIVE_AGNATIC") ? "A" : (kinType.equals("RELATIVE_COGNATIC") ? "O" : (kinType.equals("RELATIVE_UTERINE") ? "U" : (kinType.equals("SIBLING") ? "G" : (kinType.equals("OWNER") ? "P" : (kinType.equals("OWNER_SPOUSE") ? "W" : (kinType.equals("UNRELATED") ? "X" : (kinType.equals("NONE") ? "Z" : String.valueOf(kinType.charAt(0))))))))));
        return result;
    }

    public static String getReferentKinTypes(Relation relation, String pattern, String affiliationLabel) {
        String result = "";
        HashSet<String> kinTypes = new HashSet<String>();
        if (relation != null) {
            for (Actor actor : relation.actors().toSortedList()) {
                kinTypes.add(RelationWorker.getReferentRoleShort(actor, pattern, affiliationLabel, relation));
            }
        }
        ArrayList kinTypesList = new ArrayList(kinTypes);
        Collections.sort(kinTypesList);
        for (String kinType : kinTypesList) {
            result = String.valueOf(result) + kinType + " ";
        }
        return result;
    }

    public static int[] getTransformation(Object[] first, Object[] second) {
        Object c;
        int[] result = new int[2];
        Object[] objectArray = first;
        int n = first.length;
        int n2 = 0;
        while (n2 < n) {
            c = objectArray[n2];
            if (!ArrayUtils.contains((Object[])second, (Object)c)) {
                result[0] = result[0] + 1;
            }
            ++n2;
        }
        objectArray = second;
        n = second.length;
        n2 = 0;
        while (n2 < n) {
            c = objectArray[n2];
            if (!ArrayUtils.contains((Object[])first, (Object)c)) {
                result[1] = result[1] + 1;
            }
            ++n2;
        }
        return result;
    }

    public static TransformationType getTransformationType(Object[] first, Object[] second) {
        int[] transformation = RelationWorker.getTransformation(first, second);
        TransformationType result = transformation[0] == 0 && transformation[1] > 0 ? TransformationType.GAIN : (transformation[0] > 0 && transformation[1] == 0 ? TransformationType.LOSS : (transformation[0] > 0 && transformation[1] > 0 ? TransformationType.CHANGE : TransformationType.CONSTANT));
        return result;
    }

    public static enum TransformationType {
        CONSTANT,
        GAIN,
        LOSS,
        CHANGE;

    }
}

