/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net.relations.roles;

import fr.devinsy.util.StringList;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckException;
import org.tip.puck.PuckExceptions;
import org.tip.puck.io.xls.XLSBufferedReader;
import org.tip.puck.io.xls.XLSWriter;
import org.tip.puck.net.relations.RelationModel;
import org.tip.puck.net.relations.roles.RoleRelationsTXTFile;
import org.tip.puck.report.Report;

public class RoleRelationsXLSFile {
    public static final int MAX_LINE_SIZE = 1024;
    private static final Logger logger = LoggerFactory.getLogger(RoleRelationsXLSFile.class);

    public static StringList load(File file) throws PuckException {
        StringList result;
        XLSBufferedReader in = null;
        try {
            try {
                in = new XLSBufferedReader(file);
                result = RoleRelationsTXTFile.read(in);
            }
            catch (UnsupportedEncodingException exception) {
                throw PuckExceptions.UNSUPPORTED_ENCODING.create(exception, "Opening file [" + file + "]", new Object[0]);
            }
            catch (FileNotFoundException exception) {
                throw PuckExceptions.FILE_NOT_FOUND.create(exception, "Opening file [" + file + "]", new Object[0]);
            }
            catch (IOException exception) {
                throw PuckExceptions.IO_ERROR.create(exception, "Opening file [" + file + "]", new Object[0]);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)in);
        return result;
    }

    public static Report save(File file, RelationModel source) throws PuckException, IOException {
        Report result;
        PrintWriter out = null;
        try {
            try {
                out = new PrintWriter(new XLSWriter(file, "Term Definitions"));
                result = RoleRelationsTXTFile.write(out, source);
            }
            catch (UnsupportedEncodingException exception) {
                throw PuckExceptions.UNSUPPORTED_ENCODING.create("Opening file [" + file + "]", new Object[0]);
            }
            catch (FileNotFoundException exception) {
                throw PuckExceptions.FILE_NOT_FOUND.create("Opening file [" + file + "]", new Object[0]);
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        return result;
    }

    protected static enum Status {
        MANDATORY,
        OPTIONAL;

    }
}

