/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.tip.puck.net.Gender;
import org.tip.puck.net.Individual;
import org.tip.puck.net.workers.IndividualValuator;
import org.tip.puck.util.MathUtils;
import org.tip.puck.util.PuckUtils;

public class IndividualComparator
implements Comparator<Individual> {
    private Sorting sorting;
    private List<Sorting> multiSorting;

    public IndividualComparator(List<Sorting> multiSorting) {
        this.multiSorting = multiSorting;
    }

    public IndividualComparator(Sorting ... sortings) {
        if (sortings == null || sortings.length == 0) {
            this.sorting = null;
            this.multiSorting = null;
        } else if (sortings.length == 1) {
            this.sorting = sortings[0];
            this.multiSorting = null;
        } else {
            this.sorting = null;
            this.multiSorting = new ArrayList<Sorting>(sortings.length);
            this.multiSorting.add(this.sorting);
            Sorting[] sortingArray = sortings;
            int n = sortings.length;
            int n2 = 0;
            while (n2 < n) {
                Sorting item = sortingArray[n2];
                this.multiSorting.add(item);
                ++n2;
            }
        }
    }

    @Override
    public int compare(Individual alpha, Individual bravo) {
        int result;
        if (this.multiSorting == null) {
            result = IndividualComparator.compare(alpha, bravo, this.sorting);
        } else {
            result = 0;
            for (Sorting currentSorting : this.multiSorting) {
                result = IndividualComparator.compare(alpha, bravo, currentSorting);
                if (result != 0) break;
            }
        }
        return result;
    }

    public static int compare(Individual alpha, Individual bravo, Sorting sorting) {
        int result;
        if (sorting == null) {
            result = 0;
        } else {
            switch (sorting) {
                case ID: {
                    result = MathUtils.compare(IndividualComparator.getId(alpha), IndividualComparator.getId(bravo));
                    break;
                }
                case FIRSTN: {
                    result = PuckUtils.compare(IndividualComparator.getFirstName(alpha), IndividualComparator.getFirstName(bravo));
                    break;
                }
                case LASTN: {
                    result = PuckUtils.compare(IndividualComparator.getLastName(alpha), IndividualComparator.getLastName(bravo));
                    break;
                }
                case GENDER: {
                    result = Gender.compare(IndividualComparator.getGender(alpha), IndividualComparator.getGender(bravo));
                    break;
                }
                case BIRT_YEAR: {
                    Integer firstBirtYear = IndividualValuator.getBirthYear(alpha);
                    Integer secondBirtYear = IndividualValuator.getBirthYear(bravo);
                    if (firstBirtYear == null && secondBirtYear == null) {
                        result = 0;
                        break;
                    }
                    if (firstBirtYear == null) {
                        result = -1;
                        break;
                    }
                    if (secondBirtYear == null) {
                        result = 1;
                        break;
                    }
                    result = firstBirtYear.compareTo(secondBirtYear);
                    break;
                }
                case AGE: {
                    result = -IndividualComparator.compare(alpha, bravo, Sorting.BIRT_YEAR);
                    break;
                }
                case BIRTH_ORDER: {
                    result = MathUtils.compareOrder(alpha.getBirthOrder(), bravo.getBirthOrder());
                    break;
                }
                case BIRTH_YEAR_OR_ORDER: {
                    result = IndividualComparator.compare(alpha, bravo, Sorting.BIRT_YEAR);
                    if (result != 0) break;
                    result = IndividualComparator.compare(alpha, bravo, Sorting.BIRTH_ORDER);
                    break;
                }
                default: {
                    result = new Integer(alpha.getId()).compareTo(bravo.getId());
                }
            }
        }
        return result;
    }

    public static Integer getBirthOrder(Individual source) {
        Integer result = source == null ? null : source.getBirthOrder();
        return result;
    }

    public static String getFirstName(Individual source) {
        String result = source == null ? null : source.getFirstName();
        return result;
    }

    public static Gender getGender(Individual source) {
        Gender result = source == null ? null : source.getGender();
        return result;
    }

    public static Integer getId(Individual source) {
        Integer result = source == null ? null : Integer.valueOf(source.getId());
        return result;
    }

    public static String getLastName(Individual source) {
        String result = source == null ? null : source.getLastName();
        return result;
    }

    public static enum Sorting {
        ID,
        BIRT_YEAR,
        AGE,
        BIRTH_ORDER,
        BIRTH_YEAR_OR_ORDER,
        FIRSTN,
        GENDER,
        LASTN;

    }
}

