/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.evo;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Vector;
import org.tip.puck.evo.GPMemPool;
import org.tip.puck.evo.GPNode;
import org.tip.puck.evo.GPNodeDynStatus;
import org.tip.puck.evo.ProgSet;
import org.tip.puck.util.RandomGenerator;

public class GPTree {
    public double[] vars;
    private GPNode root;
    private int varcount;
    private Vector<Integer> funset;
    private int parsePos;

    public GPTree(int varcount, Vector<Integer> funset) {
        this.varcount = varcount;
        this.funset = funset;
        this.vars = new double[varcount];
        this.root = null;
    }

    private void destroyGPNode(GPNode node) {
        int i = 0;
        while (i < node.arity) {
            this.destroyGPNode(node.params[i]);
            ++i;
        }
        GPMemPool.instance().returnNode(node);
    }

    public double eval(int cycle) {
        GPNode curnode = this.root;
        curnode.curpos = -1;
        double val = 0.0;
        while (curnode != null) {
            ++curnode.curpos;
            if (curnode.curpos < curnode.stoppos) {
                if (curnode.curpos == curnode.condpos) {
                    switch (curnode.fun) {
                        case 4: {
                            if (curnode.params[0].val == curnode.params[1].curval) {
                                curnode.stoppos = 3;
                                break;
                            }
                            curnode.stoppos = 4;
                            ++curnode.curpos;
                            break;
                        }
                        case 5: {
                            if (curnode.params[0].curval > curnode.params[1].curval) {
                                curnode.stoppos = 3;
                                break;
                            }
                            curnode.stoppos = 4;
                            ++curnode.curpos;
                            break;
                        }
                        case 6: {
                            if (curnode.params[0].curval < curnode.params[1].curval) {
                                curnode.stoppos = 3;
                                break;
                            }
                            curnode.stoppos = 4;
                            ++curnode.curpos;
                            break;
                        }
                        case 7: {
                            if (curnode.params[0].curval == 0.0) {
                                curnode.stoppos = 2;
                                break;
                            }
                            curnode.stoppos = 3;
                            ++curnode.curpos;
                            break;
                        }
                    }
                    if (curnode.branching < 0) {
                        curnode.branching = curnode.stoppos;
                    } else if (curnode.branching != curnode.stoppos) {
                        curnode.branching = 0;
                    }
                }
                curnode = curnode.params[curnode.curpos];
                curnode.curpos = -1;
                continue;
            }
            block6 : switch (curnode.type) {
                case FUN: {
                    switch (curnode.fun) {
                        case 0: {
                            val = curnode.params[0].curval + curnode.params[1].curval;
                            break block6;
                        }
                        case 1: {
                            val = curnode.params[0].curval - curnode.params[1].curval;
                            break block6;
                        }
                        case 2: {
                            val = curnode.params[0].curval * curnode.params[1].curval;
                            break block6;
                        }
                        case 3: {
                            if (curnode.params[1].curval == 0.0) {
                                val = 0.0;
                                break block6;
                            }
                            val = curnode.params[0].curval / curnode.params[1].curval;
                            break block6;
                        }
                        case 11: {
                            val = curnode.params[0].curval;
                            if (!(curnode.params[1].curval < val)) break block6;
                            val = curnode.params[1].curval;
                            break block6;
                        }
                        case 12: {
                            val = curnode.params[0].curval;
                            if (!(curnode.params[1].curval > val)) break block6;
                            val = curnode.params[1].curval;
                            break block6;
                        }
                        case 8: {
                            val = Math.exp(curnode.params[0].curval);
                            break block6;
                        }
                        case 9: {
                            val = Math.log(curnode.params[0].curval);
                            break block6;
                        }
                        case 13: {
                            long r = Math.round(curnode.params[0].curval);
                            val = r % 2L;
                            break block6;
                        }
                        case 10: {
                            val = Math.abs(curnode.params[0].curval);
                            break block6;
                        }
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: {
                            val = curnode.params[curnode.stoppos - 1].curval;
                            break block6;
                        }
                    }
                    break;
                }
                case VAR: {
                    val = this.vars[curnode.var];
                    break;
                }
                case VAL: {
                    val = curnode.val;
                }
            }
            switch (curnode.dynStatus) {
                case UNUSED: {
                    curnode.dynStatus = GPNodeDynStatus.CONSTANT;
                    break;
                }
                case CONSTANT: {
                    if (curnode.curval == val) break;
                    curnode.dynStatus = GPNodeDynStatus.DYNAMIC;
                    break;
                }
            }
            ++curnode.evals;
            curnode.lastEval = cycle;
            curnode.curval = val;
            curnode = curnode.parent;
        }
        return val;
    }

    private void write2(GPNode node, int indent, OutputStreamWriter out, ProgSet progSet, boolean evalStats) throws IOException {
        int i;
        int ind = indent;
        if (node.arity > 0) {
            if (node.parent != null) {
                out.write("\n");
            }
            i = 0;
            while (i < indent) {
                out.write(" ");
                ++i;
            }
            out.write("(");
            ++ind;
        }
        node.write(out, progSet, evalStats);
        i = 0;
        while (i < node.arity) {
            out.write(" ");
            this.write2(node.params[i], ind, out, progSet, evalStats);
            ++i;
        }
        if (node.arity > 0) {
            out.write(")");
            --ind;
        }
    }

    public void write(OutputStreamWriter out, ProgSet progSet, boolean evalStats) throws IOException {
        this.write2(this.root, 0, out, progSet, evalStats);
        out.write("\n");
    }

    private GPNode initRandom2(double probTerm, GPNode parent, int maxDepth, boolean grow, int depth) {
        GPNode node;
        double p = RandomGenerator.instance().random.nextDouble();
        if ((!grow || p > probTerm) && depth < maxDepth) {
            int pos = RandomGenerator.instance().random.nextInt(this.funset.size());
            int fun = this.funset.get(pos);
            node = GPMemPool.instance().getNode();
            node.initFun(fun, parent);
            int i = 0;
            while (i < node.arity) {
                node.params[i] = this.initRandom2(probTerm, node, maxDepth, grow, depth + 1);
                ++i;
            }
        } else if (RandomGenerator.instance().random.nextBoolean() && this.varcount > 0) {
            int var = RandomGenerator.instance().random.nextInt(this.varcount);
            node = GPMemPool.instance().getNode();
            node.initVar(var, parent);
        } else {
            int r = RandomGenerator.instance().random.nextInt(10);
            double val = r == 0 ? 0.0 : (r > 5 ? (double)RandomGenerator.instance().random.nextInt(10) : RandomGenerator.instance().random.nextDouble());
            node = GPMemPool.instance().getNode();
            node.initVal(val, parent);
        }
        return node;
    }

    public void initRandom(double probTerm, int maxDepthLowLimit, int maxDepthHighLimit) {
        boolean grow = RandomGenerator.instance().random.nextBoolean();
        int max_depth = maxDepthLowLimit + RandomGenerator.instance().random.nextInt(maxDepthHighLimit - maxDepthLowLimit);
        this.root = this.initRandom2(probTerm, null, max_depth, grow, 0);
    }

    private GPNode cloneGPNode(GPNode node, GPNode parent) {
        GPNode cnode = GPMemPool.instance().getNode();
        switch (node.type) {
            case VAL: {
                cnode.initVal(node.val, parent);
                break;
            }
            case VAR: {
                cnode.initVar(node.var, parent);
                break;
            }
            default: {
                cnode.initFun(node.fun, parent);
            }
        }
        cnode.curval = node.curval;
        cnode.branching = node.branching;
        cnode.dynStatus = node.dynStatus;
        int i = 0;
        while (i < node.arity) {
            cnode.params[i] = this.cloneGPNode(node.params[i], cnode);
            ++i;
        }
        return cnode;
    }

    public GPTree clone() {
        GPTree ctree = new GPTree(this.varcount, this.funset);
        ctree.root = this.cloneGPNode(this.root, null);
        return ctree;
    }

    private int size2(GPNode node) {
        int c = 1;
        int i = 0;
        while (i < node.arity) {
            c += this.size2(node.params[i]);
            ++i;
        }
        return c;
    }

    public int size() {
        return this.size2(this.root);
    }

    private GPNode GPNodeByPos2(GPNode node, int pos, int[] curpos) {
        if (pos == curpos[0]) {
            return node;
        }
        curpos[0] = curpos[0] + 1;
        int i = 0;
        while (i < node.arity) {
            GPNode nodefound = this.GPNodeByPos2(node.params[i], pos, curpos);
            if (nodefound != null) {
                return nodefound;
            }
            ++i;
        }
        return null;
    }

    public GPNode GPNodeByPos(int pos) {
        int[] curpos = new int[]{0};
        return this.GPNodeByPos2(this.root, pos, curpos);
    }

    public GPTree recombine(GPTree parent2) {
        GPTree child = this.clone();
        int size1 = this.size();
        int size2 = parent2.size();
        int pos1 = RandomGenerator.instance().random.nextInt(size1);
        int pos2 = RandomGenerator.instance().random.nextInt(size2);
        GPNode point1 = child.GPNodeByPos(pos1);
        GPNode point2 = parent2.GPNodeByPos(pos2);
        GPNode point1parent = point1.parent;
        int parampos = 0;
        if (point1parent != null) {
            int i = 0;
            while (i < point1parent.arity) {
                if (point1parent.params[i] == point1) {
                    parampos = i;
                    break;
                }
                ++i;
            }
        }
        this.destroyGPNode(point1);
        GPNode point2clone = this.cloneGPNode(point2, point1parent);
        if (point1parent != null) {
            point1parent.params[parampos] = point2clone;
        } else {
            child.root = point2clone;
        }
        return child;
    }

    private int tokenEnd(String prog, int pos) {
        int curpos = pos;
        char curchar = prog.charAt(curpos);
        while (curchar != ' ' && curchar != '\n' && curchar != '\t' && curchar != '\r' && curchar != ')' && curchar != '(' && curchar != '\u0000') {
            if (++curpos >= prog.length()) {
                return curpos;
            }
            curchar = prog.charAt(curpos);
        }
        return curpos;
    }

    private int tokenStart(String prog) {
        int curpos = this.parsePos;
        char curchar = prog.charAt(curpos);
        while (curchar == ' ' || curchar == '\n' || curchar == '\t' || curchar == '\r' || curchar == ')' || curchar == '(' || curchar == '\u0000') {
            curchar = prog.charAt(++curpos);
        }
        return curpos;
    }

    /*
     * Unable to fully structure code
     */
    private GPNode parse2(String prog, GPNode parent, ProgSet progSet) {
        block31: {
            start = this.tokenStart(prog);
            end = this.tokenEnd(prog, start);
            token = prog.substring(start, end);
            node = GPMemPool.instance().getNode();
            try {
                val = new Double(token);
                node.initVal(val, parent);
                break block31;
            }
            catch (Exception e) {
                if (token.charAt(0) == '$') {
                    var = progSet.getVariableIndices().get(token.substring(1));
                    node.initVar(var, parent);
                    break block31;
                }
                fun = -1;
                if (token.equals("+")) {
                    fun = 0;
                } else if (token.equals("-")) {
                    fun = 1;
                } else if (token.equals("*")) {
                    fun = 2;
                } else if (token.equals("/")) {
                    fun = 3;
                } else if (token.equals("ZER")) {
                    fun = 7;
                } else if (token.equals("==")) {
                    fun = 4;
                } else if (token.equals(">")) {
                    fun = 5;
                } else if (token.equals("<")) {
                    fun = 6;
                } else if (token.equals("EXP")) {
                    fun = 8;
                } else if (token.equals("LOG")) {
                    fun = 9;
                } else if (token.equals("ODD")) {
                    fun = 13;
                } else if (token.equals("ABS")) {
                    fun = 10;
                } else if (token.equals("MIN")) {
                    fun = 11;
                } else if (token.equals("MAX")) {
                    fun = 12;
                }
                node.initFun(fun, parent);
                this.parsePos = end;
                i = 0;
                ** while (i < node.arity)
            }
lbl-1000:
            // 1 sources

            {
                node.params[i] = this.parse2(prog, node, progSet);
                ++i;
                continue;
            }
lbl63:
            // 1 sources

            return node;
        }
        this.parsePos = end;
        return node;
    }

    public void parse(String prog, ProgSet progSet) {
        this.parsePos = 0;
        this.root = this.parse2(prog, null, progSet);
    }

    private void clearBranching2(GPNode node) {
        node.branching = -1;
        int i = 0;
        while (i < node.arity) {
            this.clearBranching2(node.params[i]);
            ++i;
        }
    }

    public void clearBranching() {
        this.clearBranching2(this.root);
    }

    private void clearEvalStats2(GPNode node) {
        node.evals = 0;
        node.lastEval = -1;
        int i = 0;
        while (i < node.arity) {
            this.clearEvalStats2(node.params[i]);
            ++i;
        }
    }

    public void clearEvalStats() {
        this.clearEvalStats2(this.root);
    }

    public int branchingDistance(GPTree tree) {
        return this.branchingDistance2(this.root, tree.root);
    }

    private int branchingDistance2(GPNode node1, GPNode node2) {
        int distance = 0;
        if (node1.branching != node2.branching) {
            ++distance;
        }
        int i = 0;
        while (i < node1.arity) {
            distance += this.branchingDistance2(node1.params[i], node2.params[i]);
            ++i;
        }
        return distance;
    }

    private void moveUp(GPNode origNode, GPNode targNode) {
        switch (origNode.type) {
            case VAL: {
                targNode.initVal(origNode.val, origNode.parent);
                break;
            }
            case VAR: {
                targNode.initVar(origNode.var, origNode.parent);
                break;
            }
            default: {
                targNode.initFun(origNode.fun, origNode.parent);
            }
        }
        targNode.branching = origNode.branching;
        targNode.dynStatus = origNode.dynStatus;
        int i = 0;
        while (i < origNode.arity) {
            targNode.params[i] = origNode.params[i];
            targNode.params[i].parent = targNode;
            ++i;
        }
        GPMemPool.instance().returnNode(origNode);
    }

    public void dynPruning() {
        this.dynPruning2(this.root);
    }

    private void dynPruning2(GPNode node) {
        if (node.dynStatus == GPNodeDynStatus.CONSTANT) {
            int i = 0;
            while (i < node.arity) {
                this.destroyGPNode(node.params[i]);
                ++i;
            }
            node.initVal(node.curval, node.parent);
        }
        if (node.condpos > 0) {
            GPNode branch1 = node.params[node.condpos];
            GPNode branch2 = node.params[node.condpos + 1];
            int branch = -1;
            if (branch1.dynStatus == GPNodeDynStatus.UNUSED) {
                branch = node.condpos + 1;
            } else if (branch2.dynStatus == GPNodeDynStatus.UNUSED) {
                branch = node.condpos;
            }
            if (branch > 0) {
                int i = 0;
                while (i < node.arity) {
                    if (i != branch) {
                        this.destroyGPNode(node.params[i]);
                    }
                    ++i;
                }
                this.moveUp(node.params[branch], node);
            }
        }
        int i = 0;
        while (i < node.arity) {
            this.dynPruning2(node.params[i]);
            ++i;
        }
    }
}

