/*
 * Decompiled with CFR 0.152.
 */
package oldcore.visualization;

import org.gephi.graph.api.DirectedGraph;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.Node;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Individuals;
import org.tip.puck.net.Net;

public class Puck2GephiTranslator {
    Puck2GephiTranslator() {
    }

    public void translate(Net net, GraphModel grphMod) {
        DirectedGraph diGrph = grphMod.getDirectedGraph();
        for (Individual v : net.individuals()) {
            Node n = grphMod.factory().newNode(new Integer(v.getId()).toString());
            n.getNodeData().setLabel(v.getName());
            if (v.isMale()) {
                n.getNodeData().getAttributes().setValue("gender", (Object)"male");
            } else {
                n.getNodeData().getAttributes().setValue("gender", (Object)"female");
            }
            diGrph.addNode(n);
        }
        for (Individual v : net.individuals()) {
            Individuals sp;
            Node ego = diGrph.getNode(new Integer(v.getId()).toString());
            Individuals ch = v.children();
            if (ch != null && ch.size() > 0) {
                for (Individual vv : ch) {
                    Node child = diGrph.getNode(new Integer(vv.getId()).toString());
                    Edge e = grphMod.factory().newEdge(ego, child);
                    e.getEdgeData().getAttributes().setValue("tie type", (Object)"parental");
                    diGrph.addEdge(e);
                }
            }
            if ((sp = v.spouses()) == null || sp.size() <= 0) continue;
            for (Individual vv : sp) {
                Node spouse = diGrph.getNode(new Integer(vv.getId()).toString());
                Edge e = grphMod.factory().newEdge(ego, spouse);
                e.getEdgeData().getAttributes().setValue("tie type", (Object)"conjugal");
                diGrph.addEdge(e);
            }
        }
    }
}

