package org.tip.puck.net.workers;

import java.io.File;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 
 * @author cpm
 */
public class FileBatchConverterCriteria {

	public enum Mode {
		SKIP,
		OVERWRITE
	}

	public enum TargetFormat {
		BARODS(".bar.ods"),
		BARTXT(".bar.txt"),
		BARXLS(".bar.xls"),
		GEDCOM(".ged"),
		IURODS(".iur.ods"),
		IURTXT(".iur.txt"),
		IURXLS(".iur.xls"),
		IURTXTS(".iurs.txt"),
		PUC(".puc");

		private String extension;

		/**
		 * 
		 * @param extension
		 */
		private TargetFormat(final String extension) {
			this.extension = extension;
		}

		/**
		 * 
		 * @return
		 */
		public String getExtension() {
			return this.extension;
		}
	}

	private static final Logger logger = LoggerFactory.getLogger(FileBatchConverterCriteria.class);

	private File source;
	private File target;
	private TargetFormat targetFormat;
	private Mode mode;

	/**
	 * 
	 */
	public FileBatchConverterCriteria() {
		this.source = null;
		this.target = null;
		this.targetFormat = TargetFormat.PUC;
		this.mode = Mode.OVERWRITE;
	}

	public Mode getMode() {
		return this.mode;
	}

	public File getSourceDirectory() {
		return this.source;
	}

	public File getTargetDirectory() {
		return this.target;
	}

	public TargetFormat getTargetFormat() {
		return this.targetFormat;
	}

	public void setMode(final Mode mode) {
		this.mode = mode;
	}

	public void setSource(final File source) {
		this.source = source;
	}

	public void setTarget(final File target) {
		this.target = target;
	}

	public void setTargetFormat(final TargetFormat targetFormat) {
		this.targetFormat = targetFormat;
	}
}
