package org.tip.puck.geo2;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

import org.apache.commons.lang3.StringUtils;
import org.tip.puck.geo2.Place2Comparator.Sorting;

import fr.devinsy.util.StringSet;

/**
 * 
 */
public class Places2 extends ArrayList<Place2> {

	private static final long serialVersionUID = -8277613440390116082L;

	/**
	 * 
	 */
	public Places2() {
		super();
	}

	/**
	 * 
	 */
	public Places2(final int capacity) {
		super(capacity);
	}

	/**
	 * 
	 */
	public Places2(final Places2 source) {
		super();

		if (source != null) {
			//
			for (Place2 place : source) {
				//
				this.add(place);
			}
		}
	}

	/**
	 * 
	 * @param searchedName
	 * @return
	 */
	public Place2 getByToponym(final String searchedName) {
		Place2 result;

		boolean ended = false;
		Iterator<Place2> iterator = this.iterator();
		result = null;
		while (!ended) {
			//
			if (iterator.hasNext()) {

				Place2 current = iterator.next();

				if (StringUtils.equals(current.getToponym(), searchedName)) {
					//
					ended = true;
					result = current;
				}

			} else {
				//
				ended = true;
				result = null;
			}
		}

		//
		return result;
	}

	/**
	 * 
	 */
	public void sortByToponym() {
		//
		Collections.sort(this, new Place2Comparator(Sorting.TOPONYM));
	}

	/**
	 * 
	 * @return
	 */
	public StringSet toponyms() {
		StringSet result;

		result = new StringSet();

		for (Place2 place : this) {
			result.add(place.getToponym());
		}

		//
		return result;
	}
}
