/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.visualization.style.implementations;

import org.gephi.data.attributes.api.AttributeColumn;
import org.gephi.data.attributes.api.AttributeController;
import org.gephi.data.attributes.api.AttributeModel;
import org.gephi.data.attributes.api.AttributeOrigin;
import org.gephi.data.attributes.api.AttributeTable;
import org.gephi.data.attributes.api.AttributeType;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.Node;
import org.gephi.layout.plugin.forceAtlas2.ForceAtlas2;
import org.gephi.preview.api.PreviewController;
import org.gephi.preview.api.PreviewModel;
import org.gephi.project.api.Workspace;
import org.gephi.ranking.api.Ranking;
import org.gephi.ranking.api.RankingController;
import org.gephi.ranking.api.RankingModel;
import org.gephi.ranking.api.Transformer;
import org.gephi.ranking.plugin.transformer.AbstractSizeTransformer;
import org.openide.util.Lookup;
import org.tip.puck.graphs.Link;
import org.tip.puck.partitions.Cluster;
import org.tip.puck.visualization.style.Style;
import org.tip.puck.visualization.style.attributes.AttributeMap;
import org.tip.puck.visualization.style.attributes.GraphStyle;

public class CircuitIntersectionNetwork
implements Style {
    public static final String NODE_POPULATION_PROP = "population";
    public static final String DEFAULT_LABEL = "Default label";
    public static final String EDGE_WEIGHT_PROP = "weight";
    public static final int NODE_MINSIZE = 10;
    public static final int NODE_MAXSIZE = 50;
    public static final int EDGE_MINSIZE = 1;
    public static final int EDGE_MAXSIZE = 10;
    private final AttributeMap map = new AttributeMap(){

        @Override
        public void setAttributes(Node gephiNode, org.tip.puck.graphs.Node<?> graphNode) {
            Cluster referent = (Cluster)graphNode.getReferent();
            int size = referent.size();
            gephiNode.getNodeData().setSize(10.0f);
            gephiNode.getNodeData().getAttributes().setValue(CircuitIntersectionNetwork.NODE_POPULATION_PROP, (Object)Float.valueOf((float)size * 1.0f));
            String label = referent.getLabel();
            if (label != null) {
                gephiNode.getNodeData().setLabel(label);
            } else {
                gephiNode.getNodeData().setLabel(CircuitIntersectionNetwork.DEFAULT_LABEL);
            }
        }

        @Override
        public void setAttributes(Edge gephiEdge, Link<?> graphEdge) {
            double weight = graphEdge.getWeight();
            gephiEdge.setWeight((float)weight);
        }

        @Override
        public void registerAttributes(AttributeModel attributeModel) {
            AttributeTable table = attributeModel.getEdgeTable();
            table = attributeModel.getNodeTable();
            table.addColumn(CircuitIntersectionNetwork.NODE_POPULATION_PROP.toLowerCase(), CircuitIntersectionNetwork.NODE_POPULATION_PROP, AttributeType.FLOAT, AttributeOrigin.DATA, (Object)Float.valueOf(1.0f));
        }
    };

    @Override
    public GraphStyle graphStyle() {
        return GraphStyle.undirected;
    }

    @Override
    public AttributeMap styleMapping() {
        return this.map;
    }

    private void transformGraph(Workspace workspace) {
        AttributeModel attributeModel = ((AttributeController)Lookup.getDefault().lookup(AttributeController.class)).getModel(workspace);
        AttributeColumn populationColumn = attributeModel.getNodeTable().getColumn(NODE_POPULATION_PROP);
        RankingController rankingController = (RankingController)Lookup.getDefault().lookup(RankingController.class);
        RankingModel rankingModel = rankingController.getModel(workspace);
        Ranking populationRanking = rankingModel.getRanking("nodes", populationColumn.getId());
        AbstractSizeTransformer sizeTransformer = (AbstractSizeTransformer)rankingModel.getTransformer("nodes", "renderable_size");
        sizeTransformer.setMinSize(10.0f);
        sizeTransformer.setMaxSize(50.0f);
        rankingController.transform(populationRanking, (Transformer)sizeTransformer);
        AttributeColumn arcColumn = attributeModel.getEdgeTable().getColumn(EDGE_WEIGHT_PROP);
        Ranking arcRanking = rankingModel.getRanking("edges", arcColumn.getId());
        AbstractSizeTransformer sizeETransformer = (AbstractSizeTransformer)rankingModel.getTransformer("nodes", "renderable_size");
        sizeETransformer.setMinSize(1.0f);
        sizeETransformer.setMaxSize(10.0f);
        rankingController.transform(arcRanking, (Transformer)sizeETransformer);
    }

    @Override
    public void applyStyle(Workspace workspace) {
        this.transformGraph(workspace);
        PreviewController previewController = (PreviewController)Lookup.getDefault().lookup(PreviewController.class);
        PreviewModel previewModel = previewController.getModel(workspace);
        previewModel.getProperties().putValue("node.label.show", (Object)Boolean.TRUE);
        previewModel.getProperties().putValue("directed", (Object)Boolean.FALSE);
        previewModel.getProperties().putValue("edge.curved", (Object)Boolean.FALSE);
        previewController.refreshPreview(workspace);
        this.layout(workspace);
    }

    private void layout(Workspace workspace) {
        GraphModel graphModel = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getModel(workspace);
        ForceAtlas2 layout = new ForceAtlas2(null);
        layout.setGraphModel(graphModel);
        layout.resetPropertiesValues();
        layout.initAlgo();
        int i = 0;
        while (i < 50 && layout.canAlgo()) {
            layout.goAlgo();
            ++i;
        }
        layout.endAlgo();
    }
}

