/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.util;

import fr.devinsy.util.StringList;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.tip.puck.PuckException;
import org.tip.puck.PuckExceptions;

public class ToolBox {
    public static File addToName(File file, String addition) {
        File result;
        if (file == null) {
            result = null;
        } else if (addition == null) {
            result = file;
        } else {
            String sourceFileName = file.getAbsolutePath();
            int separatorIndex = sourceFileName.lastIndexOf(46);
            String targetFileName = separatorIndex > 0 ? String.valueOf(sourceFileName.substring(0, separatorIndex)) + addition + sourceFileName.substring(separatorIndex) : String.valueOf(sourceFileName) + addition;
            result = new File(targetFileName);
        }
        return result;
    }

    public static String asString(Object source) {
        String result = source == null ? null : source.toString();
        return result;
    }

    public static String buildReadablePercentage(int value, int count) {
        double percentage = count == 0 ? 100.0 : (double)value * 100.0 / (double)count;
        String result = percentage > 0.0 && percentage < 1.0 ? "<1%" : (percentage > 99.0 && percentage < 100.0 ? ">99%" : String.format("%d%%", Math.round(percentage)));
        return result;
    }

    public static String clean(String source) {
        String result = source.replaceAll("[^\\w ]", " ");
        return result;
    }

    public static String getExtension(File file) {
        int separatorIndex;
        String result = file == null ? null : ((separatorIndex = file.getName().lastIndexOf(46)) > 0 ? file.getName().substring(separatorIndex + 1).toLowerCase() : null);
        return result;
    }

    public static int indexOf(String pattern, List<String> source) {
        int result;
        if (source == null) {
            result = -1;
        } else {
            boolean ended = false;
            result = -1;
            int currentIndex = 0;
            while (!ended) {
                if (currentIndex < source.size()) {
                    String sourceString = source.get(currentIndex);
                    if (StringUtils.equals((CharSequence)sourceString, (CharSequence)pattern)) {
                        ended = true;
                        result = currentIndex;
                        continue;
                    }
                    ++currentIndex;
                    continue;
                }
                ended = true;
                currentIndex = -1;
            }
        }
        return result;
    }

    public static void save(File file, String string) throws PuckException {
        PrintWriter out = null;
        try {
            try {
                out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
                out.println(string);
            }
            catch (UnsupportedEncodingException exception) {
                throw PuckExceptions.UNSUPPORTED_ENCODING.create("Opening file [" + file + "]", new Object[0]);
            }
            catch (FileNotFoundException exception) {
                throw PuckExceptions.FILE_NOT_FOUND.create("Opening file [" + file + "]", new Object[0]);
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public static File setExtension(File source, String extension) {
        File result;
        if (source == null || extension == null) {
            result = source;
        } else {
            String sourceFileName = source.getAbsolutePath();
            int separatorIndex = sourceFileName.lastIndexOf(46);
            String targetFileName = separatorIndex > 0 ? String.valueOf(sourceFileName.substring(0, separatorIndex)) + extension : String.valueOf(sourceFileName) + extension;
            result = new File(targetFileName);
        }
        return result;
    }

    public static Double[] sort(Set<Double> source) {
        Object[] result;
        if (source == null) {
            result = null;
        } else {
            result = new Double[source.size()];
            source.toArray(result);
            Arrays.sort(result);
        }
        return result;
    }

    public static String[] splitLastPart(String label, String separator) {
        String[] result = new String[2];
        int idx = label.lastIndexOf(separator);
        if (idx > -1) {
            result[0] = label.substring(0, idx);
            result[1] = label.substring(idx + 1);
        } else {
            result[0] = label;
            result[1] = null;
        }
        return result;
    }

    public static double[] stringsToDoubles(String source) {
        double[] result;
        if (StringUtils.isBlank((CharSequence)source)) {
            result = new double[]{};
        } else {
            String[] degreesString = source.split("[ \\t,]");
            ArrayList<Double> doubles = new ArrayList<Double>(degreesString.length);
            String[] stringArray = degreesString;
            int n = degreesString.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                if (StringUtils.isNotBlank((CharSequence)string) && NumberUtils.isNumber((String)string)) {
                    doubles.add(Double.valueOf(string));
                }
                ++n2;
            }
            result = new double[doubles.size()];
            int index = 0;
            while (index < result.length) {
                result[index] = (Double)doubles.get(index);
                ++index;
            }
        }
        return result;
    }

    public static int[] stringsToInts(String source) {
        int[] result;
        if (StringUtils.isBlank((CharSequence)source)) {
            result = new int[]{};
        } else {
            String[] degreesString = source.split("[ \\t,]");
            ArrayList<Integer> integers = new ArrayList<Integer>(degreesString.length);
            String[] stringArray = degreesString;
            int n = degreesString.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                if (StringUtils.isNotBlank((CharSequence)string) && NumberUtils.isNumber((String)string)) {
                    integers.add(Integer.valueOf(string));
                }
                ++n2;
            }
            result = new int[integers.size()];
            int index = 0;
            while (index < result.length) {
                result[index] = (Integer)integers.get(index);
                ++index;
            }
        }
        return result;
    }

    public static double[][] toArray(List<double[]> source) {
        double[][] result;
        if (source == null) {
            result = null;
        } else if (source.size() == 0) {
            result = new double[0][0];
        } else {
            int rowCount = source.size();
            int columnCount = source.get(0).length;
            result = new double[rowCount][columnCount];
            int rowIndex = 0;
            while (rowIndex < rowCount) {
                int columnIndex = 0;
                while (columnIndex < columnCount) {
                    result[rowIndex][columnIndex] = source.get(rowIndex)[columnIndex];
                    ++columnIndex;
                }
                ++rowIndex;
            }
        }
        return result;
    }

    public static <K extends Comparable<K>, V> String toKeySetString(Map<K, V> map) {
        String result = "";
        ArrayList<K> keyList = new ArrayList<K>(map.keySet());
        Collections.sort(keyList);
        for (Comparable key : keyList) {
            result = String.valueOf(result) + key + " ";
        }
        return result;
    }

    public static <E> String toLine(ArrayList<E> list, String header, String starter, String separator) {
        String result = header;
        for (E item : list) {
            result = result.equals(header) ? String.valueOf(result) + starter + item : String.valueOf(result) + separator + item;
        }
        return result;
    }

    public static String toString(int[] values, String prefix, String separator, String postfix) {
        StringList buffer = new StringList();
        if (prefix != null) {
            buffer.append(prefix);
        }
        boolean firstPassed = false;
        int[] nArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            int value = nArray[n2];
            if (firstPassed) {
                buffer.append(separator);
            } else {
                firstPassed = true;
            }
            buffer.append(value);
            ++n2;
        }
        if (postfix != null) {
            buffer.append(postfix);
        }
        String result = buffer.toString();
        return result;
    }

    public static String toString(String source) {
        String result = source == null ? "" : source;
        return result;
    }
}

