/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net.workers;

import java.io.File;
import java.io.FileFilter;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckException;
import org.tip.puck.PuckManager;
import org.tip.puck.io.iur.IURTXTSplittedFile;
import org.tip.puck.net.Net;
import org.tip.puck.net.workers.FileBatchConverterCriteria;
import org.tip.puck.report.Report;
import org.tip.puck.util.Chronometer;

public class FileBatchConverter {
    private static final Logger logger = LoggerFactory.getLogger(FileBatchConverter.class);
    private static final int PADDING = 40;

    public static Report convert(FileBatchConverterCriteria criteria) {
        Chronometer chrono = new Chronometer();
        Report result = new Report();
        result.setTitle("File Batch Converter Report");
        result.setOrigin("File Batch Converter");
        result.inputs().add("Source Directory", criteria.getSourceDirectory().getAbsolutePath());
        result.inputs().add("Target Directory", criteria.getTargetDirectory().getAbsolutePath());
        result.inputs().add("TargetFormat", criteria.getTargetFormat().toString());
        result.inputs().add("Mode", criteria.getMode().toString());
        File[] files = criteria.getSourceDirectory().listFiles((FileFilter)FileFilterUtils.fileFileFilter());
        int count = 0;
        int convertCount = 0;
        int skipCount = 0;
        int overwriteCount = 0;
        int errorCount = 0;
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            Net net;
            File sourceFile = fileArray[n2];
            ++count;
            File targetFile = new File(criteria.getTargetDirectory(), String.valueOf(FilenameUtils.removeExtension((String)sourceFile.getName())) + criteria.getTargetFormat().getExtension());
            if (criteria.getMode() == FileBatchConverterCriteria.Mode.SKIP) {
                if (targetFile.exists()) {
                    result.outputs().appendln(String.valueOf(sourceFile.getName()) + " \u2192 " + targetFile.getName() + "\tSKIPPED");
                    ++skipCount;
                } else {
                    try {
                        net = PuckManager.loadNet(sourceFile);
                        if (criteria.getTargetFormat() == FileBatchConverterCriteria.TargetFormat.IURTXTS) {
                            IURTXTSplittedFile.export(targetFile, net);
                        } else {
                            PuckManager.saveNet(targetFile, net);
                        }
                        ++convertCount;
                        result.outputs().appendln(String.valueOf(sourceFile.getName()) + " \u2192 " + targetFile.getName() + "\tCONVERTED");
                    }
                    catch (PuckException exception) {
                        result.outputs().appendln(String.valueOf(sourceFile.getName()) + " \u2192 " + targetFile.getName() + "\tERROR");
                        logger.error("Error detected for file [" + sourceFile.getAbsolutePath() + "]", (Throwable)exception);
                        ++errorCount;
                    }
                }
            } else if (targetFile.isFile()) {
                try {
                    net = PuckManager.loadNet(sourceFile);
                    if (criteria.getTargetFormat() == FileBatchConverterCriteria.TargetFormat.IURTXTS) {
                        IURTXTSplittedFile.export(targetFile, net);
                    } else {
                        PuckManager.saveNet(targetFile, net);
                    }
                    result.outputs().appendln(String.valueOf(sourceFile.getName()) + " \u2192 " + targetFile.getName() + "\tOVERWRITED");
                    ++overwriteCount;
                    ++convertCount;
                }
                catch (PuckException exception) {
                    result.outputs().appendln(String.valueOf(sourceFile.getName()) + " \u2192 " + targetFile.getName() + "\tERROR");
                    logger.error("Error detected for file [" + sourceFile.getAbsolutePath() + "]", (Throwable)exception);
                    ++errorCount;
                }
            } else {
                try {
                    net = PuckManager.loadNet(sourceFile);
                    if (criteria.getTargetFormat() == FileBatchConverterCriteria.TargetFormat.IURTXTS) {
                        IURTXTSplittedFile.export(targetFile, net);
                    } else {
                        PuckManager.saveNet(targetFile, net);
                    }
                    result.outputs().appendln(String.valueOf(sourceFile.getName()) + " \u2192 " + targetFile.getName() + "\tCONVERTED");
                    ++convertCount;
                }
                catch (PuckException exception) {
                    result.outputs().appendln(String.valueOf(sourceFile.getName()) + " \u2192 " + targetFile.getName() + "\tERROR");
                    logger.error("Error detected for file [" + sourceFile.getAbsolutePath() + "]", (Throwable)exception);
                    ++errorCount;
                }
            }
            ++n2;
        }
        result.outputs().appendln();
        result.outputs().appendln();
        result.outputs().appendln("Source\t" + count);
        result.outputs().appendln("Converted\t" + convertCount);
        result.outputs().appendln("Skip\t" + skipCount);
        result.outputs().appendln("Overwrite\t" + overwriteCount);
        result.outputs().appendln("Error\t" + errorCount);
        result.setStatus(count);
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }
}

