/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net.relations.roles;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.net.AlterAge;
import org.tip.puck.net.Gender;
import org.tip.puck.net.KinType;
import org.tip.puck.net.relations.Role;
import org.tip.puck.net.relations.Roles;
import org.tip.puck.net.relations.roles.MetaRole;
import org.tip.puck.net.relations.roles.RoleActor;
import org.tip.puck.net.relations.roles.RoleActorComparator;
import org.tip.puck.net.relations.roles.RoleActorPair;
import org.tip.puck.net.relations.roles.RoleActors;
import org.tip.puck.net.relations.roles.RoleDefinition;
import org.tip.puck.net.relations.roles.RoleDefinitions;
import org.tip.puck.net.relations.roles.RoleRelation;
import org.tip.puck.net.relations.roles.RoleRelationMaker;
import org.tip.puck.util.NumberablesHashMap;

public class RoleRelations
extends NumberablesHashMap<RoleRelation> {
    boolean egoGenderDistinction;
    Boolean heteroMarriage;
    RoleDefinitions originalDefinitions;
    Map<Role, Roles> genderConfigs = new HashMap<Role, Roles>();
    Map<Role, Integer> selfDistances;
    RoleActors selfs = new RoleActors();
    RoleActors elementaryAlters;
    String selfName;
    private static final Logger logger = LoggerFactory.getLogger(RoleRelations.class);

    public RoleRelations clone() {
        RoleRelations result = new RoleRelations();
        result.originalDefinitions = this.originalDefinitions;
        result.heteroMarriage = this.heteroMarriage;
        result.selfs = this.selfs;
        result.selfName = this.selfName;
        for (RoleRelation relation : this) {
            result.put(relation.clone());
        }
        result.updateGenderConfigs();
        return result;
    }

    public RoleActors getAlters(RoleActor self, KinType kinType, Gender alterGender) {
        RoleActors result = new RoleActors();
        for (RoleActor alter : self.getActorsByRoleNameWithUnspecific(kinType.toString(), this)) {
            if (alterGender != null && !alterGender.matchs(alter.getAlterGender())) continue;
            result.add(alter);
        }
        return result;
    }

    RoleDefinitions getDefinitions() {
        RoleDefinitions result = new RoleDefinitions();
        for (RoleRelation relation : this) {
            for (RoleActor actor : relation.getActors()) {
                if (actor.isSelf()) continue;
                result.add(new RoleDefinition(relation.getSelfTerm(), actor));
            }
        }
        return result;
    }

    boolean hasElementaryName(RoleActor actor) {
        boolean result = false;
        for (RoleActor elementaryAlter : this.getElementaryAlters()) {
            if (!actor.hasName(elementaryAlter.getName())) continue;
            result = true;
            break;
        }
        return result;
    }

    public RoleActors getElementaryAlters() {
        if (this.elementaryAlters == null) {
            this.elementaryAlters = new RoleActors();
            Gender[] genderArray = Gender.values();
            int n = genderArray.length;
            int n2 = 0;
            while (n2 < n) {
                Gender egoGender = genderArray[n2];
                RoleActor self = this.getSelf(egoGender);
                RoleRelation relation = this.getSelfRelation(self);
                if (relation != null) {
                    for (RoleActor alter : relation.getActors()) {
                        if (alter.hasSelfName()) continue;
                        this.elementaryAlters.addNew(alter.egoGenderNeutral());
                    }
                }
                ++n2;
            }
        }
        return this.elementaryAlters;
    }

    public Roles getGeneratorTerms(RoleActor actor) {
        Roles result = new Roles();
        for (RoleActor elementaryAlter : this.getElementaryAlters()) {
            if (!actor.getRole().matches(elementaryAlter.getRole())) continue;
            result.add(elementaryAlter.getIndividual());
        }
        return result;
    }

    public KinType getElementaryKinType(RoleActor actor) {
        KinType result = null;
        for (RoleActor elementaryAlter : this.getElementaryAlters()) {
            if (!actor.hasName(elementaryAlter.getName())) continue;
            result = elementaryAlter.getRole().getKinType();
            break;
        }
        return result;
    }

    public Map<Role, Integer> getDistances() {
        if (this.selfDistances == null) {
            this.selfDistances = new HashMap<Role, Integer>();
            LinkedList<RoleActor> queue = new LinkedList<RoleActor>();
            RoleActors visited = new RoleActors();
            Gender[] genderArray = Gender.values();
            int n = genderArray.length;
            int n2 = 0;
            while (n2 < n) {
                Gender egoGender = genderArray[n2];
                RoleActor self = this.getSelf(egoGender);
                queue.add(self);
                this.selfDistances.put(self.getIndividual(), 0);
                ++n2;
            }
            while (!queue.isEmpty()) {
                RoleActor self = (RoleActor)queue.poll();
                visited.add(self);
                int selfDistance = this.selfDistances.get(self.getIndividual());
                for (KinType kinType : KinType.basicTypes()) {
                    for (RoleActor actor : self.getActorsByRoleNameWithUnspecific(kinType.toString(), this)) {
                        RoleActor alter;
                        if (actor.isSelf() || this.selfDistances.get((alter = actor.asSelf(this)).getIndividual()) != null || visited.contains(alter)) continue;
                        queue.add(alter);
                        this.selfDistances.put(alter.getIndividual(), selfDistance + 1);
                    }
                }
            }
        }
        return this.selfDistances;
    }

    public RoleDefinition getStandardRoleDefinition(RoleActor alpha, RoleActor beta) {
        return new RoleActorPair(this, alpha, beta, RoleActorPair.Adjustable.NONE).getStandardRoleDefinition(this);
    }

    public RoleDefinitions getBasicRoleDefinitions() {
        RoleDefinitions result = new RoleDefinitions();
        this.getDistances();
        Map<Role, MetaRole> uniqueGenderConfigs = RoleRelationMaker.getUniqueGenderConfigs(this);
        for (Role role : this.getRoles().toSortedList()) {
            if (role.hasName(this.selfName)) continue;
            MetaRole uniqueGenderConfig = uniqueGenderConfigs.get(role);
            RoleDefinition basicDefinition = null;
            for (Role metaRole : this.genderConfigs.get(role).toSortedList()) {
                RoleActor actor = new RoleActor(role, (MetaRole)metaRole, this.selfName);
                Role closestSelfTerm = this.getAlters(actor, ((MetaRole)metaRole).getKinType().inverse(), null).toListSortedByDistances(this).get(0).getIndividual();
                RoleDefinition definition = new RoleDefinition(closestSelfTerm, actor);
                if (uniqueGenderConfig == null) {
                    result.addNew(definition);
                    continue;
                }
                if (definition.compareTo(basicDefinition, this) >= 0) continue;
                basicDefinition = definition;
            }
            if (uniqueGenderConfig == null) continue;
            if (uniqueGenderConfig.isCross()) {
                for (RoleActor actor : basicDefinition.getAlter().crossExtension()) {
                    if (result.hasAlterWithGender(basicDefinition.getAlterTerm(), actor.getAlterGender())) continue;
                    result.addNew(new RoleDefinition(basicDefinition.getSelfTerm(), actor));
                }
                continue;
            }
            if (result.hasAlter(basicDefinition.getAlterTerm()) || !basicDefinition.getRole().equalsAbsolute(uniqueGenderConfig)) continue;
            result.addNew(basicDefinition);
        }
        return result;
    }

    public boolean heteroMarriage() {
        return this.heteroMarriage;
    }

    @Override
    public List<RoleRelation> toSortedList() {
        List<RoleRelation> result = this.toList();
        Collections.sort(result);
        return result;
    }

    public void updateGenderConfigs() {
        for (RoleActor actor : this.getActors()) {
            this.updateGenderConfigs(actor);
        }
    }

    public void updateGenderConfigs(RoleDefinitions definitions) {
        this.setHeteroMarriage(definitions);
        for (RoleDefinition definition : definitions.toSortedList()) {
            this.updateGenderConfigs(definition.getAlter());
            if (!definition.getSelfTerm().hasName(this.selfName)) continue;
            this.updateGenderConfigs(definition.getSelf());
        }
    }

    private void setHeteroMarriage(RoleDefinitions definitions) {
        this.heteroMarriage = true;
        for (RoleDefinition definition : definitions) {
            if (!definition.getSelfTerm().hasName(this.selfName) || !definition.getAlter().isSpouse() || definition.getAlter().getRole().isCross()) continue;
            this.heteroMarriage = false;
            break;
        }
    }

    public boolean updateGenderConfigs(RoleActor actor) {
        boolean result;
        if (actor.isSelf() || actor.hasName(this.selfName)) {
            result = false;
        } else {
            result = true;
            boolean addable = true;
            Roles alterGenderConfigs = this.genderConfigs.get(actor.getIndividual());
            if (alterGenderConfigs == null) {
                alterGenderConfigs = new Roles();
                this.genderConfigs.put(actor.getIndividual(), alterGenderConfigs);
            }
            MetaRole metaRole = actor.getRole().clone();
            for (Role otherRole : alterGenderConfigs.toSortedList()) {
                MetaRole otherMetaRole = (MetaRole)otherRole;
                if (metaRole.specifies(otherMetaRole)) {
                    result = false;
                    addable = false;
                    break;
                }
                if (otherMetaRole.specifies(metaRole)) {
                    alterGenderConfigs.remove(otherMetaRole);
                    continue;
                }
                if (!metaRole.getName().equals(otherMetaRole.getName())) continue;
                if (metaRole.equals(otherMetaRole.crossGenderComplement())) {
                    otherMetaRole.setEgoGender(Gender.UNKNOWN);
                    otherMetaRole.setAlterGender(Gender.UNKNOWN);
                    otherMetaRole.setCross(true);
                    addable = false;
                } else if (metaRole.equals(otherMetaRole.egoGenderComplement())) {
                    otherMetaRole.setEgoGender(Gender.UNKNOWN);
                    addable = false;
                } else if (metaRole.equals(otherMetaRole.alterGenderComplement())) {
                    otherMetaRole.setAlterGender(Gender.UNKNOWN);
                    addable = false;
                } else if (metaRole.equals(otherMetaRole.alterAgeComplement())) {
                    otherMetaRole.setAlterAge(AlterAge.UNKNOWN);
                    addable = false;
                } else if (metaRole.getEgoGender() == otherMetaRole.getEgoGender() && metaRole.getAlterGender() == otherMetaRole.getAlterGender() && !metaRole.isCross() && otherMetaRole.isCross()) {
                    otherMetaRole.setCross(false);
                    addable = false;
                } else if (metaRole.egoGenderComplement() != null && metaRole.egoGenderComplement().specifies(otherMetaRole)) {
                    metaRole.setEgoGender(Gender.UNKNOWN);
                } else if (metaRole.alterGenderComplement() != null && metaRole.alterGenderComplement().specifies(otherMetaRole)) {
                    metaRole.setAlterGender(Gender.UNKNOWN);
                } else if (metaRole.alterAgeComplement() != null && metaRole.alterAgeComplement().specifies(otherMetaRole)) {
                    metaRole.setAlterAge(AlterAge.UNKNOWN);
                }
                if (addable) continue;
                RoleRelations.cleanUpGenderConfigs(otherMetaRole, alterGenderConfigs);
            }
            if (addable) {
                alterGenderConfigs.add(metaRole);
                RoleRelations.cleanUpGenderConfigs(metaRole, alterGenderConfigs);
            }
            if (result) {
                logger.debug("Updated gender configuration:\t" + actor + ":\t" + alterGenderConfigs);
            }
        }
        return result;
    }

    private static boolean cleanUpGenderConfigs(MetaRole role, Roles roles) {
        boolean result = false;
        for (Role otherRole : roles.toSortedList()) {
            MetaRole otherMetaRole = (MetaRole)otherRole;
            if (otherMetaRole.equals(role) || !otherMetaRole.getName().equals(role.getName())) continue;
            if (otherMetaRole.specifies(role)) {
                roles.remove(otherMetaRole);
                result = true;
                continue;
            }
            if (otherMetaRole.equals(role.crossGenderComplement())) {
                roles.remove(otherMetaRole);
                role.setEgoGender(Gender.UNKNOWN);
                role.setAlterGender(Gender.UNKNOWN);
                role.setCross(true);
                result = true;
                continue;
            }
            if (otherMetaRole.equals(role.egoGenderComplement())) {
                roles.remove(otherMetaRole);
                role.setEgoGender(Gender.UNKNOWN);
                result = true;
                continue;
            }
            if (otherMetaRole.equals(role.alterGenderComplement())) {
                roles.remove(otherMetaRole);
                role.setAlterGender(Gender.UNKNOWN);
                result = true;
                continue;
            }
            if (otherMetaRole.equals(role.alterAgeComplement())) {
                roles.remove(otherMetaRole);
                role.setAlterAge(AlterAge.UNKNOWN);
                result = true;
                continue;
            }
            if (otherMetaRole.getEgoGender() != role.getEgoGender() || otherMetaRole.getAlterGender() != role.getAlterGender() || !otherMetaRole.isCross() || role.isCross()) continue;
            roles.remove(otherMetaRole);
            result = true;
        }
        return result;
    }

    public List<RoleRelation> toSortedListReverse() {
        List<RoleRelation> result = this.toList();
        Collections.sort(result, Collections.reverseOrder());
        return result;
    }

    public Roles getRoles() {
        Roles result = new Roles();
        for (RoleRelation relation : this) {
            Role role = relation.getSelfTerm();
            if (role.hasName(this.selfName) || result.contains(role)) continue;
            result.add(role);
        }
        return result;
    }

    public List<RoleActors> adjustChain(RoleActors chain, List<RoleActors> startChains) {
        List<RoleActors> result = startChains;
        for (RoleActor actor : chain) {
            ArrayList<RoleActors> endChains = new ArrayList<RoleActors>();
            for (RoleActors startChain : result) {
                RoleActor self = startChain.getLast();
                for (RoleActor alter : this.getAlters(self, actor.getRole().getKinType(), actor.getAlterGender())) {
                    if (!RoleRelationMaker.concatenable(self, alter)) continue;
                    RoleActors endChain = startChain.clone();
                    endChain.add(alter);
                    endChains.add(endChain);
                }
            }
            result = endChains;
        }
        return result;
    }

    public RoleRelations getBySelf(RoleActor self) {
        RoleRelations result = new RoleRelations();
        for (RoleRelation roleRelation : this) {
            if (!roleRelation.getSelf().matchesAbsolute(self)) continue;
            result.add(roleRelation);
        }
        return result;
    }

    public RoleActors getSortedActors() {
        RoleActors result = new RoleActors();
        for (RoleRelation relation : this) {
            for (RoleActor actor : relation.getActors()) {
                result.addNew(actor);
            }
        }
        Collections.sort(result, new RoleActorComparator(this));
        return result;
    }

    public RoleRelation getSelfRelation(RoleActor actor) {
        RoleRelation result = null;
        RoleActor self = actor.asSelf(this);
        for (RoleRelation roleRelation : this) {
            if (!roleRelation.hasActor(self)) continue;
            result = roleRelation;
            break;
        }
        return result;
    }

    public RoleActors getActors() {
        RoleActors result = new RoleActors();
        for (RoleRelation relation : this) {
            for (RoleActor actor : relation.getActors()) {
                result.addNew(actor);
            }
        }
        return result;
    }

    public void addAndUpdate(RoleRelation relation) {
        this.add(relation);
        this.selfs.addNew(relation.getSelf());
    }

    public List<RoleActor> getSortedSelfs() {
        return this.selfs.toListSortedByDistances(this);
    }

    public Roles roles() {
        Roles result = new Roles();
        for (RoleRelation relation : this) {
            for (Role role : relation.getRoles()) {
                result.addNew(role);
            }
        }
        return result;
    }

    public static boolean containsSpecific(Roles roles, MetaRole role) {
        boolean result = false;
        for (Role otherRole : roles) {
            if (role.equals(otherRole) || !((MetaRole)otherRole).specifies(role)) continue;
            result = true;
            break;
        }
        return result;
    }

    private static Roles getRoles(KinType kinType, Boolean[] config) {
        Gender egoGender;
        Roles egoComplements = new Roles();
        if (config[0].booleanValue()) {
            for (Gender egoGender2 : Gender.valuesNotUnknown()) {
                egoComplements.add(new MetaRole(kinType.toString(), egoGender2, null, null));
            }
        } else {
            egoComplements.add(new MetaRole(kinType.toString(), Gender.UNKNOWN, null, null));
        }
        Roles alterComplements = new Roles();
        for (Role role : egoComplements) {
            egoGender = ((MetaRole)role).egoGender;
            if (config[1].booleanValue()) {
                for (Gender alterGender : Gender.valuesNotUnknown()) {
                    alterComplements.add(new MetaRole(kinType.toString(), egoGender, alterGender, null));
                }
                continue;
            }
            alterComplements.add(new MetaRole(kinType.toString(), egoGender, Gender.UNKNOWN, null));
        }
        Roles result = new Roles();
        for (Role role : alterComplements) {
            Gender alterGender;
            egoGender = ((MetaRole)role).egoGender;
            alterGender = ((MetaRole)role).alterGender;
            if (config[2].booleanValue()) {
                for (AlterAge alterAge : AlterAge.valuesNotUnknown()) {
                    result.add(new MetaRole(kinType.toString(), egoGender, alterGender, alterAge));
                }
                continue;
            }
            result.add(new MetaRole(kinType.toString(), egoGender, alterGender, AlterAge.UNKNOWN));
        }
        return result;
    }

    public Roles getGenerators() {
        TreeMap<KinType, Boolean[]> configs = new TreeMap<KinType, Boolean[]>();
        for (KinType kinType : KinType.basicTypesWithSiblings()) {
            configs.put(kinType, new Boolean[]{false, false, false});
        }
        for (Role role : this.roles()) {
            MetaRole metaRole = (MetaRole)role;
            Boolean[] config = (Boolean[])configs.get((Object)metaRole.getKinType());
            if (config == null) continue;
            if (!metaRole.getEgoGender().isUnknown()) {
                config[0] = true;
            }
            if (!metaRole.getAlterGender().isUnknown()) {
                config[1] = true;
            }
            if (metaRole.getAlterAge().isUnknown()) continue;
            config[2] = true;
        }
        Roles result = new Roles();
        for (KinType kinType : configs.keySet()) {
            result.addAll(RoleRelations.getRoles(kinType, (Boolean[])configs.get((Object)kinType)));
        }
        return result;
    }

    public RoleRelations getByRole(Role role) {
        RoleRelations result = new RoleRelations();
        block0: for (RoleRelation relation : this) {
            for (RoleActor actor : relation.getActors()) {
                if (!actor.getIndividual().equals(role)) continue;
                result.add(relation);
                continue block0;
            }
        }
        return result;
    }

    public RoleRelations getBySelfRole(Role role, Gender egoGender) {
        RoleRelations result = new RoleRelations();
        for (RoleRelation relation : this) {
            RoleActor actor = relation.getSelf();
            if (!actor.getIndividual().equals(role) || egoGender != null && egoGender != actor.getRole().getEgoGender()) continue;
            result.add(relation);
        }
        return result;
    }

    public boolean isEgoGenderDistinction() {
        return this.egoGenderDistinction;
    }

    public void setEgoGenderDistinction(boolean egoGenderDistinction) {
        this.egoGenderDistinction = egoGenderDistinction;
    }

    public static boolean isNullOrHasNullFactor(Roles composition) {
        boolean result = false;
        if (composition == null) {
            result = true;
        } else if (composition.size() < 2 || composition.get(0) == null || composition.get(1) == null) {
            result = true;
        }
        return result;
    }

    public String toString() {
        String result = this.toList().toString();
        return result;
    }

    public Map<Role, Roles> getGenderConfigs() {
        return this.genderConfigs;
    }

    public void setGenderConfigs(Map<Role, Roles> genderConfigs) {
        this.genderConfigs = genderConfigs;
    }

    public boolean hasEgoGenderDistinction() {
        boolean result = false;
        for (RoleRelation relation : this) {
            if (relation.getSelf().getEgoGender().isUnknown()) continue;
            result = true;
            break;
        }
        return result;
    }

    public boolean hasAlterGenderDistinction() {
        boolean result = false;
        for (RoleRelation relation : this) {
            if (relation.getSelf().getAlterGender().isUnknown()) continue;
            result = true;
            break;
        }
        return result;
    }

    public boolean hasAlterAgeDistinction() {
        boolean result = false;
        for (RoleRelation relation : this) {
            if (relation.getSelf().getAlterAge().isUnknown()) continue;
            result = true;
            break;
        }
        return result;
    }

    public RoleDefinitions getOriginalDefinitions() {
        return this.originalDefinitions;
    }

    public void setOriginalDefinitions(RoleDefinitions originalDefinitions) {
        this.originalDefinitions = originalDefinitions;
    }

    public Gender getEgoGenderScope(RoleActor actor) {
        Gender result = null;
        if (actor.hasSelfName()) {
            result = Gender.UNKNOWN;
        } else {
            for (Role metaRole : this.genderConfigs.get(actor.getIndividual())) {
                if (!metaRole.getName().equals(actor.getRole().getName())) continue;
                Gender egoGender = ((MetaRole)metaRole).getEgoGender();
                if (result == null) {
                    result = egoGender;
                } else if (result != egoGender) {
                    result = Gender.UNKNOWN;
                }
                if (result.isUnknown()) break;
            }
        }
        return result;
    }

    public String getSelfName() {
        return this.selfName;
    }

    public void setSelfName(String selfName) {
        this.selfName = selfName;
    }

    RoleActor getSelf(Gender gender) {
        RoleActor result = new RoleActor(new Role(this.selfName), new MetaRole("SELF", gender, gender, AlterAge.UNKNOWN), this.selfName);
        return result;
    }
}

