/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net.relations.roles;

import org.tip.puck.graphs.Link;
import org.tip.puck.net.AlterAge;
import org.tip.puck.net.Gender;
import org.tip.puck.net.KinType;
import org.tip.puck.net.relations.Role;
import org.tip.puck.net.relations.Roles;

public class MetaRole
extends Role {
    Gender egoGender;
    Gender alterGender;
    AlterAge alterAge;
    boolean cross;

    public MetaRole(String name) {
        super(name);
        this.egoGender = Gender.UNKNOWN;
        this.alterGender = Gender.UNKNOWN;
        this.alterAge = AlterAge.UNKNOWN;
    }

    public MetaRole(String name, Gender egoGender, Gender alterGender, AlterAge alterAge) {
        super(name);
        this.egoGender = egoGender;
        this.alterGender = alterGender;
        this.alterAge = alterAge;
    }

    public MetaRole(String ageLetter, String kinLetter, String egoGenderLetter) {
        this.egoGender = Gender.valueOf(egoGenderLetter);
    }

    @Override
    public MetaRole clone() {
        MetaRole result = new MetaRole(this.name, this.egoGender, this.alterGender, this.alterAge);
        result.setCross(this.cross);
        return result;
    }

    AlterAge invertAge() {
        AlterAge result = this.alterAge == null ? null : this.alterAge.invert();
        return result;
    }

    boolean isCross() {
        boolean result = this.cross || !this.egoGender.isUnknown() && this.egoGender.invert() == this.alterGender;
        return result;
    }

    boolean isParallel() {
        boolean result = !this.egoGender.isUnknown() && this.egoGender == this.alterGender;
        return result;
    }

    String invertName() {
        String result = this.getKinType().inverse().toString();
        return result;
    }

    static String invertName(String name) {
        return new MetaRole(name).invertName();
    }

    @Override
    public boolean equals(Object role) {
        boolean result = role != null && (this.name == null ? ((MetaRole)role).name == null : this.name.equals(((MetaRole)role).name)) && this.egoGender == ((MetaRole)role).egoGender && this.alterGender == ((MetaRole)role).alterGender && this.alterAge == ((MetaRole)role).alterAge && this.isCross() == ((MetaRole)role).isCross();
        return result;
    }

    @Override
    public int compareTo(Role other) {
        int result = 0;
        if (other != null) {
            if (this.name != null && ((MetaRole)other).name == null) {
                result = -1;
            } else if (this.name == null && ((MetaRole)other).name != null) {
                result = 1;
            } else {
                if (this.name != null && ((MetaRole)other).name != null) {
                    result = this.getKinType().compareTo(((MetaRole)other).getKinType());
                }
                if (result == 0 && (result = this.alterGender.compareToUnknownFirst(((MetaRole)other).alterGender)) == 0 && (result = this.egoGender.compareToUnknownFirst(((MetaRole)other).egoGender)) == 0 && (result = this.alterAge.compareTo(((MetaRole)other).alterAge)) == 0) {
                    if (this.isCross() && !((MetaRole)other).isCross()) {
                        result = -1;
                    } else if (!this.isCross() && ((MetaRole)other).isCross()) {
                        result = 1;
                    }
                }
            }
        }
        return result;
    }

    @Override
    public String toString() {
        String result = this.name;
        if (result == null) {
            result = "-";
        }
        String suffix = "";
        String prefix = "";
        if (this.egoGender != null && !this.egoGender.isUnknown()) {
            suffix = String.valueOf(suffix) + " " + this.egoGender.toGedChar() + ".S.";
        } else if (this.cross) {
            suffix = String.valueOf(suffix) + " #S.";
        }
        if (this.alterAge != null && !this.alterAge.isUnknown()) {
            prefix = String.valueOf(prefix) + (Object)((Object)this.alterAge) + " ";
        }
        if (this.alterGender != null && !this.alterGender.isUnknown()) {
            prefix = String.valueOf(prefix) + (Object)((Object)this.alterGender) + " ";
        }
        result = String.valueOf(prefix) + result + suffix;
        return result;
    }

    public String toStandardString() {
        String result = "";
        switch (this.getKinType()) {
            case PARENT: {
                switch (this.alterGender) {
                    case MALE: {
                        result = "Father";
                        break;
                    }
                    case FEMALE: {
                        result = "Mother";
                        break;
                    }
                    case UNKNOWN: {
                        result = "Parent";
                    }
                }
                break;
            }
            case CHILD: {
                switch (this.alterGender) {
                    case MALE: {
                        result = "Son";
                        break;
                    }
                    case FEMALE: {
                        result = "Daughter";
                        break;
                    }
                    case UNKNOWN: {
                        result = "Child";
                    }
                }
                break;
            }
            case SIBLING: {
                switch (this.alterGender) {
                    case MALE: {
                        result = "Brother";
                        break;
                    }
                    case FEMALE: {
                        result = "Sister";
                        break;
                    }
                    case UNKNOWN: {
                        result = "Sibling";
                    }
                }
                break;
            }
            case SPOUSE: {
                switch (this.alterGender) {
                    case MALE: {
                        result = "Husband";
                        break;
                    }
                    case FEMALE: {
                        result = "Wife";
                        break;
                    }
                    case UNKNOWN: {
                        result = "Spouse";
                    }
                }
                break;
            }
        }
        if (!this.alterAge.isUnknown()) {
            result = String.valueOf(this.alterAge.toLetter()) + result;
        }
        return result;
    }

    public String toLetter() {
        String result = "";
        switch (this.getKinType()) {
            case PARENT: {
                switch (this.alterGender) {
                    case MALE: {
                        result = "F";
                        break;
                    }
                    case FEMALE: {
                        result = "M";
                        break;
                    }
                    case UNKNOWN: {
                        result = "Pa";
                    }
                }
                break;
            }
            case CHILD: {
                switch (this.alterGender) {
                    case MALE: {
                        result = "S";
                        break;
                    }
                    case FEMALE: {
                        result = "D";
                        break;
                    }
                    case UNKNOWN: {
                        result = "Ch";
                    }
                }
                break;
            }
            case SIBLING: {
                switch (this.alterGender) {
                    case MALE: {
                        result = "B";
                        break;
                    }
                    case FEMALE: {
                        result = "Z";
                        break;
                    }
                    case UNKNOWN: {
                        result = "Sb";
                    }
                }
                break;
            }
            case SPOUSE: {
                switch (this.alterGender) {
                    case MALE: {
                        result = "H";
                        break;
                    }
                    case FEMALE: {
                        result = "W";
                        break;
                    }
                    case UNKNOWN: {
                        result = "Sp";
                    }
                }
                break;
            }
        }
        if (!this.alterAge.isUnknown()) {
            result = String.valueOf(this.alterAge.toLetter()) + result;
        }
        return result;
    }

    boolean specifies(MetaRole role) {
        boolean result = this.name.equals(role.name) && this.alterGender.specifies(role.alterGender) && this.egoGender.specifies(role.egoGender) && this.alterAge.matches(role.alterAge) && (this.isCross() || !role.isCross());
        return result;
    }

    boolean matches(MetaRole role) {
        boolean result = this.name.equals(role.name) && this.alterGender.matchs(role.alterGender) && this.egoGender.matchs(role.egoGender) && this.alterAge.matches(role.alterAge);
        return result;
    }

    boolean specifiesAbsolute(MetaRole role) {
        boolean result = this.alterGender.specifies(role.alterGender) && this.egoGender.specifies(role.egoGender) && this.alterAge.matches(role.alterAge) && (this.isCross() || !role.isCross());
        return result;
    }

    boolean matchesAbsolute(MetaRole role) {
        boolean result = this.alterGender.matchs(role.alterGender) && this.egoGender.matchs(role.egoGender) && this.alterAge.matches(role.alterAge);
        return result;
    }

    Gender getEgoGender() {
        return this.egoGender;
    }

    Gender getAlterGender() {
        return this.alterGender;
    }

    AlterAge getAlterAge() {
        return this.alterAge;
    }

    void setAlterAge(AlterAge alterAge) {
        this.alterAge = alterAge;
    }

    void setEgoGender(Gender egoGender) {
        this.egoGender = egoGender;
    }

    void setAlterGender(Gender alterGender) {
        this.alterGender = alterGender;
    }

    Link.LinkType getLinkType() {
        Link.LinkType result = this.getKinType() == this.getKinType().inverse() ? Link.LinkType.EDGE : Link.LinkType.ARC;
        return result;
    }

    KinType getKinType() {
        KinType result = this.name == null ? null : KinType.valueOf(this.name);
        return result;
    }

    MetaRole absolute() {
        MetaRole result = this.clone();
        result.setName(null);
        return result;
    }

    boolean equalsAbsolute(MetaRole other) {
        boolean result = this.absolute().equals(other.absolute());
        return result;
    }

    boolean containsAbsolute(Roles roles, MetaRole role) {
        boolean result = false;
        for (Role otherRole : roles) {
            if (!((MetaRole)otherRole).equalsAbsolute(role)) continue;
            result = true;
            break;
        }
        return result;
    }

    boolean isParent() {
        return this.getKinType() == KinType.PARENT;
    }

    boolean isChild() {
        return this.getKinType() == KinType.CHILD;
    }

    boolean isSpouse() {
        return this.getKinType() == KinType.SPOUSE;
    }

    boolean isSibling() {
        return this.getKinType() == KinType.SIBLING;
    }

    boolean isSelf() {
        return this.getKinType() == KinType.SELF;
    }

    void setCross(boolean cross) {
        this.cross = cross;
    }

    MetaRole egoGenderNeutral() {
        MetaRole result = this.clone();
        result.setEgoGender(Gender.UNKNOWN);
        return result;
    }

    MetaRole alterGenderNeutral() {
        MetaRole result = this.clone();
        result.setAlterGender(Gender.UNKNOWN);
        return result;
    }

    MetaRole alterAgeNeutral() {
        MetaRole result = this.clone();
        result.setAlterAge(AlterAge.UNKNOWN);
        return result;
    }

    MetaRole crossGenderComplement() {
        MetaRole result;
        if (this.egoGender.isUnknown() || this.alterGender.isUnknown() || !this.isCross()) {
            result = null;
        } else {
            result = this.clone();
            result.setEgoGender(this.alterGender);
            result.setEgoGender(this.egoGender);
        }
        return result;
    }

    MetaRole egoGenderComplement() {
        MetaRole result;
        if (this.egoGender.isUnknown()) {
            result = null;
        } else {
            result = this.clone();
            result.setEgoGender(this.egoGender.invert());
        }
        return result;
    }

    MetaRole alterGenderComplement() {
        MetaRole result;
        if (this.alterGender.isUnknown()) {
            result = null;
        } else {
            result = this.clone();
            result.setAlterGender(this.alterGender.invert());
        }
        return result;
    }

    MetaRole alterAgeComplement() {
        MetaRole result;
        if (this.alterAge.isUnknown()) {
            result = null;
        } else {
            result = this.clone();
            result.setAlterAge(this.alterAge.invert());
        }
        return result;
    }
}

