/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.views;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.tip.puck.PuckException;
import org.tip.puck.PuckExceptions;
import org.tip.puck.report.ReportRawData;
import org.tip.puck.util.ToolBox;
import org.tip.puckgui.util.GenericFileFilter;

public class SaveReportRawDataButton
extends JButton {
    private static final long serialVersionUID = -944539061378508158L;

    public SaveReportRawDataButton(final JFrame window, final ReportRawData rawData) {
        this.setText(String.format("%s (%d bytes)", rawData.getTitle(), rawData.getLength()));
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    File targetFile = rawData.getDefaultFile();
                    boolean ended = false;
                    while (!ended) {
                        JFileChooser chooser = new JFileChooser();
                        chooser.setSelectedFile(targetFile);
                        chooser.setDialogTitle(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.saveAsFileChooser.text"));
                        chooser.setFileSelectionMode(0);
                        chooser.setAcceptAllFileFilterUsed(false);
                        GenericFileFilter defaultFileFilter = new GenericFileFilter(String.format("%s (*.%s)", rawData.getFormat(), rawData.getExtension()), rawData.getExtension());
                        chooser.addChoosableFileFilter(defaultFileFilter);
                        chooser.setFileFilter(defaultFileFilter);
                        if (chooser.showSaveDialog(window) == 0) {
                            boolean doSave;
                            System.out.println("getCurrentDirectory(): " + chooser.getCurrentDirectory());
                            System.out.println("getSelectedFile() : " + chooser.getSelectedFile());
                            targetFile = chooser.getSelectedFile();
                            if (targetFile.exists()) {
                                String title = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileConfirm.existingFile.title");
                                String message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileConfirm.existingFile.text");
                                int response = JOptionPane.showConfirmDialog(window, message, title, 1);
                                if (response == 0) {
                                    doSave = true;
                                    ended = true;
                                } else if (response == 1) {
                                    doSave = false;
                                    ended = false;
                                } else {
                                    doSave = false;
                                    ended = true;
                                }
                            } else {
                                doSave = true;
                                ended = true;
                            }
                            if (!doSave) continue;
                            ToolBox.save(targetFile, rawData.getData());
                            continue;
                        }
                        System.out.println("No Selection ");
                        ended = true;
                    }
                }
                catch (PuckException exception) {
                    String message;
                    String title = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.title");
                    switch (PuckExceptions.valueOf(exception.getCode())) {
                        case UNSUPPORTED_FILE_FORMAT: {
                            message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.unsupportedFileFormat");
                            break;
                        }
                        case NOT_A_FILE: {
                            message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.notAFile");
                            break;
                        }
                        case UNSUPPORTED_ENCODING: {
                            message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.unsupportedEncoding");
                            break;
                        }
                        default: {
                            message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.default");
                        }
                    }
                    JOptionPane.showMessageDialog(window, message, title, 0);
                }
            }
        });
    }
}

