/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.views;

import java.awt.Component;
import java.io.File;
import javax.swing.JFileChooser;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puckgui.PuckGUI;
import org.tip.puckgui.util.GenericFileFilter;

public class ImportRelationModelFileSelector
extends JFileChooser {
    private static final long serialVersionUID = -930947953866008909L;
    private static final Logger logger = LoggerFactory.getLogger(ImportRelationModelFileSelector.class);

    public ImportRelationModelFileSelector(File sourceDirectory) {
        String preferenceDirectory;
        Object targetDirectory = sourceDirectory == null ? (StringUtils.isBlank((CharSequence)(preferenceDirectory = PuckGUI.instance().getPreferences().getTerminologyLastDirectory())) ? null : new File(preferenceDirectory)) : sourceDirectory;
        this.setSelectedFile((File)targetDirectory);
        this.setDialogTitle("Import Relation Model");
        this.setFileSelectionMode(0);
        this.setAcceptAllFileFilterUsed(false);
        this.setApproveButtonText("Import");
        this.setDialogType(2);
        GenericFileFilter defaultFileFilter = new GenericFileFilter("All Terms format files (Standard, Genealogy, ETIC, EMIC)", "term.ods", "term.txt", "term.xls", "term.puc", "term.iur.ods", "term.iur.txt", "term.iur.xls", "etic.ods", "etic.txt", "etic.xls", "emic.ods", "emic.txt", "emic.xls");
        this.addChoosableFileFilter(defaultFileFilter);
        this.addChoosableFileFilter(new GenericFileFilter("Standard Terms format files (*.term.ods, *.term.txt, *.term.xls, *.term.puc)", "term.puc", "term.ods", "term.txt", "term.xls"));
        this.addChoosableFileFilter(new GenericFileFilter("Genalogy Terms files (*.term.iur.ods,*.term.iur.txt,*.term.iur.xls)", "term.iur.ods", "term.iur.txt", "term.iur.xls"));
        this.addChoosableFileFilter(new GenericFileFilter("ETIC Terms files (*.etic.ods, *.etic.txt, *.etic.xls)", "etic.ods", "etic.txt", "etic.xls"));
        this.addChoosableFileFilter(new GenericFileFilter("EMIC Terms files (*.emic.ods, *.emic.txt, *.emic.xls)", "emic.ods", "emic.txt", "emic.xls"));
        this.setFileFilter(defaultFileFilter);
    }

    @Override
    public void cancelSelection() {
        logger.debug("Cancel selection.");
        super.cancelSelection();
    }

    @Override
    public void setSelectedFile(File file) {
        super.setSelectedFile(file);
        System.out.println("==== SET SELECTED FILE=================");
        System.out.println("SELECED FILE " + file);
    }

    public static File showSelectorDialog(Component parent, File targetFile) {
        File result;
        ImportRelationModelFileSelector selector = new ImportRelationModelFileSelector(targetFile);
        if (selector.showDialog(parent, null) == 0) {
            logger.debug("getCurrentDirectory(): {}", (Object)selector.getCurrentDirectory());
            logger.debug("getSelectedFile() : {}", (Object)selector.getSelectedFile());
            result = selector.getSelectedFile();
            PuckGUI.instance().getPreferences().setTerminologyLastDirectory(result);
        } else {
            result = null;
        }
        return result;
    }
}

