/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.util;

import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.tip.puckgui.util.AutoComboBox;

public class AutoTextField
extends JTextField {
    private static final long serialVersionUID = -8060098505837569333L;
    private List dataList;
    private boolean isCaseSensitive;
    private boolean isStrict;
    private AutoComboBox autoComboBox;

    public AutoTextField(List list) {
        this.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.isCaseSensitive = false;
        this.isStrict = true;
        this.autoComboBox = null;
        this.dataList = list == null ? new ArrayList() : list;
        this.init();
    }

    AutoTextField(List list, AutoComboBox b) {
        this.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.isCaseSensitive = false;
        this.isStrict = true;
        this.autoComboBox = null;
        this.dataList = list == null ? new ArrayList() : list;
        this.autoComboBox = b;
        this.init();
    }

    public List getDataList() {
        return this.dataList;
    }

    private String getMatch(String s) {
        if (s.equals("")) {
            return s;
        }
        int i = 0;
        while (i < this.dataList.size()) {
            String s1 = this.dataList.get(i).toString();
            if (s1 != null) {
                if (!this.isCaseSensitive && s1.toLowerCase().startsWith(s.toLowerCase())) {
                    return s1;
                }
                if (this.isCaseSensitive && s1.startsWith(s)) {
                    return s1;
                }
            }
            ++i;
        }
        return null;
    }

    private void init() {
        this.setDocument(new AutoDocument());
        if (this.isStrict && this.dataList.size() > 0) {
            this.setText(this.dataList.get(0).toString());
        }
    }

    public boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    public boolean isStrict() {
        return this.isStrict;
    }

    @Override
    public void replaceSelection(String s) {
        AutoDocument _lb = (AutoDocument)this.getDocument();
        if (_lb != null) {
            try {
                int i = Math.min(this.getCaret().getDot(), this.getCaret().getMark());
                int j = Math.max(this.getCaret().getDot(), this.getCaret().getMark());
                _lb.replace(i, j - i, s, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setCaseSensitive(boolean flag) {
        this.isCaseSensitive = flag;
    }

    public void setDataList(List list) {
        if (list == null) {
            throw new IllegalArgumentException("values can not be null");
        }
        this.dataList = list;
    }

    public void setStrict(boolean flag) {
        this.isStrict = flag;
    }

    class AutoDocument
    extends PlainDocument {
        AutoDocument() {
        }

        @Override
        public void insertString(int i, String s, AttributeSet attributeset) throws BadLocationException {
            if (s == null || "".equals(s)) {
                return;
            }
            String s1 = this.getText(0, i);
            String s2 = AutoTextField.this.getMatch(String.valueOf(s1) + s);
            int j = i + s.length() - 1;
            if (AutoTextField.this.isStrict && s2 == null) {
                s2 = AutoTextField.this.getMatch(s1);
                --j;
            } else if (!AutoTextField.this.isStrict && s2 == null) {
                super.insertString(i, s, attributeset);
                return;
            }
            if (AutoTextField.this.autoComboBox != null && s2 != null) {
                AutoTextField.this.autoComboBox.setSelectedValue(s2);
            }
            super.remove(0, this.getLength());
            super.insertString(0, s2, attributeset);
            AutoTextField.this.setSelectionStart(j + 1);
            AutoTextField.this.setSelectionEnd(this.getLength());
        }

        @Override
        public void remove(int i, int j) throws BadLocationException {
            int k = AutoTextField.this.getSelectionStart();
            if (k > 0) {
                --k;
            }
            String s = AutoTextField.this.getMatch(this.getText(0, k));
            if (!AutoTextField.this.isStrict && s == null) {
                super.remove(i, j);
            } else {
                super.remove(0, this.getLength());
                super.insertString(0, s, null);
            }
            if (AutoTextField.this.autoComboBox != null && s != null) {
                AutoTextField.this.autoComboBox.setSelectedValue(s);
            }
            try {
                AutoTextField.this.setSelectionStart(k);
                AutoTextField.this.setSelectionEnd(this.getLength());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void replace(int i, int j, String s, AttributeSet attributeset) throws BadLocationException {
            super.remove(i, j);
            this.insertString(i, s, attributeset);
        }
    }
}

