/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.geo2;

import fr.devinsy.util.StringList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.tip.puck.geo2.Place2;
import org.tip.puck.geo2.Places2;

public class IndexOfToponyms {
    private Map<String, Place2> index = new HashMap<String, Place2>();

    public IndexOfToponyms clear() {
        this.index.clear();
        return this;
    }

    public boolean contains(String toponym) {
        boolean result = this.get(toponym) != null;
        return result;
    }

    public Place2 get(String toponym) {
        Place2 result = toponym == null ? null : this.index.get(StringUtils.lowerCase((String)toponym));
        return result;
    }

    public StringList getToponyms() {
        StringList result = new StringList();
        for (String name : this.index.keySet()) {
            result.add((Object)name);
        }
        return result;
    }

    public IndexOfToponyms index(Place2 place) {
        if (place != null) {
            this.index.put(StringUtils.lowerCase((String)place.getToponym()), place);
            Iterator iterator = place.getHomonyms().iterator();
            while (iterator.hasNext()) {
                String homonym = (String)iterator.next();
                this.index.put(StringUtils.lowerCase((String)homonym), place);
            }
        }
        return this;
    }

    public IndexOfToponyms index(Places2 places) {
        if (places != null) {
            for (Place2 place : places) {
                this.index(place);
            }
        }
        return this;
    }

    public int size() {
        int result = this.index.size();
        return result;
    }
}

