/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.sequences;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.tip.puck.PuckException;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.net.relations.workers.RelationValuator;
import org.tip.puck.sequences.EgoSequence;
import org.tip.puck.sequences.Ordinal;
import org.tip.puck.sequences.Sequence;
import org.tip.puck.util.Value;

public class ValueSequence
extends Sequence<Value> {
    int nrLoops;
    int nrDirectReturns;
    int nrCycles;
    Set<Value> support;
    Set<Value> centers;

    public ValueSequence(String idLabel, int id) {
        super(idLabel, id);
    }

    public ValueSequence(EgoSequence source, String idLabel, Object parameter) throws PuckException {
        super(idLabel, source.getId());
        for (Ordinal time : source.getTimes()) {
            this.put(time, RelationValuator.get((Relation)source.getStation(time), source.getEgo(), idLabel, parameter, null));
        }
        this.setProfile();
    }

    public void setProfile() {
        this.centers = new HashSet<Value>();
        this.support = new HashSet<Value>();
        int i = 0;
        for (Value value : this.stations.values()) {
            if (value != null) {
                this.support.add(value);
            }
            Value previousValue = null;
            boolean closed = false;
            int j = i - 1;
            while (j > -1) {
                previousValue = (Value)this.stations.get(this.getTimes().get(j));
                boolean bl = closed = previousValue != null && previousValue.equals(value);
                if (closed) {
                    this.centers.add(value);
                    if (j == i - 1) {
                        ++this.nrLoops;
                        break;
                    }
                    if (j == i - 2) {
                        ++this.nrDirectReturns;
                        break;
                    }
                    ++this.nrCycles;
                    break;
                }
                --j;
            }
            ++i;
        }
    }

    public List<Value> getCentersAsList() {
        ArrayList<Value> result = new ArrayList<Value>(this.centers);
        Collections.sort(result);
        return result;
    }

    public Value start() {
        Value result = this.stations.isEmpty() ? null : (Value)this.stations.get(this.getFirstTime());
        return result;
    }

    public List<Value> getCentersWithoutStartAsList() {
        ArrayList<Value> result = new ArrayList<Value>(this.centers);
        result.remove(this.start());
        Collections.sort(result);
        return result;
    }

    public Set<Value> getSupport() {
        return this.support;
    }

    public List<Value> getSupportAsList() {
        ArrayList<Value> result = new ArrayList<Value>(this.support);
        Collections.sort(result);
        return result;
    }

    public int getNrDirectReturns() {
        return this.nrDirectReturns;
    }

    public int getNrCycles() {
        return this.nrCycles;
    }

    public int getNrLoops() {
        return this.nrLoops;
    }

    public int getNrCenters() {
        return this.centers.size();
    }

    @Override
    public int getNrStations() {
        return this.getSupport().size();
    }

    public int getNrCentersWithoutStart() {
        int result = this.getNrCenters();
        if (this.centers.contains(this.start())) {
            --result;
        }
        return result;
    }

    public String getMovement(int i) {
        String result = null;
        if (i == 0) {
            result = "ORIGIN";
        } else {
            Value here = (Value)this.stations.get(this.getTimes().get(i));
            if (here.toString().equals("UNKNOWN")) {
                result = "UNKNOWN";
            } else {
                int j = i - 1;
                while (j > -1) {
                    Value there = (Value)this.stations.get(this.getTimes().get(j));
                    if (there != null && there.equals(here) && j != i - 1) {
                        result = j == i - 2 ? "BACK" : "RETURN";
                        if (!here.equals(this.start())) break;
                        result = String.valueOf(result) + "ORIGIN";
                        break;
                    }
                    --j;
                }
            }
        }
        if (result == null) {
            result = "NEW";
        }
        return result;
    }

    public ValueSequence getMovements() {
        ValueSequence result = new ValueSequence(String.valueOf(this.idLabel) + "_MOVEMENT", this.id);
        int i = 0;
        for (Ordinal time : this.getTimes()) {
            result.put(time, new Value(this.getMovement(i)));
            ++i;
        }
        return result;
    }
}

