/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net.relations.roles;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.tip.puck.net.Individual;
import org.tip.puck.net.relations.Roles;
import org.tip.puck.net.relations.roles.MetaRole;
import org.tip.puck.net.relations.roles.RoleActor;
import org.tip.puck.net.relations.roles.RoleActorComparator;
import org.tip.puck.net.relations.roles.RoleRelations;

public class RoleActors
extends ArrayList<RoleActor>
implements Comparable<RoleActors> {
    private static final long serialVersionUID = -1258074052306152168L;

    public RoleActors() {
    }

    public RoleActors(RoleActors source) {
        super(source);
    }

    @Override
    public RoleActors clone() {
        RoleActors result = new RoleActors();
        for (RoleActor actor : this) {
            result.add(actor.clone());
        }
        return result;
    }

    public boolean addNew(RoleActor actor) {
        boolean result = this.contains(actor) ? false : this.add(actor);
        return result;
    }

    public boolean addNonRedundant(RoleActor actor) {
        boolean result = this.containsOrImplies(actor) ? false : this.add(actor);
        return result;
    }

    public boolean containsOrImplies(RoleActor actor) {
        boolean result = false;
        for (RoleActor otherActor : this) {
            if (!actor.specifies(otherActor)) continue;
            result = true;
            break;
        }
        return result;
    }

    public RoleActor get(int individualId, MetaRole role) {
        boolean ended = false;
        RoleActor result = null;
        Iterator iterator = this.iterator();
        while (!ended) {
            if (iterator.hasNext()) {
                RoleActor actor = (RoleActor)iterator.next();
                if (actor.getId() != individualId || actor.getRole() != role) continue;
                ended = true;
                result = actor;
                continue;
            }
            ended = true;
            result = null;
        }
        return result;
    }

    public RoleActor get(int individualId, String roleName) {
        boolean ended = false;
        RoleActor result = null;
        Iterator iterator = this.iterator();
        while (!ended) {
            if (iterator.hasNext()) {
                RoleActor actor = (RoleActor)iterator.next();
                if (actor.getId() != individualId || !StringUtils.equals((CharSequence)actor.getRole().getName(), (CharSequence)roleName)) continue;
                ended = true;
                result = actor;
                continue;
            }
            ended = true;
            result = null;
        }
        return result;
    }

    public RoleActors getByIndividual(Individual individual) {
        RoleActors result = new RoleActors();
        for (RoleActor actor : this) {
            if (!actor.getIndividual().equals(individual)) continue;
            result.add(actor);
        }
        return result;
    }

    public RoleActors getById(int id) {
        RoleActors result = new RoleActors();
        for (RoleActor actor : this) {
            if (actor.getId() != id) continue;
            result.add(actor);
        }
        return result;
    }

    public RoleActors getByImpliedAbsoluteRole(MetaRole role) {
        RoleActors result = new RoleActors();
        for (RoleActor actor : this) {
            if (!role.specifiesAbsolute(actor.getRole())) continue;
            result.add(actor);
        }
        return result;
    }

    public RoleActors getByRole(MetaRole role) {
        RoleActors result = new RoleActors();
        for (RoleActor actor : this) {
            if (actor.getRole() != role) continue;
            result.add(actor);
        }
        return result;
    }

    public RoleActors getByRole(String role) {
        RoleActors result = new RoleActors();
        for (RoleActor actor : this) {
            if (!StringUtils.equals((CharSequence)actor.getRole().getName(), (CharSequence)role)) continue;
            result.add(actor);
        }
        return result;
    }

    public RoleActors getOthers(int id) {
        RoleActors result = new RoleActors();
        for (RoleActor actor : this) {
            if (actor.getId() == id) continue;
            result.add(actor);
        }
        return result;
    }

    public Roles getRoles(int id) {
        Roles result = new Roles();
        for (RoleActor actor : this) {
            if (actor.getId() != id) continue;
            result.add(actor.getRole());
        }
        return result;
    }

    public Roles getRoles() {
        Roles result = new Roles();
        for (RoleActor actor : this) {
            if (result.contains(actor.getRole())) continue;
            result.add(actor.getRole());
        }
        return result;
    }

    public Roles getIndividuals() {
        Roles result = new Roles();
        for (RoleActor actor : this) {
            if (result.contains(actor.getIndividual())) continue;
            result.add(actor.getIndividual());
        }
        return result;
    }

    public boolean hasActor(int id) {
        boolean ended = false;
        boolean result = false;
        Iterator iterator = this.iterator();
        while (!ended) {
            if (iterator.hasNext()) {
                RoleActor actor = (RoleActor)iterator.next();
                if (actor.getId() != id) continue;
                ended = true;
                result = true;
                continue;
            }
            ended = true;
            result = false;
        }
        return result;
    }

    public boolean hasActor(int id, String role) {
        boolean ended = false;
        boolean result = false;
        Iterator iterator = this.iterator();
        while (!ended) {
            if (iterator.hasNext()) {
                RoleActor actor = (RoleActor)iterator.next();
                if (actor.getId() != id || !StringUtils.equals((CharSequence)actor.getRole().getName(), (CharSequence)role)) continue;
                ended = true;
                result = true;
                continue;
            }
            ended = true;
            result = false;
        }
        return result;
    }

    public RoleActor[] toArray() {
        RoleActor[] result = new RoleActor[this.size()];
        int actorCount = 0;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            RoleActor actor;
            result[actorCount] = actor = (RoleActor)iterator.next();
            ++actorCount;
        }
        return result;
    }

    public List<RoleActor> toList() {
        ArrayList<RoleActor> result = new ArrayList<RoleActor>(this.size());
        for (RoleActor actor : this) {
            result.add(actor);
        }
        return result;
    }

    public List<RoleActor> toSortedList() {
        List<RoleActor> result = this.toList();
        Collections.sort(result);
        return result;
    }

    public List<RoleActor> toSortedListReverse() {
        List<RoleActor> result = this.toList();
        Collections.sort(result, Collections.reverseOrder());
        return result;
    }

    public List<RoleActor> toListSortedByRoles() {
        List<RoleActor> result = this.toList();
        Collections.sort(result, new RoleActorComparator());
        return result;
    }

    public List<RoleActor> toListSortedByDistances(RoleRelations relations) {
        List<RoleActor> result = this.toList();
        Collections.sort(result, new RoleActorComparator(relations));
        return result;
    }

    public boolean containsAbsolute(RoleActor actor) {
        boolean result = false;
        for (RoleActor otherActor : this) {
            if (!otherActor.matchesAbsolute(actor)) continue;
            result = true;
            break;
        }
        return result;
    }

    @Override
    public int compareTo(RoleActors others) {
        int result = 0;
        List<RoleActor> sortedActors = this.toListSortedByRoles();
        List<RoleActor> sortedOthers = others.toListSortedByRoles();
        int i = 0;
        while (i < this.size()) {
            if (i == others.size()) {
                result = 1;
                break;
            }
            result = new RoleActorComparator().compare(sortedActors.get(i), sortedOthers.get(i));
            if (result != 0) break;
            ++i;
        }
        if (result == 0 && this.size() < others.size()) {
            result = -1;
        }
        return result;
    }

    public String toLetters() {
        String result = null;
        for (RoleActor actor : this) {
            if (result == null) {
                String symbol = "";
                if (!actor.getEgoGender().isUnknown()) {
                    symbol = String.valueOf(symbol) + actor.getEgoGender().toSymbol();
                }
                result = String.valueOf(symbol) + actor.getRole().toLetter();
                continue;
            }
            result = String.valueOf(result) + actor.getRole().toLetter();
        }
        return result;
    }

    @Override
    public RoleActor getLast() {
        RoleActor result = this.isEmpty() ? null : (RoleActor)this.get(this.size() - 1);
        return result;
    }

    @Override
    public RoleActor getFirst() {
        RoleActor result = this.isEmpty() ? null : (RoleActor)this.get(0);
        return result;
    }
}

