/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public enum Gender {
    MALE(0),
    FEMALE(1),
    UNKNOWN(2);

    private static final char MALE_CHAR = '\u2642';
    private static final char FEMALE_CHAR = '\u2640';
    private static final char NEUTRAL_CHAR = '\u26b2';
    private int code;

    private Gender(int code) {
        this.code = code;
    }

    public boolean canMarry(Gender gender) {
        boolean result = this != gender || this == UNKNOWN;
        return result;
    }

    public static Gender valueOfSymbol(char symbol) {
        Gender result = UNKNOWN;
        switch (symbol) {
            case '\u2640': {
                result = FEMALE;
                break;
            }
            case '\u2642': {
                result = MALE;
                break;
            }
            case '\u26b2': {
                result = UNKNOWN;
            }
        }
        return result;
    }

    public Gender invert() {
        Gender result = this == MALE ? FEMALE : (this == FEMALE ? MALE : this);
        return result;
    }

    public boolean isFemale() {
        boolean result = this == FEMALE;
        return result;
    }

    public boolean isMale() {
        boolean result = this == MALE;
        return result;
    }

    public boolean isUnknown() {
        boolean result = this == UNKNOWN;
        return result;
    }

    public boolean matchs(Gender gender) {
        boolean result = gender == null || this == UNKNOWN || gender == UNKNOWN || this == gender;
        return result;
    }

    public boolean specifies(Gender gender) {
        boolean result = gender == UNKNOWN || this == gender;
        return result;
    }

    public char toAscendantChar() {
        char result;
        switch (this) {
            case FEMALE: {
                result = 'M';
                break;
            }
            case MALE: {
                result = 'F';
                break;
            }
            default: {
                result = 'P';
            }
        }
        return result;
    }

    public char toChar() {
        char result;
        switch (this) {
            case FEMALE: {
                result = 'F';
                break;
            }
            case MALE: {
                result = 'H';
                break;
            }
            default: {
                result = 'X';
            }
        }
        return result;
    }

    public char toGedChar() {
        char result;
        switch (this) {
            case FEMALE: {
                result = 'F';
                break;
            }
            case MALE: {
                result = 'M';
                break;
            }
            default: {
                result = 'X';
            }
        }
        return result;
    }

    public char toDescendantChar() {
        char result;
        switch (this) {
            case FEMALE: {
                result = 'D';
                break;
            }
            case MALE: {
                result = 'S';
                break;
            }
            default: {
                result = 'C';
            }
        }
        return result;
    }

    public char toSpouseChar() {
        char result;
        switch (this) {
            case FEMALE: {
                result = 'W';
                break;
            }
            case MALE: {
                result = 'H';
                break;
            }
            default: {
                result = 'X';
            }
        }
        return result;
    }

    public int toInt() {
        int result = this.code;
        return result;
    }

    public String toShapeString() {
        String result;
        switch (this) {
            case FEMALE: {
                result = "ellipse";
                break;
            }
            case MALE: {
                result = "triangle";
                break;
            }
            default: {
                result = "diamond";
            }
        }
        return result;
    }

    public char toSymbol() {
        char result;
        switch (this) {
            case FEMALE: {
                result = '\u2640';
                break;
            }
            case MALE: {
                result = '\u2642';
                break;
            }
            default: {
                result = '\u26b2';
            }
        }
        return result;
    }

    public String toSpeakerString() {
        String result;
        switch (this) {
            case FEMALE: {
                result = "f.s.";
                break;
            }
            case MALE: {
                result = "m.s.";
                break;
            }
            default: {
                result = "";
            }
        }
        return result;
    }

    public static int compare(Gender alpha, Gender bravo) {
        int result = alpha == null && bravo == null ? 0 : (alpha == null ? -1 : (bravo == null ? 1 : alpha.compareTo(bravo)));
        return result;
    }

    public static List<Gender> getChartValueList() {
        List<Gender> result = Arrays.asList(Gender.getChartValues());
        return result;
    }

    public static Gender[] getChartValues() {
        Gender[] result = new Gender[]{FEMALE, MALE, UNKNOWN};
        return result;
    }

    public static char inverseGenderSymbol(char c) {
        char result = ' ';
        switch (c) {
            case '\u2640': {
                result = '\u2642';
                break;
            }
            case '\u2642': {
                result = '\u2640';
                break;
            }
            case '\u26b2': {
                result = '\u26b2';
            }
        }
        return result;
    }

    public static boolean isGenderSymbol(char c) {
        boolean result = c == '\u2640' || c == '\u2642' || c == '\u26b2';
        return result;
    }

    public static boolean matchesChar(char letter, char symbol) {
        boolean result = symbol == '\u2642' && (letter == 'F' || letter == 'S' || letter == 'H' || letter == 'B') || symbol == '\u2640' && (letter == 'M' || letter == 'D' || letter == 'W' || letter == 'Z');
        return result;
    }

    public static boolean sameSexChar(char firstLetter, char secondLetter) {
        boolean result = secondLetter == 'H' && (firstLetter == 'F' || firstLetter == 'S' || firstLetter == 'H' || firstLetter == 'B') || secondLetter == 'W' && (firstLetter == 'M' || firstLetter == 'D' || firstLetter == 'W' || firstLetter == 'Z');
        return result;
    }

    public static Gender valueOf(int value) {
        Gender result;
        switch (value) {
            case 0: {
                result = MALE;
                break;
            }
            case 1: {
                result = FEMALE;
                break;
            }
            default: {
                result = UNKNOWN;
            }
        }
        return result;
    }

    public static List<Gender> valuesNotUnknown() {
        ArrayList<Gender> result = new ArrayList<Gender>();
        Gender[] genderArray = Gender.values();
        int n = genderArray.length;
        int n2 = 0;
        while (n2 < n) {
            Gender gender = genderArray[n2];
            if (!gender.isUnknown()) {
                result.add(gender);
            }
            ++n2;
        }
        return result;
    }

    public String toStringNoUnknown() {
        String result = this.isUnknown() ? "" : this.toString();
        return result;
    }

    public int compareToUnknownFirst(Gender other) {
        int result = this.isUnknown() && !other.isUnknown() ? -1 : (!this.isUnknown() && other.isUnknown() ? 1 : this.compareTo(other));
        return result;
    }

    public static Gender[] values() {
        Gender[] genderArray = ENUM$VALUES;
        int n = genderArray.length;
        Gender[] genderArray2 = new Gender[n];
        System.arraycopy(ENUM$VALUES, 0, genderArray2, 0, n);
        return genderArray2;
    }

    public static Gender valueOf(String string) {
        return Enum.valueOf(Gender.class, string);
    }
}

