/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.graphs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.tip.puck.graphs.Node;
import org.tip.puck.graphs.NodeComparatorByLabel;

public class WeightedNodes<E>
extends HashMap<Node<E>, Double>
implements Iterable<Node<E>> {
    private static final long serialVersionUID = -5631405850137514711L;

    public WeightedNodes() {
    }

    public WeightedNodes(int initialCapacity) {
        super(initialCapacity);
    }

    public void add(Node<E> targetNode) {
        this.put(targetNode, 0.0);
    }

    public void add(Node<E> targetNode, double weight) {
        this.put(targetNode, weight);
    }

    public void addWeight(Node<E> targetNode, double value) {
        Double weight = (Double)this.get(targetNode);
        if (weight == null) {
            weight = 0.0;
        }
        this.put(targetNode, weight + value);
    }

    public double average() {
        double result = this.size() == 0 ? 0.0 : this.sum() / (double)this.size();
        return result;
    }

    public double averagePositive() {
        double sum = 0.0;
        int count = 0;
        for (Double value : this.values()) {
            if (value == null || !(value > 0.0)) continue;
            ++count;
            sum += value.doubleValue();
        }
        double result = count == 0 ? 0.0 : sum / (double)count;
        return result;
    }

    public Double getWeight(Node<E> targetNode) {
        Double result = (Double)this.get(targetNode);
        return result;
    }

    public void incWeight(Node<E> targetNode) {
        Double weight = (Double)this.get(targetNode);
        if (weight == null) {
            weight = 0.0;
        }
        this.put(targetNode, weight + 1.0);
    }

    @Override
    public Iterator<Node<E>> iterator() {
        Iterator<Node<E>> result = super.keySet().iterator();
        return result;
    }

    public double max() {
        double result;
        if (this.size() == 0) {
            result = 0.0;
        } else {
            result = Double.MIN_VALUE;
            for (Double value : this.values()) {
                if (value == null || !(value > result)) continue;
                result = value;
            }
        }
        return result;
    }

    public double min() {
        double result;
        if (this.size() == 0) {
            result = 0.0;
        } else {
            result = Double.MAX_VALUE;
            for (Double value : this.values()) {
                if (value == null || !(value < result)) continue;
                result = value;
            }
        }
        return result;
    }

    public void setWeight(Node<E> targetNode, double value) {
        this.put(targetNode, value);
    }

    public double sum() {
        double result = 0.0;
        for (Double value : this.values()) {
            if (value == null) continue;
            result += value.doubleValue();
        }
        return result;
    }

    public List<Node<E>> toList() {
        ArrayList<Node<E>> result = new ArrayList<Node<E>>(this.keySet());
        return result;
    }

    public List<Node<E>> toListSortedByLabel() {
        List<Node<E>> result = this.toList();
        Collections.sort(result, new NodeComparatorByLabel());
        return result;
    }
}

