/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.geo;

import fr.devinsy.util.StringList;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tip.puck.PuckException;
import org.tip.puck.geo.GeoLevel;
import org.tip.puck.geo.Place;
import org.tip.puck.geo.Places;
import org.tip.puck.geo.io.PlaceFile;
import org.tip.puck.graphs.Graph;
import org.tip.puck.partitions.Partition;
import org.tip.puck.util.Value;

public class Geography {
    private static Geography geography;
    private Map<GeoLevel, Map<String, Place>> levels = new HashMap<GeoLevel, Map<String, Place>>();
    private Map<String, String> homonyms;
    private Map<String, Map<GeoLevel, Place>> sups = new HashMap<String, Map<GeoLevel, Place>>();
    private Map<String, Place> toponyms;

    public Geography() {
        GeoLevel[] geoLevelArray = GeoLevel.values();
        int n = geoLevelArray.length;
        int n2 = 0;
        while (n2 < n) {
            GeoLevel level = geoLevelArray[n2];
            this.levels.put(level, new HashMap());
            ++n2;
        }
        this.homonyms = new HashMap<String, String>();
        this.toponyms = new HashMap<String, Place>();
    }

    public Places getPlaces() {
        Places result = new Places();
        for (GeoLevel level : this.levels.keySet()) {
            if (level == GeoLevel.INTERCONTINENTAL) continue;
            for (Place place : this.levels.get((Object)level).values()) {
                result.put(place.getId(), place);
            }
        }
        return result;
    }

    public Map<String, StringList> homonymLists() {
        HashMap<String, StringList> result = new HashMap<String, StringList>();
        for (String homonym : this.homonyms.keySet()) {
            String id = this.homonyms.get(homonym);
            StringList list = (StringList)result.get(id);
            if (list == null) {
                list = new StringList();
                result.put(id, list);
            }
            list.append(homonym);
        }
        for (StringList list : result.values()) {
            list.sort();
        }
        return result;
    }

    public Place get(GeoLevel level, String id) {
        return this.levels.get((Object)level).get(id);
    }

    private Place get(String id) {
        Place result = null;
        GeoLevel[] geoLevelArray = GeoLevel.values();
        int n = geoLevelArray.length;
        int n2 = 0;
        while (n2 < n) {
            GeoLevel level = geoLevelArray[n2];
            result = this.levels.get((Object)level).get(id);
            if (result != null) break;
            ++n2;
        }
        return result;
    }

    public Place getByToponym(String toponym) {
        return this.toponyms.get(toponym);
    }

    public String getToponym(String homonym) {
        Place place = this.getByHomonym(homonym);
        String result = place == null ? null : place.getToponym();
        return result;
    }

    public String getToponym(String homonym, String parameter) {
        Place place = this.getPlace(homonym, parameter);
        String result = place == null ? null : place.getToponym();
        return result;
    }

    public void putUncodedPlaces(Partition<Place> uncodedPlaces, String placeName) {
        Place place = this.getByHomonym(placeName);
        if (place != null && place.getCoordinate() == null) {
            uncodedPlaces.put(place, new Value(place.getLevel()));
            Place sup = place.getSup();
            while (sup.getCoordinate() == null) {
                uncodedPlaces.put(sup, new Value(sup.getLevel()));
                sup = sup.getSup();
            }
        }
    }

    public Place getByHomonym(String homonym) {
        Place result;
        if (homonym == null) {
            result = null;
        } else {
            result = this.get(this.homonyms.get(homonym));
            if (result == null) {
                System.err.println("missing geography entry:\t" + homonym);
            }
        }
        return result;
    }

    public Place getCommonAncestor(Place first, Place second) {
        Place result = null;
        if (first == second) {
            result = first;
        } else if (first != null && second != null) {
            int comp = first.compareByLevel(second);
            if (comp == 0) {
                result = this.getCommonAncestor(first.getSup(), second.getSup());
            } else if (comp < 0) {
                result = this.getCommonAncestor(first, second.getSup());
            } else if (comp > 0) {
                result = this.getCommonAncestor(first.getSup(), second);
            }
        }
        return result;
    }

    public GeoLevel getDistance(String startName, String endName) {
        GeoLevel result;
        Place start = this.getByHomonym(startName);
        Place end = this.getByHomonym(endName);
        if (start != null && end != null) {
            Place commonAncestor = this.getCommonAncestor(start, end);
            result = commonAncestor.getLevel();
        } else {
            result = null;
        }
        return result;
    }

    public Place getPlace(String homonym, GeoLevel level) {
        Place result = this.getByHomonym(homonym) == null ? null : this.getByHomonym(homonym).atLevel(level);
        return result;
    }

    public Place getPlace(String homonym, String parameter) {
        Place result;
        try {
            result = this.getPlace(homonym, GeoLevel.valueOf(parameter));
        }
        catch (IllegalArgumentException iae) {
            result = this.getPlaceByCenter(homonym, parameter);
        }
        return result;
    }

    private Place getPlaceByCenter(String homonym, String center) {
        GeoLevel centerLevel = this.getByHomonym(center).getLevel();
        Place result = null;
        if (homonym.equals(center)) {
            result = this.getByHomonym(homonym);
        } else {
            GeoLevel[] geoLevelArray = GeoLevel.values();
            int n = geoLevelArray.length;
            int n2 = 0;
            while (n2 < n) {
                GeoLevel level = geoLevelArray[n2];
                Place preResult = this.getPlace(homonym, level);
                if (preResult == null) break;
                result = preResult;
                if (level.ordinal() > centerLevel.ordinal() || level == GeoLevel.HOMONYM || result != null && !result.equals(this.getPlace(center, level))) break;
                ++n2;
            }
        }
        return result;
    }

    public Place getSup(String homonym, List<String> placenames) {
        Place result = this.getByHomonym(homonym) == null ? null : this.getByHomonym(homonym).getSup(placenames);
        return result;
    }

    public Graph<Place> graph(GeoLevel level) {
        Graph<Place> result = new Graph<Place>();
        for (Place place : this.places(level)) {
            result.addNode(place);
        }
        return result;
    }

    private Places places(GeoLevel level) {
        Places result = new Places();
        Map<String, Place> placeMap = this.levels.get((Object)level);
        if (placeMap != null) {
            for (Place place : placeMap.values()) {
                result.put(place.getId(), place);
            }
        }
        return result;
    }

    public void put(Place place) {
        this.levels.get((Object)place.getLevel()).put(place.getId(), place);
        this.toponyms.put(place.getToponym(), place);
    }

    public void put(String homonym, Place place) {
        this.homonyms.put(homonym, place.getId());
    }

    public static Geography getInstance() {
        if (geography == null) {
            try {
                geography = PlaceFile.loadGeoData(new File("src/org/tip/puck/geo/data/togo.txt"));
            }
            catch (PuckException e) {
                geography = null;
            }
        }
        return geography;
    }

    public void updateDistricts() {
        for (Place district : this.levels.get((Object)GeoLevel.TOWNSHIP).values()) {
            if (district.getCoordinate() != null) continue;
            String townId = this.homonyms.get(district.getName());
            Place town = this.levels.get((Object)GeoLevel.TOWN).get(townId);
            if (town == null) continue;
            district.setCoordinate(town.getCoordinate());
        }
    }
}

