/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.census.workers;

import org.tip.puck.PuckException;
import org.tip.puck.census.chains.Chain;
import org.tip.puck.census.chains.Couple;
import org.tip.puck.census.chains.Notation;
import org.tip.puck.census.workers.CircuitFinder;
import org.tip.puck.graphs.Graph;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Individuals;
import org.tip.puck.net.Net;
import org.tip.puck.net.workers.NetUtils;

public class CensusUtils {
    public static Graph<Individual> createCircuitNetwork(Chain circuit) throws PuckException {
        if (circuit == null) {
            throw new NullPointerException("Null parameter detected.");
        }
        Graph<Individual> result = new Graph<Individual>("Circuit " + circuit.signature(Notation.CLASSIC) + " " + circuit.signature(Notation.NUMBERS));
        result.incEdgeWeight(circuit.getLast(), circuit.getFirst());
        int i = 0;
        while (i < circuit.length()) {
            Individuals alters;
            Individuals egos;
            Individual first = (Individual)circuit.get(i);
            Individual second = (Individual)circuit.get(i + 1);
            if (first instanceof Couple) {
                egos = ((Couple)first).individuals();
            } else {
                egos = new Individuals();
                egos.add(first);
            }
            if (second instanceof Couple) {
                alters = ((Couple)second).individuals();
            } else {
                alters = new Individuals();
                alters.add(second);
            }
            int dir = circuit.dir(i + 1);
            for (Individual ego : egos) {
                for (Individual alter : alters) {
                    if (dir == 0) {
                        result.incEdgeWeight(ego, alter);
                        continue;
                    }
                    if (dir == -1) {
                        result.incArcWeight(ego, alter);
                        continue;
                    }
                    if (dir != 1) continue;
                    result.incArcWeight(alter, ego);
                }
            }
            ++i;
        }
        return result;
    }

    public static Net createCircuitInducedNet(CircuitFinder source) throws PuckException {
        Net result = new Net();
        if (source == null) {
            throw new NullPointerException("Null parameter detected.");
        }
        for (Chain circuit : source.getCircuits().getItems()) {
            Individual ego = result.getCloneWithAttributes((Individual)circuit.get(circuit.length()));
            Individual alter = result.getCloneWithAttributes((Individual)circuit.get(0));
            NetUtils.setKinSpouse(result, ego, alter);
            int i = 0;
            while (i < circuit.length()) {
                Individuals alters;
                Individuals egos;
                Individual first = (Individual)circuit.get(i);
                Individual second = (Individual)circuit.get(i + 1);
                if (first instanceof Couple) {
                    egos = ((Couple)first).individuals();
                } else {
                    egos = new Individuals();
                    egos.add(first);
                }
                if (second instanceof Couple) {
                    alters = ((Couple)second).individuals();
                } else {
                    alters = new Individuals();
                    alters.add(second);
                }
                int dir = circuit.dir(i + 1);
                for (Individual protoEgo : egos) {
                    ego = result.getCloneWithAttributes(protoEgo);
                    for (Individual protoAlter : alters) {
                        alter = result.getCloneWithAttributes(protoAlter);
                        if (dir == 0) {
                            NetUtils.setKinSpouse(result, ego, alter);
                            continue;
                        }
                        if (dir == -1) {
                            NetUtils.setKinParent(result, ego, alter);
                            continue;
                        }
                        if (dir != 1) continue;
                        NetUtils.setKinParent(result, alter, ego);
                    }
                }
                ++i;
            }
        }
        result.setLabel(String.valueOf(result.getLabel()) + " Circuit Induced Network " + source.censusDetails);
        return result;
    }

    public static Graph<Individual> createCircuitInducedNetwork(CircuitFinder source) throws PuckException {
        if (source == null) {
            throw new NullPointerException("Null parameter detected.");
        }
        Graph<Individual> result = new Graph<Individual>("Circuit-Induced Network " + source.getLabel());
        for (Chain circuit : source.getCircuits().getItems()) {
            result.incEdgeWeight(circuit.getFirst(), circuit.getLast());
            int i = 0;
            while (i < circuit.length()) {
                Individuals alters;
                Individuals egos;
                Individual first = (Individual)circuit.get(i);
                Individual second = (Individual)circuit.get(i + 1);
                if (first instanceof Couple) {
                    egos = ((Couple)first).individuals();
                } else {
                    egos = new Individuals();
                    egos.add(first);
                }
                if (second instanceof Couple) {
                    alters = ((Couple)second).individuals();
                } else {
                    alters = new Individuals();
                    alters.add(second);
                }
                int dir = circuit.dir(i + 1);
                for (Individual ego : egos) {
                    for (Individual alter : alters) {
                        if (dir == 0) {
                            result.incEdgeWeight(ego, alter);
                            continue;
                        }
                        if (dir == -1) {
                            result.incArcWeight(ego, alter);
                            continue;
                        }
                        if (dir != 1) continue;
                        result.incArcWeight(alter, ego);
                    }
                }
                ++i;
            }
        }
        NetUtils.setGenderShapes(result);
        return result;
    }

    public static Graph<Individual> createCircuitInducedFrameNetwork(CircuitFinder source) throws PuckException {
        if (source == null) {
            throw new NullPointerException("Null parameter detected.");
        }
        Graph<Individual> result = new Graph<Individual>("Circuit-Induced Frame Network " + source.getLabel());
        for (Chain circuit : source.getCircuits().getItems()) {
            int i = 0;
            while (i < 2 * circuit.dim()) {
                Individual second;
                Individual first = circuit.getPivot(i);
                if (first != (second = circuit.getPivot(i + 1))) {
                    result.addEdge(first, second, (double)(1 - 2 * ((i + 1) % 2)));
                }
                ++i;
            }
        }
        NetUtils.setGenderShapes(result);
        return result;
    }
}

