/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.views;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EmptyBorder;
import org.apache.commons.lang3.StringUtils;
import org.tip.puck.net.workers.AttributeWorker;
import org.tip.puckgui.views.RemoveAttributeCriteria;

public class RemoveAttributeInputDialog
extends JDialog {
    private static final long serialVersionUID = 7208254679850378876L;
    private final JPanel contentPanel = new JPanel();
    private RemoveAttributeCriteria dialogCriteria;
    private static RemoveAttributeCriteria lastCriteria = new RemoveAttributeCriteria();
    private final ButtonGroup buttonGroupType = new ButtonGroup();
    private JComboBox cmbbxTarget;
    private JComboBox cmbbxLabel;
    private JRadioButton rdbtnVoid;
    private JRadioButton rdbtnBlanked;
    private JRadioButton rdbtnForcedBlank;

    public RemoveAttributeInputDialog(List<String> relationModelNames, List<String> attributeNames) {
        ArrayList<String> targetLabels = new ArrayList<String>();
        targetLabels.add("ALL");
        targetLabels.add("CORPUS");
        targetLabels.add("INDIVIDUALS");
        targetLabels.add("FAMILIES");
        targetLabels.add("RELATIONS");
        if (relationModelNames != null) {
            for (String name : relationModelNames) {
                targetLabels.add(name);
            }
        }
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setModal(true);
        this.setAlwaysOnTop(true);
        this.setTitle("Remove Attribute Input");
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(RemoveAttributeInputDialog.class.getResource("/org/tip/puckgui/favicon-16x16.jpg")));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                RemoveAttributeInputDialog.this.dialogCriteria = null;
                RemoveAttributeInputDialog.this.setVisible(false);
            }
        });
        this.setBounds(100, 100, 366, 235);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow")}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        JLabel lblTarget = new JLabel("Target:");
        this.contentPanel.add((Component)lblTarget, "2, 2, right, default");
        this.cmbbxTarget = new JComboBox<Object>(targetLabels.toArray());
        this.contentPanel.add((Component)this.cmbbxTarget, "4, 2, fill, default");
        JLabel lblLabel = new JLabel("Label:");
        this.contentPanel.add((Component)lblLabel, "2, 4, right, default");
        List<String> names = attributeNames == null ? new ArrayList<String>() : attributeNames;
        this.cmbbxLabel = new JComboBox<Object>(names.toArray());
        this.cmbbxLabel.setEditable(true);
        this.contentPanel.add((Component)this.cmbbxLabel, "4, 4, fill, default");
        JLabel lblType = new JLabel("Type:");
        this.contentPanel.add((Component)lblType, "2, 6, right, default");
        JPanel panel = new JPanel();
        this.contentPanel.add((Component)panel, "4, 6, fill, fill");
        panel.setLayout(new BoxLayout(panel, 1));
        this.rdbtnVoid = new JRadioButton("removed");
        this.buttonGroupType.add(this.rdbtnVoid);
        this.rdbtnVoid.setSelected(true);
        panel.add(this.rdbtnVoid);
        this.rdbtnBlanked = new JRadioButton("replace by an empty string");
        this.buttonGroupType.add(this.rdbtnBlanked);
        panel.add(this.rdbtnBlanked);
        this.rdbtnForcedBlank = new JRadioButton("set to an empty string");
        this.buttonGroupType.add(this.rdbtnForcedBlank);
        panel.add(this.rdbtnForcedBlank);
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(1));
        this.getContentPane().add((Component)buttonPane, "South");
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RemoveAttributeInputDialog.this.dialogCriteria = null;
                RemoveAttributeInputDialog.this.setVisible(false);
            }
        });
        cancelButton.setActionCommand("Cancel");
        buttonPane.add(cancelButton);
        JButton okButton = new JButton("OK");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RemoveAttributeCriteria criteria = RemoveAttributeInputDialog.this.getCriteria();
                if (StringUtils.isBlank((CharSequence)criteria.getLabel())) {
                    String title = "Invalid input";
                    String message = "Please, enter a label not empty.";
                    JOptionPane.showMessageDialog(null, message, title, 0);
                } else {
                    lastCriteria = criteria;
                    RemoveAttributeInputDialog.this.dialogCriteria = criteria;
                    RemoveAttributeInputDialog.this.setVisible(false);
                }
            }
        });
        okButton.setActionCommand("OK");
        buttonPane.add(okButton);
        this.getRootPane().setDefaultButton(okButton);
        this.setCriteria(lastCriteria);
    }

    public RemoveAttributeCriteria getCriteria() {
        String optionalName;
        AttributeWorker.Scope scope;
        RemoveAttributeCriteria result = new RemoveAttributeCriteria();
        switch (this.cmbbxTarget.getSelectedIndex()) {
            case 0: {
                scope = AttributeWorker.Scope.ALL;
                optionalName = null;
                break;
            }
            case 1: {
                scope = AttributeWorker.Scope.CORPUS;
                optionalName = null;
                break;
            }
            case 2: {
                scope = AttributeWorker.Scope.INDIVIDUALS;
                optionalName = null;
                break;
            }
            case 3: {
                scope = AttributeWorker.Scope.FAMILIES;
                optionalName = null;
                break;
            }
            case 4: {
                scope = AttributeWorker.Scope.RELATIONS;
                optionalName = null;
                break;
            }
            default: {
                scope = AttributeWorker.Scope.RELATION;
                optionalName = (String)this.cmbbxTarget.getSelectedItem();
            }
        }
        result.setScope(scope);
        result.setOptionalRelationName(optionalName);
        result.setLabel((String)this.cmbbxLabel.getSelectedItem());
        if (this.rdbtnVoid.isSelected()) {
            result.setType(AttributeWorker.EmptyType.VOID);
        } else if (this.rdbtnBlanked.isSelected()) {
            result.setType(AttributeWorker.EmptyType.BLANK);
        } else {
            result.setType(AttributeWorker.EmptyType.FORCED_BLANK);
        }
        return result;
    }

    public RemoveAttributeCriteria getDialogCriteria() {
        RemoveAttributeCriteria result = this.dialogCriteria;
        return result;
    }

    private void setCriteria(RemoveAttributeCriteria source) {
        if (source != null) {
            switch (source.getScope()) {
                case ALL: {
                    this.cmbbxTarget.setSelectedIndex(0);
                    break;
                }
                case CORPUS: {
                    this.cmbbxTarget.setSelectedIndex(1);
                    break;
                }
                case INDIVIDUALS: {
                    this.cmbbxTarget.setSelectedIndex(2);
                    break;
                }
                case FAMILIES: {
                    this.cmbbxTarget.setSelectedIndex(3);
                    break;
                }
                case RELATIONS: {
                    this.cmbbxTarget.setSelectedIndex(4);
                    break;
                }
                default: {
                    this.cmbbxTarget.setSelectedItem(source.getOptionalRelationName());
                }
            }
            this.cmbbxLabel.setSelectedItem(source.getLabel());
            switch (source.getType()) {
                case VOID: {
                    this.rdbtnVoid.setSelected(true);
                    this.rdbtnBlanked.setSelected(false);
                    this.rdbtnForcedBlank.setSelected(false);
                    break;
                }
                case BLANK: {
                    this.rdbtnVoid.setSelected(false);
                    this.rdbtnBlanked.setSelected(true);
                    this.rdbtnForcedBlank.setSelected(false);
                    break;
                }
                case FORCED_BLANK: {
                    this.rdbtnVoid.setSelected(false);
                    this.rdbtnBlanked.setSelected(false);
                    this.rdbtnForcedBlank.setSelected(true);
                }
            }
        }
    }

    public static void main(String[] args) {
        RemoveAttributeCriteria criteria = RemoveAttributeInputDialog.showDialog(null, null);
    }

    public static RemoveAttributeCriteria showDialog(List<String> relationModelNames, List<String> attributeNames) {
        RemoveAttributeInputDialog dialog = new RemoveAttributeInputDialog(relationModelNames, attributeNames);
        dialog.setLocationRelativeTo(null);
        dialog.pack();
        dialog.setVisible(true);
        RemoveAttributeCriteria result = dialog.getDialogCriteria();
        return result;
    }
}

