/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.visualization.layouts.hierarchical.datastructs.chain.containers;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gephi.graph.api.Node;
import org.tip.puck.visualization.layouts.GraphSource;
import org.tip.puck.visualization.layouts.hierarchical.datastructs.chain.ColoredChain;
import org.tip.puck.visualization.layouts.hierarchical.datastructs.chain.NodeLayoutData;
import org.tip.puck.visualization.layouts.hierarchical.datastructs.chain.Triad;
import org.tip.puck.visualization.layouts.hierarchical.datastructs.chain.containers.ChainContainer;

public class BorderContainer
extends ChainContainer {
    private Map<Node, Triad> triads = new HashMap<Node, Triad>();

    protected BorderContainer(ColoredChain chain) {
        super(chain);
    }

    @Override
    public void populateChildren(GraphSource graphSource) {
        this.children = new HashSet();
        Node bottomNode = this.chain.getBottomNode();
        Set<Node> bootomChildren = graphSource.getChildren(bottomNode);
        for (Node node : bootomChildren) {
            if (NodeLayoutData.isColored(node, NodeLayoutData.Color.RED)) {
                BorderContainer target;
                BorderContainer source;
                int otherLevel;
                Node otherParent = graphSource.getOtherParent(node, bottomNode);
                NodeLayoutData.setContainer(bottomNode, this);
                BorderContainer container = NodeLayoutData.getContainer(otherParent);
                if (container == null) continue;
                int thisLevel = this.chain.getHeight() + this.origin;
                if (thisLevel > (otherLevel = container.chain.getHeight() + container.origin)) {
                    source = this;
                    target = container;
                } else if (thisLevel < otherLevel) {
                    source = container;
                    target = this;
                } else {
                    int otherSize;
                    int thisSize = this.rootCluster.getSize();
                    if (thisSize > (otherSize = container.getRootCluster().getSize())) {
                        source = this;
                        target = container;
                    } else {
                        source = container;
                        target = this;
                    }
                }
                Triad triad = new Triad(source, target);
                triad.addChildren(node);
                this.addTriad(triad, otherParent);
                container.addTriad(triad, bottomNode);
                continue;
            }
            ChainContainer container = BorderContainer.getContainer(node, graphSource);
            container.setRootCluster(this.rootCluster);
            container.setOrigin(this.origin + this.chain.getHeight() + 1);
            if (container instanceof BorderContainer) {
                this.rootCluster.addBorder((BorderContainer)container);
            }
            this.children.add(container);
        }
        for (ChainContainer chainContainer : this.children) {
            chainContainer.populateChildren(graphSource);
        }
        this.populateTriadsClusters(graphSource);
    }

    public void populateTriadsClusters(GraphSource graphSource) {
        Collection<Triad> values = this.triads.values();
        for (Triad triad : values) {
            triad.buildClusters(graphSource);
        }
    }

    public Node getBottomNode() {
        return this.chain.getBottomNode();
    }

    @Override
    public Set<ChainContainer> getChildren() {
        Set<ChainContainer> superChildren = super.getChildren();
        HashSet<ChainContainer> newChildren = new HashSet<ChainContainer>(superChildren);
        for (Map.Entry<Node, Triad> entry : this.triads.entrySet()) {
            Triad triad = entry.getValue();
            if (!triad.isOn(this) || !triad.isBuilt()) continue;
            Set<ChainContainer> clusters = triad.getClusters();
            newChildren.addAll(clusters);
        }
        return newChildren;
    }

    public void addTriad(Triad triad, Node otherParent) {
        if (!this.triads.containsKey(otherParent)) {
            this.triads.put(otherParent, triad);
        } else {
            Triad otherTriad = this.triads.get(otherParent);
            Set<Node> childrenT = triad.getChildren();
            for (Node node : childrenT) {
                otherTriad.addChildren(node);
            }
        }
    }

    public Triad[] getTriads() {
        Collection<Triad> values = this.triads.values();
        Triad[] toArray = values.toArray(new Triad[values.size()]);
        Arrays.sort(toArray, new Comparator<Triad>(){

            @Override
            public int compare(Triad o1, Triad o2) {
                return o2.getChildren().size() - o1.getChildren().size();
            }
        });
        return toArray;
    }

    public Map<Node, Triad> getTriadsMap() {
        return Collections.unmodifiableMap(this.triads);
    }

    @Override
    public int getHeight() {
        int result = this.chain.getHeight();
        int maxHeight = 0;
        if (!this.isLeaf()) {
            Set<ChainContainer> newChildren = this.getChildren();
            for (ChainContainer child : newChildren) {
                maxHeight = Math.max(maxHeight, child.getHeight());
            }
        }
        return result + maxHeight;
    }

    @Override
    public int getWidth() {
        int width = 0;
        if (!this.isLeaf()) {
            Set<ChainContainer> newChildren = this.getChildren();
            for (ChainContainer child : newChildren) {
                width += child.getWidth();
            }
        }
        return Math.max(1, width);
    }

    @Override
    public int getSize() {
        int size = this.chain.getHeight();
        if (!this.isLeaf()) {
            Set<ChainContainer> newChildren = this.getChildren();
            for (ChainContainer chainContainer : newChildren) {
                size += chainContainer.getSize();
            }
        }
        return size;
    }
}

