/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.sequences.workers;

import fr.devinsy.util.StringList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckException;
import org.tip.puck.geo.GeoLevel;
import org.tip.puck.geo.graphs.GeoNetworkUtils;
import org.tip.puck.graphs.Graph;
import org.tip.puck.graphs.GraphComparatorByArcCount;
import org.tip.puck.graphs.GraphMaker;
import org.tip.puck.graphs.GraphProfile;
import org.tip.puck.graphs.Link;
import org.tip.puck.graphs.Node;
import org.tip.puck.graphs.workers.GraphUtils;
import org.tip.puck.net.Attributable;
import org.tip.puck.net.Gender;
import org.tip.puck.net.Individual;
import org.tip.puck.net.relations.Actor;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.net.relations.RelationEnvironment;
import org.tip.puck.net.relations.Relations;
import org.tip.puck.net.relations.workers.RelationValuator;
import org.tip.puck.net.relations.workers.RelationWorker;
import org.tip.puck.net.workers.IndividualValuator;
import org.tip.puck.net.workers.NetUtils;
import org.tip.puck.partitions.Cluster;
import org.tip.puck.partitions.Partition;
import org.tip.puck.partitions.PartitionCriteria;
import org.tip.puck.partitions.PartitionMaker;
import org.tip.puck.partitions.PartitionSequence;
import org.tip.puck.segmentation.Segmentation;
import org.tip.puck.sequences.EgoSequence;
import org.tip.puck.sequences.EgoSequences;
import org.tip.puck.sequences.Ordinal;
import org.tip.puck.sequences.Sequenceable;
import org.tip.puck.sequences.Sequenceables;
import org.tip.puck.sequences.Sequences;
import org.tip.puck.sequences.ValueSequence;
import org.tip.puck.sequences.workers.SequenceCriteria;
import org.tip.puck.sequences.workers.SequenceNetworkMaker;
import org.tip.puck.sequences.workers.SequenceNetworkStatistics;
import org.tip.puck.sequences.workers.SequenceValuator;
import org.tip.puck.util.MathUtils;
import org.tip.puck.util.Numberable;
import org.tip.puck.util.NumberedValues;
import org.tip.puck.util.PuckUtils;
import org.tip.puck.util.ToolBox;
import org.tip.puck.util.Trafo;
import org.tip.puck.util.Value;

public class SequenceStatistics<S extends Sequenceable<E>, E extends Numberable> {
    private Segmentation segmentation;
    private List<Ordinal> times;
    Sequenceables<S, E> sequences;
    private Map<String, PartitionSequence<S>> partitionSequences;
    private Map<String, PartitionSequence<E>> aggregatePartitionSequences;
    private Map<String, Sequences<ValueSequence, Value>> valueSequenceMaps;
    private Map<String, Partition<S>> sequencePartitions;
    private Map<String, Map<S, Partition<Node<Individual>>>> componentsMap;
    private Map<SequenceCriteria.ValueSequenceLabel, Partition<Link<Individual>>> linkPartitions;
    private Map<SequenceCriteria.ValueSequenceLabel, Map<Value, Double[]>> similaritiesMaps;
    private Map<String, Map<Integer, Graph<Cluster<Relation>>>> parcoursNetworksMap;
    private Map<String, Map<String, Map<String, Value>>> parcoursNetworkStatistics;
    private SequenceNetworkStatistics<S, E> relationConnectionMatrix;
    private Map<String, SequenceNetworkStatistics<S, E>> eventSequenceMatrices;
    private Map<String, SequenceNetworkStatistics<S, E>> subSequenceMatrices;
    private List<Graph> graphs;
    Map<String, StringList> pajekBuffers;
    private static final Logger logger = LoggerFactory.getLogger(SequenceStatistics.class);

    public SequenceStatistics(Segmentation segmentation, Sequenceables<S, E> sequences, SequenceCriteria criteria) throws PuckException {
        this.times = Ordinal.getOrdinals(criteria.getDates());
        this.sequences = sequences;
        this.segmentation = segmentation;
        this.pajekBuffers = new HashMap<String, StringList>();
        HashMap<Sequenceable, RelationEnvironment> egoEnvironments = new HashMap<Sequenceable, RelationEnvironment>();
        for (Sequenceable sequence : sequences) {
            if (!(sequence instanceof EgoSequence)) continue;
            if ((criteria.getValueSequenceLabels().contains((Object)SequenceCriteria.ValueSequenceLabel.MIG) || criteria.getValueSequenceLabels().contains((Object)SequenceCriteria.ValueSequenceLabel.HOSTMIG) || criteria.getValueSequenceLabels().contains((Object)SequenceCriteria.ValueSequenceLabel.MIGRATIONTYPE) || criteria.getValueSequenceLabels().contains((Object)SequenceCriteria.ValueSequenceLabel.CHILDMIGRATIONTYPE)) && !criteria.getRoleNames().contains((Object)"MIG")) {
                criteria.getRoleNames().add((Object)"MIG");
            }
            if ((criteria.getValueSequenceLabels().contains((Object)SequenceCriteria.ValueSequenceLabel.HOST) || criteria.getValueSequenceLabels().contains((Object)SequenceCriteria.ValueSequenceLabel.HOSTMIG) || criteria.getValueSequenceLabels().contains((Object)SequenceCriteria.ValueSequenceLabel.MIGRATIONTYPE) || criteria.getValueSequenceLabels().contains((Object)SequenceCriteria.ValueSequenceLabel.CHILDMIGRATIONTYPE)) && !criteria.getRoleNames().contains((Object)"HOST")) {
                criteria.getRoleNames().add((Object)"HOST");
            }
            String alterRoleName = "ALL";
            if (criteria.getSliceGeneralStatistics().contains((Object)SequenceCriteria.SliceGeneralStatistics.POSITIONS)) {
                alterRoleName = "REFERENT";
            }
            RelationEnvironment egoEnvironment = new RelationEnvironment(sequence.getStations().values(), ((EgoSequence)sequence).getEgo(), criteria.getEgoRoleName(), (List<String>)criteria.getRoleNames(), criteria.getRelationModelNames());
            egoEnvironment.setAlterRelations(sequence.getStations().values(), ((EgoSequence)sequence).getEgo(), criteria.getEgoRoleName(), alterRoleName, criteria.getRelationModelNames(), criteria.getPattern(), criteria.getChainClassification());
            egoEnvironment.setThreshold(criteria.getThreshold());
            egoEnvironments.put(sequence, egoEnvironment);
        }
        if (this.times.size() == 0) {
            this.putValueSequences(criteria, egoEnvironments);
        } else {
            this.putPartitionSequences(criteria, egoEnvironments);
        }
        this.componentsMap = new HashMap<String, Map<S, Partition<Node<Individual>>>>();
        for (String networkTitle : criteria.getNetworkTitles()) {
            if (!networkTitle.contains("Ego Network") && !networkTitle.contains("Parcours Similarity Network")) continue;
            this.componentsMap.put(networkTitle, new HashMap());
        }
        for (String label : criteria.getSequenceValueCriteriaList().getLabels()) {
            if (!label.contains("SIMILARITY")) continue;
            if (this.similaritiesMaps == null) {
                this.similaritiesMaps = new HashMap<SequenceCriteria.ValueSequenceLabel, Map<Value, Double[]>>();
                this.linkPartitions = new HashMap<SequenceCriteria.ValueSequenceLabel, Partition<Link<Individual>>>();
            }
            SequenceCriteria.ValueSequenceLabel relationClassificationType = SequenceCriteria.ValueSequenceLabel.valueOf(label.substring(label.lastIndexOf("#") + 1));
            this.similaritiesMaps.put(relationClassificationType, new HashMap());
            this.linkPartitions.put(relationClassificationType, new Partition());
        }
        this.parcoursNetworksMap = new HashMap<String, Map<Integer, Graph<Cluster<Relation>>>>();
        for (String networkTitle : criteria.getNetworkTitles()) {
            if (!networkTitle.contains("Parcours Network") || networkTitle.contains("Fused")) continue;
            this.parcoursNetworksMap.put(networkTitle, new HashMap());
        }
        this.putSequenceValues(criteria, egoEnvironments);
        logger.debug("Initialize networks for " + criteria.getNetworkTitles());
        this.makeSequenceNetworks(criteria);
        this.analyzeParcoursNetworks(criteria);
        this.getConnectedNetworkRelations(criteria);
        logger.debug("Statistics established for " + sequences);
    }

    Partition<S> getStation(Ordinal time, String indicator) {
        Partition result = this.partitionSequences.get(indicator) == null ? null : (Partition)this.partitionSequences.get(indicator).getStation(time);
        return result;
    }

    Value getValue(S sequence, String indicator) {
        Value result = this.sequencePartitions.get(indicator).getValue(sequence);
        return result;
    }

    NumberedValues getValues(String indicator) {
        NumberedValues result = new NumberedValues(this.sequencePartitions.get(indicator));
        return result;
    }

    Value getValue(S sequence, Ordinal time, String indicator) {
        Value result = null;
        if (indicator.contains("$")) {
            Value mapValue = this.partitionSequences.get(indicator.split("\\$")[0]).getValue(time, sequence);
            if (mapValue != null) {
                result = (Value)mapValue.mapValue().get(indicator.split("\\$")[1]);
            }
        } else {
            result = this.partitionSequences.get(indicator).getValue(time, sequence);
        }
        return result;
    }

    private void putSequenceValues(S sequence, SequenceCriteria sequenceCriteria, Map<String, GraphProfile<?>> networkProfiles, RelationEnvironment egoEnvironment) throws PuckException {
        GraphProfile<?> networkProfile = null;
        if (sequenceCriteria.getNetworkTitles().contains("Ego Network")) {
            networkProfile = networkProfiles.get("Nonmediated Ego Network");
        } else {
            for (String networkTitle : sequenceCriteria.getNetworkTitles()) {
                if (!networkTitle.contains("Parcours Network")) continue;
                networkProfile = networkProfiles.get(networkTitle);
                break;
            }
        }
        for (PartitionCriteria sequenceValueCriteria : sequenceCriteria.getSequenceValueCriteriaList()) {
            String label = sequenceValueCriteria.getLabel();
            String separator = "#";
            if (label.contains("ALTERS") || label.contains("RELATION")) {
                separator = "_";
            }
            String[] labels = ToolBox.splitLastPart(label, separator);
            this.sequencePartitions.get(label).put(sequence, SequenceValuator.get(sequence, labels[0], labels[1], egoEnvironment, networkProfile, this.valueSequenceMaps, this.partitionSequences));
        }
        logger.debug("Sequence values put for sequence " + sequence.getId());
    }

    private void putSequenceValues(SequenceCriteria sequenceCriteria, Map<S, RelationEnvironment> egoEnvironments) throws PuckException {
        this.sequencePartitions = new TreeMap<String, Partition<S>>();
        for (PartitionCriteria sequenceValueCriteria : sequenceCriteria.getSequenceValueCriteriaList()) {
            String label = sequenceValueCriteria.getLabel();
            Partition partition = new Partition(label);
            this.sequencePartitions.put(label, partition);
        }
        for (Sequenceable sequence : this.sequences.toSortedList()) {
            Map<String, GraphProfile<?>> networkProfiles = this.createSequenceNetworks(sequence, sequenceCriteria);
            RelationEnvironment egoEnvironment = egoEnvironments.get(sequence);
            this.putSequenceValues(sequence, sequenceCriteria, networkProfiles, egoEnvironment);
        }
    }

    private void putValueSequences(SequenceCriteria sequenceCriteria, Map<S, RelationEnvironment> egoEnvironments) throws PuckException {
        this.valueSequenceMaps = new TreeMap<String, Sequences<ValueSequence, Value>>();
        for (PartitionCriteria valueSequenceCriteria : sequenceCriteria.getValueSequenceCriteriaList()) {
            String label = valueSequenceCriteria.getLabel();
            if (this.valueSequenceMaps.get(label) == null) {
                Sequences valueSequences = new Sequences();
                this.valueSequenceMaps.put(label, valueSequences);
                for (Sequenceable sequence : this.sequences.toSortedList()) {
                    ValueSequence valueSequence = new ValueSequence(label, sequence.getId());
                    RelationEnvironment egoEnvironment = egoEnvironments.get(sequence);
                    SequenceValuator sequenceValuator = new SequenceValuator(sequence, sequenceCriteria);
                    for (Ordinal time : sequence.getTimes()) {
                        if (RelationValuator.isBirth((Attributable)sequence.getStation(time)) && !label.contains("PLACE")) continue;
                        valueSequence.put(time, sequenceValuator.getStationValue(sequence, time, this.segmentation, sequenceCriteria, valueSequenceCriteria, egoEnvironment));
                    }
                    valueSequence.setProfile();
                    valueSequences.put(valueSequence);
                }
            }
            logger.debug("Value sequences put for " + label + " " + valueSequenceCriteria);
        }
    }

    private void putPartitionSequences(SequenceCriteria sequenceCriteria, Map<S, RelationEnvironment> egoEnvironments) throws PuckException {
        this.partitionSequences = new TreeMap<String, PartitionSequence<S>>();
        this.aggregatePartitionSequences = new TreeMap<String, PartitionSequence<E>>();
        for (PartitionCriteria valueSequenceCriteria : sequenceCriteria.getValueSequenceCriteriaList()) {
            String label = valueSequenceCriteria.getLabel();
            PartitionSequence<Sequenceable> partitionSequence = new PartitionSequence<Sequenceable>(label, this.times);
            this.partitionSequences.put(label, partitionSequence);
            for (Sequenceable sequence : this.sequences.toSortedList()) {
                SequenceValuator sequenceValuator = new SequenceValuator(sequence, sequenceCriteria);
                RelationEnvironment egoEnvironment = egoEnvironments.get(sequence);
                for (Ordinal time : this.times) {
                    partitionSequence.put(time, sequence, sequenceValuator.getStationValue(sequence, time, this.segmentation, sequenceCriteria, valueSequenceCriteria, egoEnvironment));
                }
            }
            if (partitionSequence.isMulti()) {
                this.aggregatePartitionSequences.put(label, partitionSequence.aggregate(new PartitionCriteria(valueSequenceCriteria.getLabel())));
            }
            logger.debug("Partition sequences put for " + label + " " + valueSequenceCriteria);
        }
    }

    private Map<String, GraphProfile<?>> createSequenceNetworks(S sequence, SequenceCriteria criteria) throws PuckException {
        HashMap<String, GraphProfile<?>> result = null;
        if (!criteria.getNetworkTitles().isEmpty()) {
            SequenceCriteria.ValueSequenceLabel relationClassificationType;
            result = SequenceNetworkMaker.createNetworkProfiles(sequence, criteria);
            for (String label : criteria.getSequenceValueCriteriaList().getLabels()) {
                if (!label.contains("SIMILARITY")) continue;
                relationClassificationType = SequenceCriteria.ValueSequenceLabel.valueOf(label.substring(label.lastIndexOf("_") + 1));
                GraphProfile parcoursNetworkProfile = (GraphProfile)result.get("Parcours Intersection Network_" + (Object)((Object)relationClassificationType));
                Partition<Link<Object>> linkPartition = parcoursNetworkProfile.getLinkPartition();
                if (linkPartition == null) {
                    linkPartition = GraphUtils.getLinkPartitionByKinship(parcoursNetworkProfile.getGraph());
                    parcoursNetworkProfile.setLinkPartition(linkPartition);
                }
                this.linkPartitions.get((Object)relationClassificationType).add(linkPartition);
            }
            for (String networkTitle : criteria.getNetworkTitles()) {
                Graph network;
                GraphProfile networkProfile;
                GraphProfile parcoursNetworkProfile;
                if (networkTitle.contains("Ego Network")) {
                    this.componentsMap.get(networkTitle).put(sequence, ((GraphProfile)result.get("Nonmediated Ego Network")).getNonEgoComponents());
                } else if (networkTitle.contains("Parcours Similarity Network")) {
                    relationClassificationType = SequenceCriteria.ValueSequenceLabel.valueOf(networkTitle.substring(networkTitle.lastIndexOf("#") + 1));
                    this.componentsMap.get(networkTitle).put(sequence, ((GraphProfile)result.get("Parcours Similarity Network_" + (Object)((Object)relationClassificationType))).getNonEgoComponents());
                }
                if (networkTitle.contains("Parcours Network") && !networkTitle.contains("Fused") && (parcoursNetworkProfile = (GraphProfile)result.get(networkTitle)) != null) {
                    this.parcoursNetworksMap.get(networkTitle).put(((EgoSequence)sequence).getEgo().getId(), parcoursNetworkProfile.getGraph());
                }
                if (networkTitle.equals("Event Type Network") || networkTitle.equals("Sequence Type Network") || (networkProfile = (GraphProfile)result.get(networkTitle)) == null || (network = networkProfile.getGraph()).nodeCount() <= 0) continue;
                if (!this.pajekBuffers.containsKey(networkTitle)) {
                    this.pajekBuffers.put(networkTitle, new StringList());
                }
                this.pajekBuffers.get(networkTitle).addAll((Collection)PuckUtils.writePajekNetwork(network, networkProfile.getPartitionLabels()));
            }
        }
        return result;
    }

    String getTrend(S sequence, String indicator) {
        String result = null;
        Value lastValue = null;
        for (Ordinal time : this.times) {
            Value value = this.getValue(sequence, time, indicator);
            if (lastValue != null && value != null) {
                if (lastValue.isNotNumber() || value.isNotNumber()) break;
                int comp = value.compareTo(lastValue);
                String trend = null;
                if (comp < 0) {
                    trend = "DECLINING";
                } else if (comp > 0) {
                    trend = "AUGMENTING";
                } else if (comp == 0) {
                    trend = "CONSTANT";
                }
                if (result == null || result.equals("CONSTANT")) {
                    result = trend;
                } else if (!trend.equals("CONSTANT") && !trend.equals(result)) {
                    result = "VARIABLE";
                    break;
                }
            }
            lastValue = value;
        }
        return result;
    }

    String getMeanTrend(String indicator) {
        String result = "";
        HashMap<String, Double> trendCounts = new HashMap<String, Double>();
        for (Sequenceable sequence : this.sequences) {
            String trend = this.getTrend(sequence, indicator);
            Double count = (Double)trendCounts.get(trend);
            if (count == null) {
                trendCounts.put(trend, 1.0);
                continue;
            }
            trendCounts.put(trend, count + 1.0);
        }
        for (String trend : trendCounts.keySet()) {
            trendCounts.put(trend, MathUtils.percent((Double)trendCounts.get(trend), new Double(this.sequences.size())));
        }
        ArrayList sortedEntries = new ArrayList(trendCounts.entrySet());
        Collections.sort(sortedEntries, new Comparator<Map.Entry<String, Double>>(){

            @Override
            public int compare(Map.Entry<String, Double> e1, Map.Entry<String, Double> e2) {
                return e2.getValue().compareTo(e1.getValue());
            }
        });
        for (Map.Entry entry : sortedEntries) {
            result = String.valueOf(result) + (String)entry.getKey() + " " + entry.getValue() + " ";
        }
        return result;
    }

    PartitionSequence<E> getAggregatePartitionSequence(String label) {
        PartitionSequence<E> result = this.aggregatePartitionSequences.get(label);
        return result;
    }

    PartitionSequence<S> getPartitionSequence(String label) {
        PartitionSequence<S> result = this.partitionSequences.get(label);
        return result;
    }

    Map<String, PartitionSequence<Individual>> getMigrations(SequenceCriteria sequenceCriteria, PartitionCriteria partitionCriteria) {
        TreeMap<String, PartitionSequence<Individual>> result = new TreeMap<String, PartitionSequence<Individual>>();
        ArrayList<Ordinal> changes = new ArrayList<Ordinal>();
        int i = 0;
        while (i < this.times.size() - 1) {
            changes.add(new Ordinal(this.times.get(i) + "-" + this.times.get(i + 1), null, null));
            ++i;
        }
        result.put("MIGRATIONS", new PartitionSequence("Migrations", changes));
        result.put("DESTINATIONS", new PartitionSequence("Destination", changes));
        result.put("ORIGINS", new PartitionSequence("Origins", changes));
        i = 0;
        while (i < this.times.size() - 1) {
            Ordinal change = (Ordinal)changes.get(i);
            Ordinal startTime = this.times.get(i);
            Ordinal endTime = this.times.get(i + 1);
            Relations filteredStartSpace = new Relations(this.sequences.getStations(startTime));
            Relations filteredEndSpace = new Relations(this.sequences.getStations(endTime));
            Relations totalStartSpace = this.segmentation.getAllRelations().getByTime(sequenceCriteria.getDateLabel(), startTime.getYear());
            Relations totalEndSpace = this.segmentation.getAllRelations().getByTime(sequenceCriteria.getDateLabel(), endTime.getYear());
            Partition<Individual> migrations = new Partition<Individual>("Migrations " + startTime + "/" + endTime);
            ((PartitionSequence)result.get("MIGRATIONS")).put(change, migrations);
            Partition<Individual> destinations = new Partition<Individual>("Destinations " + startTime + "/" + endTime);
            ((PartitionSequence)result.get("DESTINATIONS")).put(change, destinations);
            Partition<Individual> origins = new Partition<Individual>("Origins " + startTime + "/" + endTime);
            ((PartitionSequence)result.get("ORIGINS")).put(change, origins);
            for (Individual individual : filteredStartSpace.getIndividuals().toSortedList()) {
                String endUnit;
                if (IndividualValuator.lifeStatusAtYear(individual, endTime.getYear()).equals("DEAD")) {
                    migrations.put(individual, new Value("DIED"));
                    continue;
                }
                if (totalEndSpace.getByIndividual(individual).isEmpty()) {
                    migrations.put(individual, new Value("UNKNOWN DESTINATION"));
                    continue;
                }
                if (filteredEndSpace.getByIndividual(individual).isEmpty()) {
                    migrations.put(individual, new Value("LEFT"));
                    for (Relation destination : totalEndSpace.getByIndividual(individual)) {
                        destinations.put(individual, RelationValuator.get(destination, partitionCriteria.getLabel(), (Object)partitionCriteria.getLabelParameter()));
                    }
                    continue;
                }
                Relation start = (Relation)filteredStartSpace.getByIndividual(individual).getFirst();
                Relation end = (Relation)filteredEndSpace.getByIndividual(individual).getFirst();
                String startUnit = start.getAttributeValue(sequenceCriteria.getLocalUnitLabel());
                if (startUnit == null) {
                    startUnit = start.getAttributeValue(sequenceCriteria.getPlaceLabel());
                }
                if ((endUnit = end.getAttributeValue(sequenceCriteria.getLocalUnitLabel())) == null) {
                    endUnit = start.getAttributeValue(sequenceCriteria.getPlaceLabel());
                }
                if (!startUnit.equals(endUnit)) {
                    migrations.put(individual, new Value("INTERNAL CHANGE"));
                    continue;
                }
                migrations.put(individual, new Value("UNCHANGED"));
            }
            for (Individual individual : filteredEndSpace.getIndividuals().toSortedList()) {
                if (IndividualValuator.lifeStatusAtYear(individual, startTime.getYear()).equals("UNBORN")) {
                    migrations.put(individual, new Value("NEWBORN"));
                    continue;
                }
                if (totalStartSpace.getByIndividual(individual).isEmpty()) {
                    migrations.put(individual, new Value("UNKNOWN ORIGIN"));
                    continue;
                }
                if (!filteredStartSpace.getByIndividual(individual).isEmpty()) continue;
                migrations.put(individual, new Value("ENTERED"));
                for (Relation origin : totalStartSpace.getByIndividual(individual)) {
                    origins.put(individual, RelationValuator.get(origin, partitionCriteria.getLabel(), (Object)partitionCriteria.getLabelParameter()));
                }
            }
            ++i;
        }
        return result;
    }

    private Map<E, E> adjacentStations(String direction) {
        HashMap<Numberable, Numberable> result = new HashMap<Numberable, Numberable>();
        Ordinal former = null;
        for (Ordinal later : this.times) {
            if (former != null) {
                Ordinal current = null;
                if (direction.equals("OUT")) {
                    current = former;
                } else if (direction.equals("IN")) {
                    current = later;
                }
                for (Sequenceable sequence : this.sequences) {
                    Numberable currentRelation = (Numberable)sequence.getStation(current);
                    if (currentRelation == null) continue;
                    if (direction.equals("OUT")) {
                        result.put(currentRelation, (Numberable)sequence.getStation(later));
                        continue;
                    }
                    if (!direction.equals("IN")) continue;
                    result.put(currentRelation, (Numberable)sequence.getStation(former));
                }
            }
            former = later;
        }
        return result;
    }

    Partition<String> getFlows(String direction, SequenceCriteria sequenceCriteria) {
        Partition<String> result = new Partition<String>();
        int[] maxDegrees = ToolBox.stringsToInts(sequenceCriteria.getPattern());
        Map<E, E> adjacentStations = this.adjacentStations(direction);
        for (Relation currentRelation : adjacentStations.keySet()) {
            Relation otherRelation = (Relation)adjacentStations.get(currentRelation);
            for (Actor actor : currentRelation.getDifferentwActors(otherRelation)) {
                Individual referent = actor.getReferent();
                String link = "UNKNOWN";
                if (referent != null) {
                    link = NetUtils.getAlterRole(actor.getIndividual(), referent, maxDegrees, null);
                }
                Individual otherReferent = null;
                Actor otherActor = RelationWorker.getClosestHomologue(currentRelation, actor, sequenceCriteria.getDateLabel(), direction);
                if (otherActor != null) {
                    otherReferent = otherActor.getReferent();
                }
                String otherLink = "UNKNOWN";
                if (otherReferent != null) {
                    otherLink = NetUtils.getAlterRole(actor.getIndividual(), otherReferent, maxDegrees, null);
                }
                String change = null;
                if (referent != null && referent.equals(otherReferent)) {
                    change = "IDENTICAL";
                } else if (direction.equals("OUT")) {
                    change = String.valueOf(link) + ">" + otherLink;
                } else if (direction.equals("IN")) {
                    change = String.valueOf(otherLink) + ">" + link;
                }
                result.put(currentRelation + "\t" + currentRelation.getTime(sequenceCriteria.getDateLabel()) + "\t" + direction + "\t" + actor.getIndividual() + "\t" + referent + "\t" + otherReferent, new Value(change));
            }
        }
        return result;
    }

    Map<String, StringList> getPajekBuffers() {
        return this.pajekBuffers;
    }

    public Partition<S> getSequencePartition(String label) {
        Partition<S> result = this.sequencePartitions == null ? null : this.sequencePartitions.get(label);
        return result;
    }

    public Map<Value, Double[]> getMeanNrMoves() {
        TreeMap<Value, Double[]> result = new TreeMap<Value, Double[]>();
        HashMap<GeoLevel, Integer[]> sequenceMap = new HashMap<GeoLevel, Integer[]>();
        HashMap<GeoLevel, Integer[]> eventMap = new HashMap<GeoLevel, Integer[]>();
        GeoLevel[] geoLevelArray = new GeoLevel[]{GeoLevel.TRANSNATIONAL, GeoLevel.TRANSREGIONAL, GeoLevel.REGIONAL, GeoLevel.LOCAL};
        int n = geoLevelArray.length;
        int n2 = 0;
        while (n2 < n) {
            GeoLevel level = geoLevelArray[n2];
            sequenceMap.put(level, new Integer[]{0, 0, 0});
            eventMap.put(level, new Integer[]{0, 0, 0});
            result.put(new Value(level), new Double[]{0.0, 0.0, 0.0});
            ++n2;
        }
        for (Sequenceable sequence : this.sequences) {
            int gender = ((EgoSequence)sequence).getEgo().getGender().toInt();
            Value value = this.getValue(sequence, "MEAN_NR_MOVES");
            if (value == null) continue;
            Map distanceProfile = value.mapValue();
            for (GeoLevel level : distanceProfile.keySet()) {
                if (sequenceMap.get((Object)level) == null) continue;
                Integer[] integerArray = (Integer[])sequenceMap.get((Object)level);
                int n3 = gender;
                integerArray[n3] = integerArray[n3] + 1;
                Integer[] integerArray2 = (Integer[])sequenceMap.get((Object)level);
                integerArray2[2] = integerArray2[2] + 1;
                Integer[] integerArray3 = (Integer[])eventMap.get((Object)level);
                int n4 = gender;
                integerArray3[n4] = integerArray3[n4] + (Integer)distanceProfile.get((Object)level);
                Integer[] integerArray4 = (Integer[])sequenceMap.get((Object)level);
                integerArray4[2] = integerArray4[2] + (Integer)distanceProfile.get((Object)level);
            }
        }
        for (Value value : result.keySet()) {
            int i = 0;
            while (i < 3) {
                ((Double[])result.get((Object)value))[i] = new Double(((Integer[])eventMap.get(value.enumValue()))[i].intValue()) / new Double(((Integer[])sequenceMap.get(value.enumValue()))[i].intValue());
                ++i;
            }
        }
        return result;
    }

    Map<S, Partition<Node<Individual>>> getComponents(String networkTitle) {
        return this.componentsMap.get(networkTitle);
    }

    SequenceNetworkStatistics<S, E> getEventSequenceMatrix(String eventTypeName) {
        SequenceNetworkStatistics<S, E> result = this.eventSequenceMatrices == null || eventTypeName == null ? null : this.eventSequenceMatrices.get(eventTypeName);
        return result;
    }

    SequenceNetworkStatistics<S, E> getSubSequenceMatrix(String eventTypeName) {
        SequenceNetworkStatistics<S, E> result = this.subSequenceMatrices == null || eventTypeName == null ? null : this.subSequenceMatrices.get(eventTypeName);
        return result;
    }

    List<String> getSequenceNetworkLabels() {
        ArrayList<String> result = this.eventSequenceMatrices != null ? new ArrayList<String>(this.eventSequenceMatrices.keySet()) : new ArrayList<String>();
        return result;
    }

    List<String> getSequenceTreeLabels() {
        ArrayList<String> result = this.subSequenceMatrices != null ? new ArrayList<String>(this.subSequenceMatrices.keySet()) : new ArrayList<String>();
        return result;
    }

    private void makeSequenceNetwork(String networkTitle, SequenceCriteria.ValueSequenceLabel relationClassificationType) {
        String eventTypeName = relationClassificationType.toString();
        TreeMap<Sequenceable, List<String>> singles = new TreeMap<Sequenceable, List<String>>();
        TreeMap pairs = new TreeMap();
        for (Sequenceable sequence : this.sequences) {
            Value singlesValue = this.getValue(sequence, "PROFILE#" + eventTypeName);
            if (singlesValue == null) continue;
            String valueString = singlesValue.stringValue();
            List<String> singlesList = null;
            if (networkTitle.contains("Event Type Network")) {
                singlesList = Arrays.asList(valueString.split(";"));
            } else if (networkTitle.contains("Sequence Type Network")) {
                singlesList = PuckUtils.cumulateList(Arrays.asList(valueString.split(";")));
            }
            ArrayList<String[]> pairsList = new ArrayList<String[]>();
            int i = 1;
            while (i < singlesList.size()) {
                pairsList.add(new String[]{singlesList.get(i - 1), singlesList.get(i)});
                ++i;
            }
            singles.put(sequence, singlesList);
            pairs.put(sequence, pairsList);
        }
        if (networkTitle.contains("Event Type Network")) {
            this.eventSequenceMatrices.put(eventTypeName, new SequenceNetworkStatistics("Event Type Network", eventTypeName, singles, pairs));
        } else if (networkTitle.contains("Sequence Type Network")) {
            this.subSequenceMatrices.put(eventTypeName, new SequenceNetworkStatistics("Sequence Type Network", eventTypeName, singles, pairs));
        }
    }

    private void makeSequenceNetworks(SequenceCriteria criteria) throws PuckException {
        this.eventSequenceMatrices = new HashMap<String, SequenceNetworkStatistics<S, E>>();
        this.subSequenceMatrices = new HashMap<String, SequenceNetworkStatistics<S, E>>();
        this.graphs = new ArrayList<Graph>();
        for (SequenceCriteria.ValueSequenceLabel relationClassificationType : criteria.getTrajectoriesRelationClassificationTypes()) {
            Gender gender;
            int n;
            int n2;
            Gender[] genderArray;
            StringList pajekBuffer;
            Map<String, Map<Value, Integer>> partitionNumbersMaps;
            ArrayList<String> partitionLabels;
            SequenceNetworkStatistics<S, E> matrix;
            if (criteria.getNetworkTitles().contains("Event Type Network")) {
                this.makeSequenceNetwork("Event Type Network " + (Object)((Object)relationClassificationType), relationClassificationType);
                matrix = this.eventSequenceMatrices.get(relationClassificationType.toString());
                Graph<Cluster<String>>[] eventTypeNetworks = matrix.getSequenceNetworks();
                partitionLabels = new ArrayList<String>();
                partitionLabels.add(relationClassificationType.toString());
                partitionNumbersMaps = GraphMaker.getPartitionNumbersMaps(partitionLabels, eventTypeNetworks[2]);
                partitionLabels.add("SIZE");
                pajekBuffer = new StringList();
                this.pajekBuffers.put("Event Type Network", pajekBuffer);
                genderArray = Gender.values();
                n2 = genderArray.length;
                n = 0;
                while (n < n2) {
                    gender = genderArray[n];
                    pajekBuffer.addAll((Collection)PuckUtils.writePajekNetwork(eventTypeNetworks[gender.toInt()], partitionLabels, partitionNumbersMaps));
                    ++n;
                }
                if (criteria.getTrajectoriesOperations().contains((Object)SequenceCriteria.TrajectoriesOperation.DRAW)) {
                    Graph<String> placeNameGraph = GeoNetworkUtils.createGeoNetwork2(eventTypeNetworks[2], criteria.getLevel());
                    this.graphs.add(placeNameGraph);
                }
            }
            if (!criteria.getNetworkTitles().contains("Sequence Type Network")) continue;
            this.makeSequenceNetwork("Sequence Type Network " + (Object)((Object)relationClassificationType), relationClassificationType);
            matrix = this.subSequenceMatrices.get(relationClassificationType.toString());
            Graph<Cluster<String>>[] sequenceTypeNetworks = matrix.getSequenceNetworks();
            matrix.getDepthPartitions();
            partitionLabels = new ArrayList();
            partitionLabels.add(relationClassificationType.toString());
            partitionNumbersMaps = GraphMaker.getPartitionNumbersMaps(partitionLabels, sequenceTypeNetworks[2]);
            partitionLabels.add("SIZE");
            partitionLabels.add("STEP");
            pajekBuffer = new StringList();
            this.pajekBuffers.put("Sequence Type Network", pajekBuffer);
            genderArray = Gender.values();
            n2 = genderArray.length;
            n = 0;
            while (n < n2) {
                gender = genderArray[n];
                pajekBuffer.addAll((Collection)PuckUtils.writePajekNetwork(sequenceTypeNetworks[gender.toInt()], partitionLabels, partitionNumbersMaps));
                ++n;
            }
        }
    }

    private void createSimilarityTrees(String networkTitle) throws PuckException {
        Map<Integer, Graph<Cluster<Relation>>> parcoursNetworks = this.parcoursNetworksMap.get(networkTitle);
        ArrayList<Graph<Graph<String>>> flatParcoursNetworksNoLoops = new ArrayList<Graph<Graph<String>>>();
        for (Graph<Cluster<Relation>> parcoursNetwork : parcoursNetworks.values()) {
            Graph<String> flatParcoursNetworkNoLoops = SequenceNetworkMaker.getFlatParcoursNetworkNoLoops(parcoursNetwork);
            flatParcoursNetworksNoLoops.add(flatParcoursNetworkNoLoops);
        }
        Collections.sort(flatParcoursNetworksNoLoops, new GraphComparatorByArcCount());
        Graph tree = GraphUtils.createPhylogeneticTree(flatParcoursNetworksNoLoops);
        tree.setLabel(String.valueOf(networkTitle) + "_Tree");
        for (Node node : tree.getNodes()) {
            node.setLabel(node.getLabel().replaceAll(String.valueOf(networkTitle) + " ", ""));
            if (((Set)node.getReferent()).size() == 1) {
                node.setAttribute("TYPE", "1");
                String[] splitLabel = Trafo.noParentheses(((Set)node.getReferent()).toString()).split(" ");
                Integer egoId = Integer.parseInt(splitLabel[splitLabel.length - 1]);
                node.setAttribute("GENDER", ((EgoSequences)this.sequences).getByEgoId(egoId).getEgo().getGender().toString());
                continue;
            }
            node.setAttribute("TYPE", "0");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("TYPE");
        arrayList.add("GENDER");
        String bufferTitle = networkTitle.replaceAll("Network", "Similarity Tree");
        StringList pajekBuffer = this.pajekBuffers.get(bufferTitle);
        if (pajekBuffer == null) {
            pajekBuffer = new StringList();
            this.pajekBuffers.put(bufferTitle, pajekBuffer);
        }
        pajekBuffer.addAll((Collection)PuckUtils.writePajekNetwork(tree, arrayList));
    }

    private void createUnionGraphs(String networkTitle, String partitionLabel, List<String> nodeStatisticsLabels) throws PuckException {
        Map<Integer, Graph<Cluster<Relation>>> parcoursNetworks = this.parcoursNetworksMap.get(networkTitle);
        this.parcoursNetworkStatistics = new TreeMap<String, Map<String, Map<String, Value>>>();
        ArrayList unions = new ArrayList();
        PartitionCriteria partitionCriteria = new PartitionCriteria(partitionLabel);
        Partition<Individual> individualPartition = PartitionMaker.create("", ((EgoSequences)this.sequences).getEgos(), partitionCriteria);
        Partition<Graph<Cluster<Relation>>> graphPartition = new Partition<Graph<Cluster<Relation>>>();
        for (Individual individual : individualPartition.getItems()) {
            graphPartition.put(parcoursNetworks.get(individual.getId()), individualPartition.getValue(individual));
        }
        for (Cluster cluster : graphPartition.getClusters()) {
            Graph graph = GraphUtils.fuseGraphs(cluster.getItems());
            graph.setLabel(String.valueOf(networkTitle) + "_" + cluster.getValue());
            unions.add(graph);
            this.parcoursNetworkStatistics.put("" + cluster.getValue(), GraphUtils.getNodeStatisticsByLabel(graph, nodeStatisticsLabels));
        }
        Graph graph = GraphUtils.fuseGraphs(new ArrayList(parcoursNetworks.values()));
        graph.setLabel(String.valueOf(networkTitle) + "_Total");
        this.parcoursNetworkStatistics.put("Total", GraphUtils.getNodeStatisticsByLabel(graph, nodeStatisticsLabels));
        unions.add(graph);
        ArrayList<String> unionPartitionLabels = new ArrayList<String>();
        unionPartitionLabels.add("NUMBER");
        unionPartitionLabels.add("SIZE");
        unionPartitionLabels.add("BETWEENNESS");
        unionPartitionLabels.add("DEGREE");
        for (Graph graph2 : unions) {
            String bufferTitle = networkTitle.replaceAll("Network", "Network Fused");
            StringList pajekBuffer = this.pajekBuffers.get(bufferTitle);
            if (pajekBuffer == null) {
                pajekBuffer = new StringList();
                this.pajekBuffers.put(bufferTitle, pajekBuffer);
            }
            pajekBuffer.addAll((Collection)PuckUtils.writePajekNetwork(graph2, unionPartitionLabels));
        }
    }

    private void analyzeParcoursNetworks(SequenceCriteria criteria) throws PuckException {
        for (String networkTitle : criteria.getNetworkTitles()) {
            if (!networkTitle.contains("Parcours Network") || networkTitle.contains("Fused")) continue;
            this.createSimilarityTrees(networkTitle);
            this.createUnionGraphs(networkTitle, criteria.getPartitionLabel(), criteria.getNodeStatisticsLabels());
        }
    }

    private void getConnectedNetworkRelations(SequenceCriteria criteria) throws PuckException {
        if (criteria.getSequenceValueCriteriaList().getLabels().contains("CONNECTED_NETWORK_RELATIONS")) {
            TreeMap<Individual, List> singles = new TreeMap<Individual, List>();
            TreeMap<Individual, List> pairs = new TreeMap<Individual, List>();
            for (Sequenceable sequence : this.sequences) {
                Value pairsValue;
                Individual ego = ((EgoSequence)sequence).getEgo();
                Value singlesValue = this.getValue(sequence, "NETWORK_RELATIONS");
                if (singlesValue != null) {
                    singles.put(ego, singlesValue.listValue());
                }
                if ((pairsValue = this.getValue(sequence, "CONNECTED_NETWORK_RELATIONS")) == null) continue;
                pairs.put(ego, pairsValue.listValue());
            }
            this.relationConnectionMatrix = new SequenceNetworkStatistics("Component connections", null, singles, pairs);
        }
    }

    public ValueSequence getValueSequence(String label, S sequence) throws PuckException {
        ValueSequence result = this.times.size() == 0 ? (ValueSequence)this.valueSequenceMaps.get(label).getById(sequence.getId()) : this.partitionSequences.get(label).getValueSequence(sequence);
        return result;
    }

    public Graph<Cluster<String>> getSequenceNetwork(String title, SequenceCriteria.ValueSequenceLabel relationClassificationType, Partition<String> partition) {
        if (this.sequences == null) {
            throw new IllegalArgumentException("Null parameter detected.");
        }
        Graph<Cluster<String>> result = new Graph<Cluster<String>>(String.valueOf(title) + "_" + (Object)((Object)relationClassificationType));
        for (Cluster<String> cluster : partition.getClusters().toListSortedByDescendingSize()) {
            if (cluster.isNull()) continue;
            result.addNode(cluster);
        }
        for (Sequenceable sequenceable : this.sequences) {
            Cluster<String> previous = null;
            for (Relation event : ((EgoSequence)sequenceable).getStations().values()) {
                Cluster<String> next = partition.getCluster(String.valueOf(((EgoSequence)sequenceable).getEgo().getId()) + " " + event.getTypedId());
                if (previous != null) {
                    result.incArcWeight(previous, next);
                }
                previous = next;
            }
        }
        for (Node node : result.getNodes()) {
            Value clusterValue;
            Cluster referent = (Cluster)node.getReferent();
            if (referent == null || (clusterValue = referent.getValue()) == null) continue;
            String value = clusterValue.toString();
            if (value.lastIndexOf("-") > -1) {
                value = value.substring(value.lastIndexOf("-") + 1);
            }
            node.setAttribute(relationClassificationType.toString(), value);
        }
        return result;
    }

    SequenceNetworkStatistics<S, E> getRelationConnectionMatrix() {
        return this.relationConnectionMatrix;
    }

    Map<Value, Double[]> getSimilaritiesMap(SequenceCriteria.ValueSequenceLabel relationClassificationType) {
        return this.similaritiesMaps.get((Object)relationClassificationType);
    }

    public Map<String, Map<String, Map<String, Value>>> getParcoursNetworkStatistics() {
        return this.parcoursNetworkStatistics;
    }

    public List<Graph> getGraphs() {
        return this.graphs;
    }
}

