/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.partitions;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.util.MathUtils;

public class Interval
implements Comparable<Interval> {
    private static final Logger logger = LoggerFactory.getLogger(Interval.class);
    private double min;
    private boolean minIncluded;
    private double max;
    private boolean maxIncluded;

    public Interval(Double min, EndpointStatus minStatus, Double max, EndpointStatus maxStatus) {
        this.minIncluded = minStatus == EndpointStatus.INCLUDED;
        this.maxIncluded = maxStatus == EndpointStatus.INCLUDED;
        this.min = min == null ? Double.MIN_VALUE : min;
        this.max = max == null ? Double.MIN_VALUE : max;
    }

    @Override
    public int compareTo(Interval source) {
        int result = source == null ? 1 : (this.min == source.getMin() ? (!this.minIncluded && source.isMinIncluded() ? 1 : (this.minIncluded && !source.isMinIncluded() ? -1 : 0)) : (this.min < source.getMin() ? -1 : 1));
        return result;
    }

    public double getMax() {
        return this.max;
    }

    public double getMin() {
        return this.min;
    }

    public boolean isMaxIncluded() {
        return this.maxIncluded;
    }

    public boolean isMinIncluded() {
        return this.minIncluded;
    }

    public boolean matches(double value) {
        boolean result = value > this.min && value < this.max ? true : (value == this.min && this.minIncluded ? true : value == this.max && this.maxIncluded);
        return result;
    }

    public boolean matches(Double value) {
        boolean result = value == null ? false : this.matches((double)value);
        return result;
    }

    public String toString() {
        char minBoard = this.minIncluded ? (char)'[' : ']';
        char maxBoard = this.maxIncluded ? (char)']' : '[';
        String targetMin = MathUtils.toString(this.min);
        String targetMax = MathUtils.toString(this.max);
        String result = String.format("%c%s,%s%c", Character.valueOf(minBoard), targetMin, targetMax, Character.valueOf(maxBoard));
        return result;
    }

    public static enum EndpointStatus {
        INCLUDED,
        EXCLUDED;

    }
}

