/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net;

import java.util.Comparator;
import org.tip.puck.net.Family;
import org.tip.puck.net.Individual;
import org.tip.puck.util.MathUtils;

public class FamilyOrderComparator
implements Comparator<Family> {
    private Individual referent;

    public FamilyOrderComparator(Individual referent) {
        if (referent == null) {
            throw new IllegalArgumentException("referent is null.");
        }
        this.referent = referent;
    }

    @Override
    public int compare(Family alpha, Family bravo) {
        int result = FamilyOrderComparator.compare(alpha, bravo, this.referent);
        return result;
    }

    public static int compare(Family alpha, Family bravo, Individual referent) {
        Integer alphaValue = alpha == null ? null : alpha.getUnionOrder(referent);
        Integer bravoValue = bravo == null ? null : bravo.getUnionOrder(referent);
        int result = MathUtils.compareOrder(alphaValue, bravoValue);
        return result;
    }
}

