/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.io.deluz;

import cern.colt.Arrays;
import fr.devinsy.util.StringList;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.tip.puck.PuckException;
import org.tip.puck.PuckExceptions;
import org.tip.puck.PuckManager;
import org.tip.puck.net.Gender;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Individuals;
import org.tip.puck.net.Net;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.net.relations.RelationModel;
import org.tip.puck.net.relations.Role;
import org.tip.puck.net.workers.NetUtils;
import org.tip.puck.report.Report;

public class DELUZFile {
    private static String getLabel(char letter) {
        String result;
        switch (letter) {
            case 'a': {
                result = "TRIBE";
                break;
            }
            case 'b': {
                result = "VILLAGE";
                break;
            }
            case 'c': {
                result = "QUARTER";
                break;
            }
            case 'd': {
                result = "SEGMENT";
                break;
            }
            case 'e': {
                result = "GENEALOGY";
                break;
            }
            case 'f': {
                result = "PROHIBITIONS";
                break;
            }
            case 'g': {
                result = "NAMES";
                break;
            }
            case 'h': {
                result = "MOTTO";
                break;
            }
            case 'i': {
                result = "CULTS";
                break;
            }
            case 'k': {
                result = "NOTE";
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }

    private static void read(Relation relation, BufferedReader in) throws PuckException {
        Integer id = null;
        String value = null;
        char labelLetter = 'x';
        try {
            boolean ended = false;
            while (!ended) {
                String line = in.readLine();
                if (line == null) {
                    ended = true;
                    continue;
                }
                if (!StringUtils.isNotBlank((CharSequence)line)) continue;
                if (id == null) {
                    id = Integer.parseInt(line.trim());
                    relation.setId(id);
                    relation.setTypedId(id);
                    continue;
                }
                if (line.length() > 1 && line.charAt(1) == ')') {
                    String label = DELUZFile.getLabel(labelLetter);
                    if (label != null && StringUtils.isNotEmpty(value)) {
                        relation.setAttribute(label, value.trim());
                    }
                    labelLetter = line.charAt(0);
                    value = line.substring(2);
                    continue;
                }
                value = labelLetter == 'e' ? String.valueOf(value) + line + "\n" : String.valueOf(value) + line + " / ";
            }
        }
        catch (IOException exception) {
            exception.printStackTrace();
            throw PuckExceptions.IO_ERROR.create(exception, "Reading line.", new Object[0]);
        }
        relation.setName(String.valueOf(relation.getAttributeValue("TRIBE")) + " " + relation.getAttributeValue("VILLAGE") + " " + relation.getAttributeValue("QUARTER") + " " + relation.getAttributeValue("SEGMENT") + " ");
    }

    private static void getGenealogy(Net net, Role defaultRole, Report report, StringList errors) {
        for (Relation relation : net.relations()) {
            String genealogy = relation.getAttributeValue("GENEALOGY");
            if (genealogy == null) continue;
            String indis = DELUZFile.addGenealogy(net, relation, genealogy, defaultRole, errors);
            relation.setAttribute("GENEALOGY", indis);
        }
    }

    private static String trim(String item) {
        String result = item.replaceAll("= ", "=");
        while (result.contains("=-")) {
            result = result.replaceAll("=-", "=");
        }
        return result;
    }

    private static String addGenealogy(Net net, Relation relation, String genealogy, Role defaultRole, StringList errors) {
        Individuals individuals = new Individuals();
        String result = "";
        String[] generations = genealogy.split("\\n");
        int row = 0;
        String[] stringArray = generations;
        int n = generations.length;
        int n2 = 0;
        while (n2 < n) {
            String generation = stringArray[n2];
            Object[] coupleStrings = DELUZFile.trim(generation).replaceAll("-", "\n").split("\\n");
            result = String.valueOf(result) + row + ": " + Arrays.toString((Object[])coupleStrings) + ";";
            Object[] objectArray = coupleStrings;
            int n3 = coupleStrings.length;
            int n4 = 0;
            while (n4 < n3) {
                Object coupleString = objectArray[n4];
                String[] indiStrings = ((String)coupleString).replaceAll("=,", "=").split("=");
                Individuals couple = new Individuals();
                String[] stringArray2 = indiStrings;
                int n5 = indiStrings.length;
                int n6 = 0;
                while (n6 < n5) {
                    String indiString = stringArray2[n6];
                    if (!StringUtils.isEmpty((CharSequence)indiString.trim()) && !StringUtils.isEmpty((CharSequence)indiString.replaceAll("-", "").trim())) {
                        Individual individual = DELUZFile.getIndividual(net, indiString, row);
                        individual.setAttribute(relation.getModel().getName(), String.valueOf(relation.getId()));
                        relation.addActor(individual, defaultRole);
                        individuals.add(individual);
                        couple.add(individual);
                    }
                    ++n6;
                }
                if (couple.size() > 1) {
                    NetUtils.setKinSpouse(net, (Individual)couple.getFirst(), (Individual)couple.getLast());
                } else if (((String)coupleString).contains("=")) {
                    errors.appendln("Segment " + relation.getId() + ":\tCut-off marriage partner for " + couple.getFirst() + ":\tLine " + generation);
                }
                ++n4;
            }
            ++row;
            ++n2;
        }
        for (Individual child : individuals) {
            String parentName = child.getAttributeValue("PARENT");
            int parentRow = Integer.parseInt(child.getAttributeValue("ROW")) - 1;
            if (parentName == null) continue;
            boolean hasParent = false;
            for (Individual parent : individuals.searchByName(parentName)) {
                if (Integer.parseInt(parent.getAttributeValue("ROW")) != parentRow) continue;
                NetUtils.setKinParent(net, parent, child);
                hasParent = true;
            }
            if (hasParent) continue;
            errors.appendln("Segment " + relation.getId() + ":\tNo parent with name " + parentName + " found in generation " + parentRow + " for " + child);
        }
        return result;
    }

    private static Individual getIndividual(Net net, String indiString, int row) {
        String[] parentChildPair;
        int column = 0;
        Gender gender = Gender.UNKNOWN;
        String name = null;
        String parent = null;
        boolean alive = false;
        while (indiString.charAt(0) == '-') {
            indiString = indiString.substring(1);
            ++column;
        }
        if (indiString.contains(" bi ")) {
            gender = Gender.MALE;
            indiString = indiString.replace(" bi ", ";");
        } else if (indiString.contains(" lu ")) {
            gender = Gender.FEMALE;
            indiString = indiString.replace(" lu ", ";");
        }
        if (indiString.contains("#")) {
            indiString = indiString.replaceAll("#", "");
            alive = true;
        }
        if ((parentChildPair = indiString.split(";")).length == 1) {
            name = parentChildPair[0].trim();
        } else if (parentChildPair.length == 2) {
            parent = parentChildPair[0].trim();
            name = parentChildPair[1].trim();
        }
        Individual result = net.createIndividual(name, gender);
        result.setAttribute("ROW", String.valueOf(row));
        result.setAttribute("COLUMN", String.valueOf(column));
        if (parent != null) {
            result.setAttribute("PARENT", parent);
        }
        if (alive) {
            result.setAttribute("ALIVE", "yes");
        }
        return result;
    }

    private static Relation load(File file, RelationModel model) throws PuckException {
        Relation result = new Relation(model);
        BufferedReader in = null;
        try {
            try {
                in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), PuckManager.DEFAULT_CHARSET_NAME));
                DELUZFile.read(result, in);
                result.setAttribute("SOURCEFILE", file.getName());
            }
            catch (UnsupportedEncodingException exception) {
                exception.printStackTrace();
                throw PuckExceptions.UNSUPPORTED_ENCODING.create("Opening file [" + file + "]", new Object[0]);
            }
            catch (FileNotFoundException exception) {
                exception.printStackTrace();
                throw PuckExceptions.FILE_NOT_FOUND.create("Opening file [" + file + "]", new Object[0]);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)in);
        return result;
    }

    public static Net load(File file, String relationModelName, String defaultRoleName, Report report) throws PuckException {
        Net result = new Net();
        String directory = file.getAbsolutePath();
        File folder = new File(directory);
        RelationModel model = result.createRelationModel(relationModelName);
        Role defaultRole = new Role(defaultRoleName);
        File[] fileArray = folder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File detailfile = fileArray[n2];
            try {
                Relation relation = DELUZFile.load(detailfile, model);
                result.relations().add(relation);
            }
            catch (PuckException ex) {
                System.err.println("Not a corpus file: " + detailfile.getName());
            }
            ++n2;
        }
        report.outputs().appendln("Segment\tGenealogies");
        StringList errors = new StringList();
        DELUZFile.getGenealogy(result, defaultRole, report, errors);
        if (!errors.isEmpty()) {
            report.outputs().appendln();
            report.outputs().appendln("Importation errors:");
            report.outputs().appendln(errors);
        }
        return result;
    }
}

