/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.graphs.onemode;

import org.tip.puck.PuckException;
import org.tip.puck.graphs.onemode.OMGraph;
import org.tip.puck.graphs.onemode.OMNode;
import org.tip.puck.net.Family;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Individuals;
import org.tip.puck.net.Net;
import org.tip.puck.net.workers.NetUtils;

public class GraphModeTransformer {
    public static Individuals monogamousSameSexSiblings(Individual individual) {
        Individuals result = new Individuals();
        Family family = individual.getOriginFamily();
        if (family != null) {
            for (Individual sibling : family.getChildren()) {
                if (sibling == individual || sibling.getGender() != individual.getGender() || sibling.spouses().size() != 1) continue;
                result.add(sibling);
            }
        }
        return result;
    }

    private static Individual randomDraw(Individuals individuals) {
        int randomIndex = (int)(Math.random() * (double)individuals.size());
        return (Individual)individuals.toList().get(randomIndex);
    }

    public static Net omGraphToNet(OMGraph omGraph, OMGraph.GraphMode mode) throws PuckException {
        Net result;
        switch (mode) {
            case OREGRAPH: {
                result = GraphModeTransformer.oreGraphToNet(omGraph);
                break;
            }
            case PGRAPH: {
                result = GraphModeTransformer.pGraphToNet(omGraph);
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }

    public static OMGraph netToOmGraph(Net net, OMGraph.GraphMode mode) {
        OMGraph result;
        switch (mode) {
            case OREGRAPH: {
                result = GraphModeTransformer.netToOreGraph(net);
                break;
            }
            case PGRAPH: {
                result = GraphModeTransformer.netToPGraph(net);
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }

    public static Net oreGraphToNet(OMGraph oreGraph) {
        Net result = new Net();
        for (OMNode node : oreGraph.getNodes()) {
            if (node.isVirtual()) continue;
            Individual individual = node.getIndividual().clone();
            result.individuals().add(individual);
        }
        int id = 0;
        for (OMNode node : oreGraph.getNodes()) {
            Individual father = null;
            Individual mother = null;
            Family family = null;
            Individual child = (Individual)result.individuals().getById(node.getIndividual().getId());
            if (node.getMaleLink() != null) {
                father = (Individual)result.individuals().getById(node.getMaleLink().getIndividual().getId());
            }
            if (node.getFemaleLink() != null) {
                mother = (Individual)result.individuals().getById(node.getFemaleLink().getIndividual().getId());
            }
            if (father != null && mother != null) {
                family = result.families().getBySpouses(father, mother);
                if (family == null) {
                    family = new Family(id, father, mother);
                    result.families().add(family);
                    ++id;
                }
            } else if (father != null || mother != null) {
                family = new Family(id, father, mother);
                result.families().add(family);
                ++id;
            }
            if (family == null) continue;
            family.setMarried(node.hasMarriedParents());
            if (node.isVirtual()) continue;
            child.setOriginFamily(family);
            family.getChildren().add(child);
        }
        for (Family family : result.families()) {
            Individual wife;
            Individual husband = family.getHusband();
            if (husband != null) {
                husband.addPersonalFamily(family);
            }
            if ((wife = family.getWife()) == null) continue;
            wife.addPersonalFamily(family);
        }
        return result;
    }

    public static Net pGraphToNet(OMGraph pGraph) throws PuckException {
        Individual wife;
        Net result = new Net();
        int id = 1;
        for (OMNode node : pGraph.getNodes()) {
            Family family = null;
            if (node.getFamily() != null) {
                family = node.getFamily().clone();
                if (node.getFamily().hasMarried()) {
                    family.setMarried(true);
                }
                result.families().add(family);
                node.setReferent(family);
            }
            if (node.getHusband() != null) {
                Individual husband = node.getHusband().clone();
                husband.setId(id);
                node.setHusband(husband);
                result.individuals().add(husband);
                if (family != null) {
                    husband.addPersonalFamily(family);
                }
                ++id;
            }
            if (node.getWife() == null) continue;
            wife = node.getWife().clone();
            wife.setId(id);
            node.setWife(wife);
            result.individuals().add(wife);
            if (family != null) {
                wife.addPersonalFamily(family);
            }
            ++id;
        }
        for (OMNode node : pGraph.getNodes()) {
            Individual husband = node.getHusband();
            wife = node.getWife();
            OMNode husbandLink = node.getMaleLink();
            OMNode wifeLink = node.getFemaleLink();
            if (husbandLink != null) {
                Family husbandsParents = husbandLink.getFamily();
                husband.setOriginFamily(husbandsParents);
                husbandsParents.getChildren().add(husband);
            }
            if (wifeLink == null) continue;
            Family wifesParents = wifeLink.getFamily();
            wife.setOriginFamily(wifesParents);
            wifesParents.getChildren().add(wife);
        }
        for (Individual individual : result.individuals().toList()) {
            int spouses = pGraph.getProbableNumberOfSpouses(individual.getGender(), GraphModeTransformer.monogamousSameSexSiblings(individual).size());
            while (spouses - individual.spouses().size() > 1 && GraphModeTransformer.monogamousSameSexSiblings(individual).size() > 0) {
                Individual sibling = GraphModeTransformer.randomDraw(GraphModeTransformer.monogamousSameSexSiblings(individual));
                NetUtils.fuseIndividuals(result, sibling, individual);
            }
        }
        return result;
    }

    public static OMGraph netToOreGraph(Net net) {
        OMGraph result = new OMGraph(OMGraph.GraphMode.OREGRAPH);
        for (Individual individual : net.individuals()) {
            result.putNode(individual, OMGraph.GraphMode.OREGRAPH);
        }
        for (OMNode node : result.getNodes()) {
            Family originFamily;
            Individual mother;
            Individual individual = node.getIndividual();
            Individual father = individual.getFather();
            if (father != null) {
                node.setMaleLink(result.getNode(father));
            }
            if ((mother = individual.getMother()) != null) {
                node.setFemaleLink(result.getNode(mother));
            }
            if ((originFamily = individual.getOriginFamily()) == null) continue;
            node.setMarriedParents(originFamily.hasMarried());
        }
        int id = net.individuals().getLastId() + 1;
        for (Family family : net.families()) {
            if (family.getChildren().size() != 0 || family.getHusband() == null || family.getWife() == null) continue;
            OMNode node = new OMNode(new Individual(id));
            node.setVirtual(true);
            node.setMaleLink(result.getNode(family.getHusband()));
            node.setFemaleLink(result.getNode(family.getWife()));
            node.setMarriedParents(family.hasMarried());
            result.putNode(node);
            ++id;
        }
        result.putLinks();
        result.computeOutDegrees();
        result.computeAncestors();
        return result;
    }

    public static OMGraph netToPGraph(Net net) {
        OMGraph result = new OMGraph(OMGraph.GraphMode.PGRAPH);
        result.setSiblingMarriageDistribution(net);
        for (Family family : net.families()) {
            result.putNode(family);
        }
        for (Individual individual : net.individuals()) {
            if (individual.getPersonalFamilies().size() != 0) continue;
            result.putNode(individual, OMGraph.GraphMode.PGRAPH);
        }
        for (OMNode node : result.getNodes()) {
            Family wifesFamily;
            Family family = node.getFamily();
            if (family == null) continue;
            Family husbandsFamily = family.getHusbandsOriginFamily();
            if (husbandsFamily != null) {
                node.setMaleLink(result.getNode(husbandsFamily));
            }
            if ((wifesFamily = family.getWifesOriginFamily()) == null) continue;
            node.setFemaleLink(result.getNode(wifesFamily));
        }
        result.putLinks();
        result.computeOutDegrees();
        result.computeAncestors();
        return result;
    }
}

