/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.cli;

import java.io.BufferedWriter;
import java.io.FileWriter;
import org.apache.commons.cli.CommandLine;
import org.tip.puck.alliancenets.AllianceNet;
import org.tip.puck.alliancenets.EvoAllianceGen;
import org.tip.puck.cli.Command;
import org.tip.puck.evo.EvoGen;
import org.tip.puck.evo.EvoStrategy;

public class EvoAlliance
extends Command {
    @Override
    public boolean run(CommandLine cline) {
        int generations = 10000;
        if (!cline.hasOption("inet")) {
            this.setErrorMessage("input network file must be specified");
            return false;
        }
        if (!cline.hasOption("odir")) {
            this.setErrorMessage("output directory must be specified");
            return false;
        }
        String netfile = cline.getOptionValue("inet");
        String outdir = cline.getOptionValue("odir");
        EvoAllianceGen callbacks = new EvoAllianceGen(AllianceNet.load(netfile), outdir);
        EvoStrategy popGen = new EvoStrategy(1, 1, 1);
        EvoGen evo = new EvoGen(popGen, callbacks, generations);
        System.out.println("target net: " + netfile);
        System.out.println(evo.infoString());
        try {
            FileWriter fstream = new FileWriter(String.valueOf(outdir) + "/params.txt");
            BufferedWriter out = new BufferedWriter(fstream);
            out.write(evo.infoString());
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        evo.run();
        return true;
    }
}

