package org.tip.puck.geo;

import java.util.List;

import org.apache.commons.lang3.StringUtils;

import com.vividsolutions.jts.geom.Coordinate;

public class Place {

	String name;
	String geonames1, geonames2, geonames3;
	String countryISO2;
	Integer idGeonames;
	GeoLevel level;
	Place sup;
	Coordinate coordinate;

	public Place (String name) {
		this.name = name;
		coordinate = null;
	}
	
	public Place (GeoLevel level, String name){
		this(name);
		this.level = level;
	}
	
	public Place (String name, Coordinate coord){
		this(name);
		this.coordinate = coord;
	}
	
	public Place (Integer idGeonames, String name, String geonames1, String geonames2, String geonames3, String countryCode, Coordinate coord) {
		this(name, coord);
		this.geonames1 = geonames1;
		this.geonames2 = geonames2;
		this.geonames3 = geonames3;
		this.countryISO2 = countryCode;
		this.idGeonames = idGeonames;
	}

	public Place getSup() {
		return sup;
	}

	public void setSup(Place sup) {
		this.sup = sup;
	}
	
	public Place getSup(List<String> placenames){
		Place result;
		
		result = this;
		while (placenames != null && !placenames.isEmpty() && !placenames.contains(result.getShortName())){
			result = result.getSup();
		}
		//
		return result;
	}
	
	public Place atLevel(GeoLevel level) {
		Place result;
		
		result = this;
		while (result != null && result.level != level){
			result = result.getSup();
		}
		//
		return result;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}
	
	public String getGeonames1() {
		return geonames1;
	}

	public void setGeonames1(String geonames1) {
		this.geonames1 = geonames1;
	}

	public String getGeonames2() {
		return geonames2;
	}

	public void setGeonames2(String geonames2) {
		this.geonames2 = geonames2;
	}

	public String getGeonames3() {
		return geonames3;
	}

	public void setGeonames3(String geonames3) {
		this.geonames3 = geonames3;
	}

	public String getCountry_ISO2() {
		return countryISO2;
	}

	public void setCountry_ISO2(String country_ISO2) {
		this.countryISO2 = country_ISO2;
	}

	public Integer getIdGeonames() {
		return idGeonames;
	}

	public void setIdGeonames(Integer idGeonames) {
		this.idGeonames = idGeonames;
	}

	public String getShortName(){
		String result;
		
		result = null;
		
		if (name!=null){
			result = name.split("\\/")[0].trim();
		}
		//
		return result;
	}

	public GeoLevel getLevel() {
		return level;
	}

	public void setLevel(GeoLevel level) {
		this.level = level;
	}
	
	public String toString(){
		return getId();
	}
	
	public int compareByLevel(Place place){
		int result;
		
		result = this.level.compareTo(place.level);
		
		//
		return result;
	}
	
	public String getToponym(){
		String result;
		
		String quarterName = "";
		String townName = "";
		String departmentName = "";
		String countryName = "";

		Place quarter = atLevel(GeoLevel.QUARTER);
		Place town = atLevel(GeoLevel.TOWN);
		Place department = atLevel(GeoLevel.DEPARTMENT);
		Place country = atLevel(GeoLevel.COUNTRY);
		
		if (quarter!=null){
			quarterName = quarter.getName();
		}
		if (town!=null){
			townName = town.getName();
		}
		if (department!=null){
			departmentName = department.getName();
		}
		if (country!=null){
			countryName = country.getName();
		}
		
		if (level == GeoLevel.SUBQUARTER){
			result = townName+"-"+quarterName+"-"+name;
		} else if (level == GeoLevel.QUARTER){
			result = townName+"-"+name;
		} else if (level == GeoLevel.TOWNSHIP){
			result = "Canton "+name;
		} else if (level == GeoLevel.DEPARTMENT && countryName.equals("Togo")){
			result = "Prfecture "+name;
		} else {
			result = name;
		}
		
		if (level!=GeoLevel.COUNTRY && level!=GeoLevel.CONTINENT){
			if (countryName.equals("Togo") && StringUtils.isNotBlank(departmentName) && !townName.equals("Lom") && level!=GeoLevel.DEPARTMENT){
				result = result+" ("+departmentName+")";
			} else if (!countryName.equals("Togo")){
				result = result+" ("+countryName+")";
			}
		}
		
		//
		return result;
		
	}
	
	
	
	public String getId() {
		String result;

		if (this.sup == null){
			result = this.name;
		} else {
			result = this.name + " / " + this.sup.name;
		}
		//
		return result;
	}
	
	public Coordinate getCoordinate() {
		return coordinate;
	}

	public void setCoordinate(Coordinate coordinate) {
		this.coordinate = coordinate;
	}
	
	
}