/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.report;

import fr.devinsy.util.StringList;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TreeMap;
import org.tip.puck.util.MathUtils;

public class ReportTable {
    private String title;
    private int rowCount;
    private int columnCount;
    private Object[][] data;

    public ReportTable(int rowCount, int columnCount) {
        this.rowCount = rowCount;
        this.columnCount = columnCount;
        this.data = new String[rowCount][columnCount];
    }

    public ReportTable(ReportTable source) {
        this.rowCount = source.getRowCount();
        this.columnCount = source.getColumnCount();
        this.data = new String[this.rowCount][this.columnCount];
        int rowIndex = 0;
        while (rowIndex < this.rowCount) {
            int columnIndex = 0;
            while (columnIndex < this.columnCount) {
                this.data[rowIndex][columnIndex] = source.get(rowIndex, columnIndex);
                ++columnIndex;
            }
            ++rowIndex;
        }
    }

    public Object get(int rowIndex, int columnIndex) {
        Object result = this.data[rowIndex][columnIndex];
        return result;
    }

    public int getColumnCount() {
        int result = this.columnCount;
        return result;
    }

    public int getRowCount() {
        int result = this.rowCount;
        return result;
    }

    public String getString(int rowIndex, int columnIndex) {
        Object data = this.data[rowIndex][columnIndex];
        String result = data == null ? null : data.toString();
        return result;
    }

    public String getTitle() {
        return this.title;
    }

    public void set(int rowIndex, int columnIndex, boolean value) {
        this.set(rowIndex, columnIndex, String.valueOf(value));
    }

    public void set(int rowIndex, int columnIndex, Calendar source) {
        if (source != null) {
            this.set(rowIndex, columnIndex, new SimpleDateFormat("dd/MM/yyyy").format(source));
        }
    }

    public void set(int rowIndex, int columnIndex, double value) {
        this.set(rowIndex, columnIndex, String.valueOf(value));
    }

    public void set(int rowIndex, int columnIndex, float value) {
        this.set(rowIndex, columnIndex, String.valueOf(value));
    }

    public void set(int rowIndex, int columnIndex, int value) {
        this.set(rowIndex, columnIndex, String.valueOf(value));
    }

    public void set(int rowIndex, int columnIndex, Object object) {
        if (object != null) {
            this.set(rowIndex, columnIndex, object.toString());
        }
    }

    public void set(int rowIndex, int columnIndex, String value) {
        if (value != null) {
            this.data[rowIndex][columnIndex] = value;
        }
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String toString() {
        StringList buffer = new StringList();
        int rowIndex = 0;
        while (rowIndex < this.rowCount) {
            int columnIndex = 0;
            while (columnIndex < this.columnCount) {
                if (columnIndex != 0) {
                    buffer.append("\t");
                }
                buffer.append(this.getString(rowIndex, columnIndex));
                ++columnIndex;
            }
            ++rowIndex;
        }
        String result = buffer.toString();
        return result;
    }

    public static TreeMap<Integer, Integer> columnSizeDistribution(ReportTable tableWithSum) {
        TreeMap<Integer, Integer> result = new TreeMap<Integer, Integer>();
        int rowIndex = 1;
        while (rowIndex < tableWithSum.getRowCount() - 1) {
            int size = Integer.parseInt(tableWithSum.getString(rowIndex, tableWithSum.getColumnCount() - 1));
            Integer number = result.get(size);
            if (number == null) {
                result.put(size, 1);
            } else {
                result.put(size, number + 1);
            }
            ++rowIndex;
        }
        return result;
    }

    public static ReportTable normalize(ReportTable source) {
        ReportTable result = new ReportTable(source.getRowCount(), source.getColumnCount());
        result.setTitle(String.valueOf(source.getTitle()) + " (%)");
        int rowIndex = 1;
        while (rowIndex < source.getRowCount()) {
            result.set(rowIndex, 0, source.get(rowIndex, 0));
            ++rowIndex;
        }
        int columnIndex = 1;
        while (columnIndex < source.getColumnCount()) {
            result.set(0, columnIndex, source.get(0, columnIndex));
            Double rowSum = new Double((String)source.get(source.getRowCount() - 1, columnIndex));
            int rowIndex2 = 1;
            while (rowIndex2 < source.getRowCount()) {
                Double value = new Double((String)source.get(rowIndex2, columnIndex));
                Double percentage = MathUtils.percent(value, rowSum);
                result.set(rowIndex2, columnIndex, percentage);
                ++rowIndex2;
            }
            ++columnIndex;
        }
        return result;
    }

    public static ReportTable transpose(ReportTable source) {
        ReportTable result = new ReportTable(source.getColumnCount(), source.getRowCount());
        result.setTitle(source.getTitle());
        int columnIndex = 0;
        while (columnIndex < source.getColumnCount()) {
            int rowIndex = 0;
            while (rowIndex < source.getRowCount()) {
                result.set(columnIndex, rowIndex, source.get(rowIndex, columnIndex));
                ++rowIndex;
            }
            ++columnIndex;
        }
        return result;
    }
}

