/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.partitions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.tip.puck.partitions.Cluster;
import org.tip.puck.partitions.ClusterComparatorBySize;
import org.tip.puck.partitions.ClusterComparatorByValue;
import org.tip.puck.util.Value;

public class Clusters<E>
extends HashMap<Value, Cluster<E>>
implements Iterable<Cluster<E>> {
    private static final long serialVersionUID = 908605489478085791L;

    public Collection<Value> getValues() {
        Set<Value> result = this.keySet();
        return result;
    }

    public boolean isNotEmpty() {
        boolean result = !this.isEmpty();
        return result;
    }

    public boolean isNumeric() {
        boolean ended = false;
        boolean result = false;
        Iterator<Value> iterator = this.getValues().iterator();
        while (!ended) {
            if (iterator.hasNext()) {
                Value value = iterator.next();
                if (value == null || !value.isNotNumber()) continue;
                ended = true;
                result = false;
                continue;
            }
            ended = true;
            result = true;
        }
        return result;
    }

    public boolean isNumericOrNull() {
        boolean ended = false;
        boolean result = false;
        Iterator<Value> iterator = this.getValues().iterator();
        while (!ended) {
            if (iterator.hasNext()) {
                Value value = iterator.next();
                if (value == null || !value.isNotNumber()) continue;
                ended = true;
                result = false;
                continue;
            }
            ended = true;
            result = true;
        }
        return result;
    }

    @Override
    public Iterator<Cluster<E>> iterator() {
        Iterator<Cluster<E>> result = this.values().iterator();
        return result;
    }

    public Cluster<E> put(Cluster<E> cluster) {
        if (cluster != null) {
            this.put(cluster.getValue(), cluster);
        }
        Cluster<E> result = cluster;
        return result;
    }

    public List<Cluster<E>> toList() {
        ArrayList<Cluster<E>> result = new ArrayList<Cluster<E>>(this.values());
        return result;
    }

    public List<Cluster<E>> toListSortedByDescendingSize() {
        List<Cluster<E>> result = this.toListSortedBySize();
        Collections.reverse(result);
        return result;
    }

    public List<Cluster<E>> toListSortedByDescendingValue() {
        List<Cluster<E>> result = this.toListSortedByValue();
        Collections.reverse(result);
        return result;
    }

    public List<Cluster<E>> toListSortedBySize() {
        List<Cluster<E>> result = this.toList();
        Collections.sort(result, new ClusterComparatorBySize());
        return result;
    }

    public List<Cluster<E>> toListSortedByValue() {
        List<Cluster<E>> result = this.toList();
        Collections.sort(result, new ClusterComparatorByValue());
        return result;
    }
}

