/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net.workers;

import fr.devinsy.util.StringList;
import fr.inria.aviz.geneaquilt.model.DateRange;
import fr.inria.aviz.geneaquilt.model.Edge;
import fr.inria.aviz.geneaquilt.model.Fam;
import fr.inria.aviz.geneaquilt.model.Indi;
import fr.inria.aviz.geneaquilt.model.Network;
import fr.inria.aviz.geneaquilt.model.Vertex;
import java.util.ArrayList;
import java.util.Calendar;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.net.Attribute;
import org.tip.puck.net.Families;
import org.tip.puck.net.Family;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Individuals;
import org.tip.puck.net.Net;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.net.relations.Relations;
import org.tip.puck.segmentation.Segmentation;
import org.tip.puckgui.views.geneaquilt.Event;
import org.tip.puckgui.views.geneaquilt.EventQuiltCriteria;

public class GeneaQuiltConvert {
    private static final Logger logger = LoggerFactory.getLogger(GeneaQuiltConvert.class);

    public static Network convertToEventQuilt(Individuals individuals, Families families, Relations relations) {
        Network result = new Network();
        try {
            int year;
            Object calendar;
            DateRange dateRange;
            Event event;
            for (Individual individual : individuals) {
                Indi targetIndividual = new Indi();
                targetIndividual.setId("I" + String.valueOf(individual.getId()));
                result.addVertex((Vertex)targetIndividual);
                targetIndividual.setProperty("NAME", (Object)individual.getName());
                if (StringUtils.isNotBlank((CharSequence)individual.getFirstName())) {
                    targetIndividual.setProperty("NAME.GIVN", (Object)individual.getFirstName());
                }
                if (StringUtils.isNotBlank((CharSequence)individual.getLastName())) {
                    targetIndividual.setProperty("NAME.SURN", (Object)individual.getLastName());
                }
                if (individual.getGender() != null) {
                    targetIndividual.setSex(String.valueOf(individual.getGender().toGedChar()));
                }
                if (individual.getOriginFamily() != null) {
                    targetIndividual.addFams("F" + String.valueOf(individual.getOriginFamily().getId()));
                }
                for (Family familySpouse : individual.getPersonalFamilies()) {
                    targetIndividual.addFams("F" + String.valueOf(familySpouse.getId()));
                }
                for (Relation relation : individual.relations()) {
                    targetIndividual.addFams("R" + relation.getId() + "-" + relation.getTypedId());
                }
                for (Attribute attribute : individual.attributes()) {
                    if (attribute.getLabel().contains("_DATE") && !attribute.getLabel().startsWith("CHAN_")) {
                        targetIndividual.setDate(attribute.getLabel(), attribute.getValue().trim());
                        continue;
                    }
                    targetIndividual.setProperty(attribute.getLabel(), (Object)attribute.getValue());
                }
            }
            for (Family family : families) {
                event = new Event();
                event.setId("F" + family.getId());
                result.addVertex((Vertex)event);
                event.setProperty("ID", (Object)("F" + family.getId()));
                for (Attribute attribute : family.attributes()) {
                    if (StringUtils.equals((CharSequence)attribute.getLabel(), (CharSequence)"DATE") || attribute.getLabel().contains("_DATE") && !attribute.getLabel().startsWith("CHAN_")) {
                        event.setDate(attribute.getLabel(), attribute.getValue().trim());
                        continue;
                    }
                    event.setProperty(attribute.getLabel(), (Object)attribute.getValue());
                }
                dateRange = event.getDateRange();
                if (dateRange.isValid()) {
                    calendar = Calendar.getInstance();
                    ((Calendar)calendar).setTimeInMillis(dateRange.getStart() * 1000L);
                    year = ((Calendar)calendar).get(1);
                    event.setLabel(String.valueOf(year));
                } else {
                    event.setLabel(" F ");
                }
                event.setProperty("MODEL", (Object)"Family");
            }
            for (Relation relation : relations) {
                event = new Event();
                event.setId("R" + relation.getId() + "-" + relation.getTypedId());
                result.addVertex((Vertex)event);
                event.setProperty("ID", (Object)("R" + relation.getId() + "-" + relation.getTypedId()));
                event.setProperty("NAME", (Object)relation.getName());
                for (Attribute attribute : relation.attributes()) {
                    if (StringUtils.equals((CharSequence)attribute.getLabel(), (CharSequence)"DATE") || attribute.getLabel().contains("_DATE") && !attribute.getLabel().startsWith("CHAN_")) {
                        event.setDate(attribute.getLabel(), attribute.getValue().trim());
                        continue;
                    }
                    event.setProperty(attribute.getLabel(), (Object)attribute.getValue());
                }
                dateRange = event.getDateRange();
                if (dateRange.isValid()) {
                    calendar = Calendar.getInstance();
                    ((Calendar)calendar).setTimeInMillis(dateRange.getStart() * 1000L);
                    year = ((Calendar)calendar).get(1);
                    event.setLabel(String.valueOf(year));
                } else {
                    event.setLabel(" R ");
                }
                event.setProperty("MODEL", (Object)relation.getModel().getName());
            }
            for (Vertex vertex : result.getVertices()) {
                Indi indi;
                if (!(vertex instanceof Indi) || (indi = (Indi)vertex).getFams() == null) continue;
                for (String fid : indi.getFams()) {
                    Edge edge;
                    Vertex fam = result.getVertex(fid);
                    if (fam == null || result.containsEdge((Object)(edge = new Edge(fam.getId(), vertex.getId())))) continue;
                    result.addEdge((Object)edge, (Object)fam, (Object)indi);
                    edge.setFromVertex(fam);
                    edge.setToVertex((Vertex)indi);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            result = null;
        }
        return result;
    }

    public static Network convertToEventQuilt(Individuals individuals, Families families, Relations relations, EventQuiltCriteria criteria) {
        Network result = new Network();
        try {
            int year;
            Object calendar;
            DateRange dateRange;
            Event event;
            for (Individual individual : individuals) {
                Indi targetIndividual = new Indi();
                targetIndividual.setId("I" + String.valueOf(individual.getId()));
                result.addVertex((Vertex)targetIndividual);
                targetIndividual.setProperty("NAME", (Object)individual.getName());
                if (StringUtils.isNotBlank((CharSequence)individual.getFirstName())) {
                    targetIndividual.setProperty("NAME.GIVN", (Object)individual.getFirstName());
                }
                if (StringUtils.isNotBlank((CharSequence)individual.getLastName())) {
                    targetIndividual.setProperty("NAME.SURN", (Object)individual.getLastName());
                }
                if (individual.getGender() != null) {
                    targetIndividual.setSex(String.valueOf(individual.getGender().toGedChar()));
                }
                if (individual.getOriginFamily() != null) {
                    targetIndividual.addFams("F" + String.valueOf(individual.getOriginFamily().getId()));
                }
                for (Family familySpouse : individual.getPersonalFamilies()) {
                    targetIndividual.addFams("F" + String.valueOf(familySpouse.getId()));
                }
                for (Relation relation : individual.relations()) {
                    targetIndividual.addFams("R" + relation.getId() + "-" + relation.getTypedId());
                }
                for (Attribute attribute : individual.attributes()) {
                    if (attribute.getLabel().contains("_DATE") && !attribute.getLabel().startsWith("CHAN_")) {
                        targetIndividual.setDate(attribute.getLabel(), attribute.getValue().trim());
                        continue;
                    }
                    targetIndividual.setProperty(attribute.getLabel(), (Object)attribute.getValue());
                }
            }
            for (Family family : families) {
                event = new Event();
                event.setId("F" + family.getId());
                event.setProperty("ID", (Object)("F" + family.getId()));
                if (family.getHusband() != null) {
                    event.setHusb("I" + String.valueOf(family.getHusband().getId()));
                }
                if (family.getWife() != null) {
                    event.setWife("I" + String.valueOf(family.getWife().getId()));
                }
                for (Attribute attribute : family.attributes()) {
                    if (StringUtils.equals((CharSequence)attribute.getLabel(), (CharSequence)"DATE") || attribute.getLabel().contains("_DATE") && !attribute.getLabel().startsWith("CHAN_")) {
                        event.setDate(attribute.getLabel(), attribute.getValue().trim());
                        continue;
                    }
                    event.setProperty(attribute.getLabel(), (Object)attribute.getValue());
                }
                dateRange = event.getDateRange();
                if (dateRange.isValid()) {
                    calendar = Calendar.getInstance();
                    ((Calendar)calendar).setTimeInMillis(dateRange.getStart() * 1000L);
                    year = ((Calendar)calendar).get(1);
                    event.setLabel(String.valueOf(year));
                } else {
                    event.setLabel(" F ");
                }
                event.setProperty("MODEL", (Object)"Family");
                if (!event.getDateRange().isValid() && !criteria.isShowUndatedEvent()) continue;
                result.addVertex((Vertex)event);
            }
            for (Relation relation : relations) {
                event = new Event();
                event.setId("R" + relation.getId() + "-" + relation.getTypedId());
                event.setProperty("ID", (Object)("R" + relation.getId() + "-" + relation.getTypedId()));
                event.setProperty("NAME", (Object)relation.getName());
                for (Attribute attribute : relation.attributes()) {
                    if (StringUtils.equals((CharSequence)attribute.getLabel(), (CharSequence)"DATE") || attribute.getLabel().contains("_DATE") && !attribute.getLabel().startsWith("CHAN_")) {
                        event.setDate(attribute.getLabel(), attribute.getValue().trim());
                        continue;
                    }
                    event.setProperty(attribute.getLabel(), (Object)attribute.getValue());
                }
                dateRange = event.getDateRange();
                if (dateRange.isValid()) {
                    calendar = Calendar.getInstance();
                    ((Calendar)calendar).setTimeInMillis(dateRange.getStart() * 1000L);
                    year = ((Calendar)calendar).get(1);
                    event.setLabel(String.valueOf(year));
                } else {
                    event.setLabel(" R ");
                }
                event.setProperty("MODEL", (Object)relation.getModel().getName());
                if (!event.getDateRange().isValid() && !criteria.isShowUndatedEvent()) continue;
                result.addVertex((Vertex)event);
            }
            for (Vertex vertex : result.getVertices()) {
                Indi indi;
                if (!(vertex instanceof Indi) || (indi = (Indi)vertex).getFams() == null) continue;
                for (String fid : indi.getFams()) {
                    Edge edge;
                    Vertex fam = result.getVertex(fid);
                    if (fam == null || result.containsEdge((Object)(edge = new Edge(fam.getId(), vertex.getId())))) continue;
                    result.addEdge((Object)edge, (Object)fam, (Object)indi);
                    edge.setFromVertex(fam);
                    edge.setToVertex((Vertex)indi);
                }
            }
            if (!criteria.isShowUnlinkedIndividual()) {
                ArrayList<Vertex> targetVertices = new ArrayList<Vertex>();
                for (Vertex vertex : result.getVertices()) {
                    if (!(vertex instanceof Indi) || !result.getInEdges((Object)vertex).isEmpty()) continue;
                    targetVertices.add(vertex);
                }
                for (Vertex vertex : targetVertices) {
                    result.removeVertex(vertex);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            result = null;
        }
        return result;
    }

    public static Network convertToEventQuilt(Net source) {
        Network result = GeneaQuiltConvert.convertToEventQuilt(source.individuals(), source.families(), source.relations());
        return result;
    }

    public static Network convertToEventQuilt(Segmentation source) {
        Network result = GeneaQuiltConvert.convertToEventQuilt(source.getCurrentIndividuals(), source.getCurrentFamilies(), source.getCurrentRelations());
        return result;
    }

    public static Network convertToGeneaQuilt(Individuals individuals, Families families) {
        Network result = new Network();
        try {
            for (Individual individual : individuals) {
                Indi targetIndividual = new Indi();
                targetIndividual.setId("I" + String.valueOf(individual.getId()));
                result.addVertex((Vertex)targetIndividual);
                targetIndividual.setProperty("NAME", (Object)individual.getName());
                if (StringUtils.isNotBlank((CharSequence)individual.getFirstName())) {
                    targetIndividual.setProperty("NAME.GIVN", (Object)individual.getFirstName());
                }
                if (StringUtils.isNotBlank((CharSequence)individual.getLastName())) {
                    targetIndividual.setProperty("NAME.SURN", (Object)individual.getLastName());
                }
                if (individual.getGender() != null) {
                    targetIndividual.setSex(String.valueOf(individual.getGender().toGedChar()));
                }
                if (individual.getOriginFamily() != null) {
                    targetIndividual.setFamc("F" + String.valueOf(individual.getOriginFamily().getId()));
                }
                for (Family familySpouse : individual.getPersonalFamilies()) {
                    targetIndividual.addFams("F" + String.valueOf(familySpouse.getId()));
                }
                for (Attribute attribute : individual.attributes()) {
                    if (StringUtils.equals((CharSequence)attribute.getLabel(), (CharSequence)"DATE") || attribute.getLabel().contains("_DATE") && !attribute.getLabel().startsWith("CHAN_")) {
                        targetIndividual.setDate(attribute.getLabel(), attribute.getValue().trim());
                        continue;
                    }
                    targetIndividual.setProperty(attribute.getLabel(), (Object)attribute.getValue());
                }
            }
            for (Family family : families) {
                Fam fam = new Fam();
                fam.setId(String.valueOf("F" + family.getId()));
                result.addVertex((Vertex)fam);
                if (family.getHusband() != null) {
                    fam.setHusb("I" + String.valueOf(family.getHusband().getId()));
                }
                if (family.getWife() != null) {
                    fam.setWife("I" + String.valueOf(family.getWife().getId()));
                }
                for (Attribute attribute : family.attributes()) {
                    if (StringUtils.equals((CharSequence)attribute.getLabel(), (CharSequence)"DATE") || attribute.getLabel().contains("_DATE") && !attribute.getLabel().startsWith("CHAN_")) {
                        fam.setDate(attribute.getLabel(), attribute.getValue().trim());
                        continue;
                    }
                    fam.setProperty(attribute.getLabel(), (Object)attribute.getValue());
                }
            }
            for (Vertex vertex : result.getVertices()) {
                Edge edge;
                Vertex fam;
                if (!(vertex instanceof Indi)) continue;
                Indi indi = (Indi)vertex;
                if (indi.getFamc() != null && (fam = result.getVertex(indi.getFamc())) != null && !result.containsEdge((Object)(edge = new Edge(vertex.getId(), indi.getFamc())))) {
                    result.addEdge((Object)edge, (Object)indi, (Object)fam);
                    edge.setFromVertex(vertex);
                    edge.setToVertex(fam);
                }
                if (indi.getFams() == null) continue;
                for (String fid : indi.getFams()) {
                    Edge edge2;
                    Vertex fam2 = result.getVertex(fid);
                    if (fam2 == null || result.containsEdge((Object)(edge2 = new Edge(fam2.getId(), vertex.getId())))) continue;
                    result.addEdge((Object)edge2, (Object)fam2, (Object)indi);
                    edge2.setFromVertex(fam2);
                    edge2.setToVertex((Vertex)indi);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            result = null;
        }
        return result;
    }

    public static Network convertToGeneaQuilt(Net source) {
        Network result = GeneaQuiltConvert.convertToGeneaQuilt(source.individuals(), source.families());
        return result;
    }

    public static Network convertToGeneaQuilt(Segmentation source) {
        Network result = GeneaQuiltConvert.convertToGeneaQuilt(source.getCurrentIndividuals(), source.getCurrentFamilies());
        return result;
    }

    private static StringList match(StringList source, String pattern) {
        StringList result = new StringList();
        for (String string : source) {
            if (!string.matches(pattern)) continue;
            result.add((Object)string);
        }
        return result;
    }
}

