/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net.workers;

import java.text.Collator;
import java.util.Comparator;
import org.tip.puck.net.workers.AttributeDescriptor;

public class AttributeDescriptorComparator
implements Comparator<AttributeDescriptor> {
    private Sorting sorting;

    public AttributeDescriptorComparator(Sorting sorting) {
        this.sorting = sorting;
    }

    @Override
    public int compare(AttributeDescriptor alpha, AttributeDescriptor bravo) {
        int result = AttributeDescriptorComparator.compare(alpha, bravo, this.sorting);
        return result;
    }

    public static int compare(AttributeDescriptor alpha, AttributeDescriptor bravo, Sorting sorting) {
        int result;
        if (alpha == null && bravo == null) {
            result = 0;
        } else if (alpha == null) {
            result = -1;
        } else if (bravo == null) {
            result = 1;
        } else {
            switch (sorting) {
                case DEFAULT: {
                    result = AttributeDescriptorComparator.compare(alpha, bravo, Sorting.SCOPE);
                    if (result != 0) break;
                    result = AttributeDescriptorComparator.compare(alpha, bravo, Sorting.LABEL);
                    break;
                }
                case SCOPE: {
                    result = AttributeDescriptorComparator.compare(alpha.getScope(), bravo.getScope());
                    if (result != 0 || alpha.getScope() == null || alpha.getScope() != AttributeDescriptor.Scope.RELATION) break;
                    result = AttributeDescriptorComparator.compare(alpha.getOptionalRelationName(), bravo.getOptionalRelationName());
                    break;
                }
                case LABEL: {
                    result = AttributeDescriptorComparator.compare(alpha.getLabel(), bravo.getLabel());
                    break;
                }
                default: {
                    result = 0;
                }
            }
        }
        return result;
    }

    public static int compare(AttributeDescriptor.Scope alpha, AttributeDescriptor.Scope bravo) {
        int bravoValue;
        int alphaValue;
        int result = alpha == null && bravo == null ? 0 : (alpha == null ? -1 : (bravo == null ? 1 : (alpha == bravo ? 0 : ((alphaValue = AttributeDescriptorComparator.position(alpha)) > (bravoValue = AttributeDescriptorComparator.position(bravo)) ? 1 : -1))));
        return result;
    }

    public static int compare(String alpha, String bravo) {
        int result = alpha == null && bravo == null ? 0 : (alpha == null ? -1 : (bravo == null ? 1 : Collator.getInstance().compare(alpha, bravo)));
        return result;
    }

    private static int position(AttributeDescriptor.Scope value) {
        int result;
        switch (value) {
            case CORPUS: {
                result = 1;
                break;
            }
            case INDIVIDUALS: {
                result = 2;
                break;
            }
            case FAMILIES: {
                result = 3;
                break;
            }
            case RELATION: {
                result = 4;
                break;
            }
            case ACTORS: {
                result = 5;
                break;
            }
            default: {
                result = 0;
            }
        }
        return result;
    }

    public static enum Sorting {
        DEFAULT,
        SCOPE,
        LABEL;

    }
}

