/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.kinoath;

import java.util.HashMap;
import java.util.Iterator;
import nl.mpi.kinnate.kindata.DataTypes;
import nl.mpi.kinnate.kindata.EntityData;
import org.joda.time.DateTimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Individuals;

public class Puck2KinOath {
    private static final Logger logger = LoggerFactory.getLogger(Puck2KinOath.class);

    public static EntityData[] convert(Individuals source) {
        long timer = DateTimeUtils.currentTimeMillis();
        HashMap<Long, EntityData> entities = new HashMap<Long, EntityData>();
        for (Individual individual : source) {
            EntityData.SymbolType gender;
            switch (individual.getGender()) {
                case FEMALE: {
                    gender = EntityData.SymbolType.circle;
                    break;
                }
                case MALE: {
                    gender = EntityData.SymbolType.triangle;
                    break;
                }
                default: {
                    gender = EntityData.SymbolType.square;
                }
            }
            EntityData entity = new EntityData(individual.getId(), new String[]{individual.getName()}, gender, false, null, null);
            entities.put(Long.valueOf(individual.getId()), entity);
        }
        for (Individual individual : source) {
            if (individual.getOriginFamily() == null) continue;
            EntityData entity = (EntityData)entities.get(individual.getId());
            for (Individual parent : individual.getParents()) {
                EntityData parentEntity = (EntityData)entities.get(parent.getId());
                if (parentEntity == null) continue;
                entity.addRelatedNode(parentEntity, DataTypes.RelationType.ancestor, null, null, null, null);
            }
            for (Individual partner : individual.getPartners()) {
                EntityData partnerEntity = (EntityData)entities.get(partner.getId());
                if (partnerEntity == null) continue;
                entity.addRelatedNode(partnerEntity, DataTypes.RelationType.union, null, null, null, null);
            }
            for (Individual child : individual.children()) {
                EntityData childEntity = (EntityData)entities.get(child.getId());
                if (childEntity == null) continue;
                entity.addRelatedNode(childEntity, DataTypes.RelationType.descendant, null, null, null, null);
            }
        }
        EntityData[] result = new EntityData[entities.size()];
        int count = 0;
        Iterator iterator = entities.values().iterator();
        while (iterator.hasNext()) {
            EntityData entity;
            result[count] = entity = (EntityData)iterator.next();
            ++count;
        }
        logger.debug("...done (" + (DateTimeUtils.currentTimeMillis() - timer) + " ms)");
        return result;
    }
}

