/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.io.bar;

import java.io.File;
import java.security.InvalidParameterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckException;
import org.tip.puck.PuckExceptions;
import org.tip.puck.PuckManager;
import org.tip.puck.io.bar.BARDetector;
import org.tip.puck.io.bar.BARODSFile;
import org.tip.puck.io.bar.BARTXTFile;
import org.tip.puck.io.bar.BARXLSFile;
import org.tip.puck.net.Net;

public class BARFile {
    private static final Logger logger = LoggerFactory.getLogger(BARFile.class);

    public static boolean isBAR(File source) {
        boolean result = BARFile.isBAR(source, PuckManager.DEFAULT_CHARSET_NAME);
        return result;
    }

    public static boolean isBAR(File source, String charsetName) {
        boolean result = BARDetector.isBAR(source, charsetName);
        return result;
    }

    public static Net load(File source, String charsetName) throws PuckException {
        Net result;
        if (source == null) {
            throw new InvalidParameterException("Null parameter");
        }
        String fileName = source.getName().toLowerCase();
        if (fileName.endsWith(".ods")) {
            result = BARODSFile.load(source);
        } else if (fileName.endsWith(".txt")) {
            result = BARTXTFile.load(source, charsetName);
        } else if (fileName.endsWith(".xls")) {
            result = BARXLSFile.load(source);
        } else {
            throw new InvalidParameterException("Unknown extension.");
        }
        return result;
    }

    public static void save(File target, Net source) throws PuckException {
        if (source == null) {
            throw new InvalidParameterException("Null parameter");
        }
        String fileName = target.getName().toLowerCase();
        if (fileName.endsWith(".ods")) {
            BARODSFile.save(target, source);
        } else if (fileName.endsWith(".txt")) {
            BARTXTFile.save(target, source);
        } else if (fileName.endsWith(".xls")) {
            BARXLSFile.save(target, source);
        } else {
            throw PuckExceptions.UNSUPPORTED_FILE_FORMAT.create(target.getName(), new Object[0]);
        }
    }
}

