/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.views.kinoath;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckException;
import org.tip.puck.kinoath.KinOathDiagram;
import org.tip.puck.kinoath.Puck2KinOath;
import org.tip.puck.net.Individuals;
import org.tip.puckgui.NetGUI;
import org.tip.puckgui.views.kinoath.KinOathDiagramPanel;

public class GlobalDiagramPanel
extends JPanel {
    private static final long serialVersionUID = 651718283569255829L;
    private static final Logger logger = LoggerFactory.getLogger(GlobalDiagramPanel.class);
    int reportCounter = 0;
    private JPanel thisJPanel = this;
    private NetGUI netGUI;
    KinOathDiagram diagram;
    private KinOathDiagramPanel diagramScrollPanel;

    public GlobalDiagramPanel(NetGUI guiManager, Individuals source) {
        this.netGUI = guiManager;
        this.setLayout(new BoxLayout(this, 1));
        JPanel diagramZonePanel = new JPanel();
        this.add(diagramZonePanel);
        diagramZonePanel.setLayout(new BorderLayout(0, 0));
        JPanel parametersPanel = new JPanel();
        diagramZonePanel.add((Component)parametersPanel, "North");
        parametersPanel.setBorder(new EmptyBorder(0, 0, 2, 0));
        parametersPanel.setLayout(new BoxLayout(parametersPanel, 0));
        JButton btnResetZoom = new JButton(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("GlobalDiagramPanel.btnResetZoom.text"));
        btnResetZoom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                GlobalDiagramPanel.this.diagramScrollPanel.resetZoom();
            }
        });
        Component horizontalGlue_1 = Box.createHorizontalGlue();
        parametersPanel.add(horizontalGlue_1);
        parametersPanel.add(btnResetZoom);
        Component horizontalStrut = Box.createHorizontalStrut(20);
        parametersPanel.add(horizontalStrut);
        JButton btnExport = new JButton(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("GlobalDiagramPanel.btnExport.text"));
        btnExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    GlobalDiagramPanel.this.diagramScrollPanel.export();
                }
                catch (IOException exception) {
                    exception.printStackTrace();
                }
                catch (PuckException exception) {
                    exception.printStackTrace();
                }
            }
        });
        JButton btnCopy = new JButton(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("GlobalDiagramPanel.btnCopy.text"));
        btnCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                GlobalDiagramPanel.this.diagramScrollPanel.copyToClipboard();
            }
        });
        parametersPanel.add(btnCopy);
        Component horizontalStrut_2 = Box.createHorizontalStrut(20);
        parametersPanel.add(horizontalStrut_2);
        parametersPanel.add(btnExport);
        Component horizontalStrut_1 = Box.createHorizontalStrut(20);
        parametersPanel.add(horizontalStrut_1);
        JPanel diagramPanel = new JPanel();
        diagramZonePanel.add((Component)diagramPanel, "Center");
        this.diagramScrollPanel = new KinOathDiagramPanel(Puck2KinOath.convert(source));
        diagramPanel.setLayout(new BorderLayout(0, 0));
        diagramPanel.add((Component)((Object)this.diagramScrollPanel));
        JLabel lblHelp = new JLabel(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("GlobalDiagramPanel.lblHelp.text"));
        diagramZonePanel.add((Component)lblHelp, "South");
        JPanel buttonsPanel = new JPanel();
        this.add(buttonsPanel);
        buttonsPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        buttonsPanel.setLayout(new BoxLayout(buttonsPanel, 0));
        Component horizontalStrut_6 = Box.createHorizontalStrut(20);
        buttonsPanel.add(horizontalStrut_6);
        JButton btnClose = new JButton(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("IndividualDiagramPanel.btnClose.text"));
        btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GlobalDiagramPanel.this.netGUI.closeCurrentTab();
            }
        });
        buttonsPanel.add(btnClose);
        Component horizontalGlue = Box.createHorizontalGlue();
        buttonsPanel.add(horizontalGlue);
        JPanel panel_13 = new JPanel();
        buttonsPanel.add(panel_13);
        panel_13.setLayout(new BoxLayout(panel_13, 0));
    }

    public void update() {
        this.updateIndividualDiagram();
    }

    public void updateIndividualDiagram() {
        this.updateIndividualDiagram(this.netGUI.getCurrentIndividuals());
    }

    public void updateIndividualDiagram(Individuals source) {
        if (source == null) {
            logger.debug("updateIndividualDiagram(null)");
        } else {
            logger.debug("updateIndividualDiagram " + source.size());
            this.diagramScrollPanel.updateSource(Puck2KinOath.convert(source));
        }
    }
}

