/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.views.geographyEditor;

import java.awt.Component;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.util.ToolBox;
import org.tip.puckgui.util.GenericFileFilter;

public class GeographyImportFileSelector
extends JFileChooser {
    private static final long serialVersionUID = -7102002651602312728L;
    private static final Logger logger = LoggerFactory.getLogger(GeographyImportFileSelector.class);

    public GeographyImportFileSelector(File targetFile) {
        this.setSelectedFile(targetFile);
        this.setDialogTitle(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.saveAsFileChooser.text"));
        this.setFileSelectionMode(0);
        this.setAcceptAllFileFilterUsed(false);
        this.setApproveButtonText("Load");
        this.setDialogType(2);
        GenericFileFilter defaultFileFilter = new GenericFileFilter("Geographic files (*.csv, *.ods, *.txt, *.xls)", "csv", "ods", "txt", "xls");
        this.addChoosableFileFilter(defaultFileFilter);
        this.addChoosableFileFilter(new GenericFileFilter("Geographic OpenDocumentFormat Spreadsheet (*.ods)", "ods"));
        this.addChoosableFileFilter(new GenericFileFilter("Geographic Text (*.txt, *.csv)", "txt", ".csv"));
        this.addChoosableFileFilter(new GenericFileFilter("Geographic Microsoft Excel (*.xls)", "xls"));
        this.setFileFilter(defaultFileFilter);
    }

    @Override
    public void approveSelection() {
        File targetFile = this.getSelectedFile();
        logger.debug("getCurrentDirectory(): {}", (Object)this.getCurrentDirectory());
        logger.debug("selectedFile={}", (Object)targetFile);
        if (StringUtils.isBlank((CharSequence)ToolBox.getExtension(targetFile))) {
            targetFile = new File(String.valueOf(targetFile.getAbsolutePath()) + ".txt");
        }
        if (!StringUtils.endsWithAny((CharSequence)ToolBox.getExtension(targetFile), (CharSequence[])new CharSequence[]{"csv", "ods", "txt", "xls"})) {
            targetFile = new File(String.valueOf(targetFile.getAbsolutePath()) + ".geo.csv");
            this.setSelectedFile(targetFile);
        }
        if (!targetFile.exists()) {
            String title = "Import geography file error";
            String message = "Please, select an exiting file.";
            JOptionPane.showMessageDialog(this, message, title, 0);
        } else {
            super.approveSelection();
        }
    }

    @Override
    public void cancelSelection() {
        logger.debug("Cancel selection.");
        super.cancelSelection();
    }

    @Override
    public void setSelectedFile(File file) {
        super.setSelectedFile(file);
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (!visible) {
            this.resetChoosableFileFilters();
        }
    }

    public static File showSelectorDialog(Component parent, File targetFile) {
        File result;
        GeographyImportFileSelector selector = new GeographyImportFileSelector(targetFile);
        if (selector.showDialog(parent, null) == 0) {
            logger.debug("getCurrentDirectory(): {}", (Object)selector.getCurrentDirectory());
            logger.debug("getSelectedFile() : {}", (Object)selector.getSelectedFile());
            result = selector.getSelectedFile();
        } else {
            result = null;
        }
        return result;
    }
}

