/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.views.geographyEditor;

import javax.swing.table.AbstractTableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.flatdb4geonames.model.FlatDB4GeoNames;
import org.tip.flatdb4geonames.model.GeoNamesLine;
import org.tip.flatdb4geonames.model.GeoNamesLines;
import org.tip.flatdb4geonames.model.index.Feature;

public class GeoNamesLineModel
extends AbstractTableModel {
    private static final Logger logger = LoggerFactory.getLogger(GeoNamesLineModel.class);
    private static final long serialVersionUID = -58643312061422885L;
    public static final int COLUMN_GEONAMEID = 0;
    public static final int COLUMN_TOPONYM = 1;
    public static final int COLUMN_ALTERNATE_NAMES = 2;
    public static final int COLUMN_LATITUDE = 3;
    public static final int COLUMN_LONGITUDE = 4;
    public static final int COLUMN_ELEVATION = 5;
    public static final int COLUMN_FEATURE = 6;
    public static final int COLUMN_ADMINCODES = 7;
    public static final int COLUMN_POPULATION = 8;
    public static final int COLUMN_TIMEZONE = 9;
    public static final int COLUMN_COUNT = 10;
    private GeoNamesLines source;
    private int lastSearchIndex;
    private String lastSearchPattern;

    public GeoNamesLineModel(GeoNamesLines source) {
        this.setSource(source);
    }

    public Class getColumnClass(int columnIndex) {
        Class result;
        switch (columnIndex) {
            case 0: {
                result = Number.class;
                break;
            }
            case 1: {
                result = String.class;
                break;
            }
            case 2: {
                result = String.class;
                break;
            }
            case 3: {
                result = Double.class;
                break;
            }
            case 4: {
                result = Double.class;
                break;
            }
            case 5: {
                result = Double.class;
                break;
            }
            case 6: {
                result = String.class;
                break;
            }
            case 7: {
                result = String.class;
                break;
            }
            case 8: {
                result = Long.class;
                break;
            }
            case 9: {
                result = String.class;
                break;
            }
            default: {
                result = String.class;
            }
        }
        return result;
    }

    @Override
    public int getColumnCount() {
        int result = 10;
        return result;
    }

    @Override
    public String getColumnName(int columnIndex) {
        String result;
        switch (columnIndex) {
            case 0: {
                result = "GeoNameId";
                break;
            }
            case 1: {
                result = "Toponym";
                break;
            }
            case 2: {
                result = "Alternates Toponyms";
                break;
            }
            case 3: {
                result = "Latitude";
                break;
            }
            case 4: {
                result = "Longitude";
                break;
            }
            case 5: {
                result = "Elevation";
                break;
            }
            case 6: {
                result = "Feature";
                break;
            }
            case 7: {
                result = "Admin";
                break;
            }
            case 8: {
                result = "Population";
                break;
            }
            case 9: {
                result = "TimeZone";
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }

    @Override
    public int getRowCount() {
        int result = this.source == null ? 0 : this.source.size();
        return result;
    }

    public GeoNamesLines getSource() {
        GeoNamesLines result = this.source;
        return result;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object result;
        GeoNamesLine line = (GeoNamesLine)this.source.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                result = line.getGeoNameId();
                break;
            }
            case 1: {
                result = line.getName();
                break;
            }
            case 2: {
                result = line.getAlternateNames().toStringList().sort().toStringSeparatedBy(";");
                break;
            }
            case 3: {
                result = line.getLatitude();
                break;
            }
            case 4: {
                result = line.getLongitude();
                break;
            }
            case 5: {
                result = line.getElevation();
                break;
            }
            case 6: {
                if (line.getFeatureClass() == null) {
                    result = null;
                    break;
                }
                if (FlatDB4GeoNames.isOpened()) {
                    result = FlatDB4GeoNames.instance().searchFeatureShortDescription(line.getFeatureCodePath());
                    break;
                }
                result = Feature.convertToFeaturePath((String)line.getFeatureClass().getCode(), (String)line.getFeatureCode());
                break;
            }
            case 7: {
                result = line.getAdministrativeCodePath();
                break;
            }
            case 8: {
                result = line.getPopulation();
                break;
            }
            case 9: {
                result = line.getTimeZone();
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }

    public int indexOf(GeoNamesLine target) {
        int result = this.source == null ? -1 : this.source.indexOf((Object)target);
        return result;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        boolean result = false;
        return result;
    }

    public boolean isSet() {
        boolean result = this.source != null;
        return result;
    }

    public GeoNamesLine nextSearched(String pattern) {
        GeoNamesLine result = null;
        return result;
    }

    public int nextSearchedIndex(String pattern) {
        int result = this.indexOf(this.nextSearched(pattern));
        return result;
    }

    public void resetSearch() {
        this.lastSearchIndex = -1;
        this.lastSearchPattern = null;
    }

    public void setSource(GeoNamesLines source) {
        this.resetSearch();
        if (this.source != null) {
            this.fireTableRowsDeleted(0, this.source.size());
        }
        this.source = source == null ? new GeoNamesLines() : source;
        this.fireTableDataChanged();
    }
}

