/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.views.geographyEditor;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.flatdb4geonames.model.FlatDB4GeoNamesException;
import org.tip.flatdb4geonames.util.Chronometer;
import org.tip.puck.geo2.Places2;
import org.tip.puckgui.util.ProgressStatus;
import org.tip.puckgui.views.geographyEditor.GeographyEditorPanel;

public class AutoFillProgressDialog
extends JDialog {
    private static final long serialVersionUID = -3662078915774866957L;
    private static Logger logger = LoggerFactory.getLogger(AutoFillProgressDialog.class);
    private final JPanel contentPanel = new JPanel();
    private SwingWorker<Boolean, Integer> progressWorker;
    private Timer progressUpdater;
    private JButton btnCancel;
    private JButton btnDone;
    private JProgressBar progressBar;
    private JLabel lblTimer;
    private JLabel lblCounter;
    private JLabel lblfilledPlaces;
    private JButton btnStart;

    public AutoFillProgressDialog(final Places2 places) {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                AutoFillProgressDialog.this.cancel();
            }
        });
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.setTitle("Download GeoNames dump files");
        this.setBounds(100, 100, 523, 293);
        this.setLocationRelativeTo(null);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout(new BoxLayout(this.contentPanel, 1));
        JPanel introPanel = new JPanel();
        this.contentPanel.add(introPanel);
        JLabel lblIntroduction = new JLabel("<html>\n<p>This action will fill empty place automatically.</p>\n<p>For each empty place, if GeoNames returns single match or direct match<br/>\nthen coordinates and homonyms are setted to the place,<br/>\notherwise nothing is done.</p>\n</html>");
        introPanel.add(lblIntroduction);
        Component verticalStrut = Box.createVerticalStrut(10);
        this.contentPanel.add(verticalStrut);
        JPanel inputPanel = new JPanel();
        this.contentPanel.add(inputPanel);
        inputPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC}));
        this.progressBar = new JProgressBar();
        this.progressBar.setEnabled(false);
        inputPanel.add((Component)this.progressBar, "4, 2");
        this.lblCounter = new JLabel("- / - (  0 %)");
        inputPanel.add((Component)this.lblCounter, "4, 4, center, default");
        this.lblfilledPlaces = new JLabel("Filled places: -");
        inputPanel.add((Component)this.lblfilledPlaces, "4, 6, center, default");
        this.lblTimer = new JLabel("00:00:00");
        inputPanel.add((Component)this.lblTimer, "4, 9, center, default");
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(1));
        this.getContentPane().add((Component)buttonPane, "South");
        this.btnCancel = new JButton("Cancel");
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                AutoFillProgressDialog.this.cancel();
                AutoFillProgressDialog.this.dispose();
            }
        });
        this.btnCancel.setActionCommand("Cancel");
        buttonPane.add(this.btnCancel);
        Component horizontalStrut = Box.createHorizontalStrut(20);
        buttonPane.add(horizontalStrut);
        this.btnStart = new JButton("Start");
        this.btnStart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                AutoFillProgressDialog.this.btnStart.setEnabled(false);
                AutoFillProgressDialog.this.doWork(places);
            }
        });
        this.btnStart.setActionCommand("Start");
        buttonPane.add(this.btnStart);
        horizontalStrut = Box.createHorizontalStrut(20);
        buttonPane.add(horizontalStrut);
        this.btnDone = new JButton("Done");
        this.btnDone.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                AutoFillProgressDialog.this.dispose();
            }
        });
        this.btnDone.setEnabled(false);
        this.btnDone.setActionCommand("Done");
        buttonPane.add(this.btnDone);
    }

    private void cancel() {
        if (this.progressWorker != null) {
            this.progressWorker.cancel(true);
        }
        if (this.progressUpdater != null) {
            this.progressUpdater.stop();
        }
    }

    private void doWork(final Places2 places) {
        final ProgressStatus fillStatus = new ProgressStatus();
        ActionListener taskPerformer = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                AutoFillProgressDialog.this.refreshDisplay(fillStatus);
            }
        };
        this.progressUpdater = new Timer(1000, taskPerformer);
        this.progressUpdater.setRepeats(true);
        this.progressUpdater.start();
        this.progressWorker = new SwingWorker<Boolean, Integer>(){

            @Override
            protected Boolean doInBackground() {
                block7: {
                    try {
                        int n = GeographyEditorPanel.fillAutomatically(places, fillStatus);
                    }
                    catch (IOException exception) {
                        exception.printStackTrace();
                        String title = "Error.";
                        String message = exception.getMessage();
                        JOptionPane.showMessageDialog(AutoFillProgressDialog.this, message, title, 0);
                        AutoFillProgressDialog.this.progressUpdater.stop();
                        AutoFillProgressDialog.this.refreshDisplay(fillStatus);
                        AutoFillProgressDialog.this.btnCancel.setEnabled(false);
                        AutoFillProgressDialog.this.btnDone.setEnabled(true);
                        JRootPane rootPane = SwingUtilities.getRootPane(AutoFillProgressDialog.this.btnDone);
                        rootPane.setDefaultButton(AutoFillProgressDialog.this.btnDone);
                        break block7;
                    }
                    catch (FlatDB4GeoNamesException exception) {
                        try {
                            exception.printStackTrace();
                            String title = "FlatDB4GeoNames Error.";
                            String message = exception.getMessage();
                            JOptionPane.showMessageDialog(AutoFillProgressDialog.this, message, title, 0);
                            break block7;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            AutoFillProgressDialog.this.progressUpdater.stop();
                            AutoFillProgressDialog.this.refreshDisplay(fillStatus);
                            AutoFillProgressDialog.this.btnCancel.setEnabled(false);
                            AutoFillProgressDialog.this.btnDone.setEnabled(true);
                            JRootPane rootPane = SwingUtilities.getRootPane(AutoFillProgressDialog.this.btnDone);
                            rootPane.setDefaultButton(AutoFillProgressDialog.this.btnDone);
                        }
                    }
                    AutoFillProgressDialog.this.progressUpdater.stop();
                    AutoFillProgressDialog.this.refreshDisplay(fillStatus);
                    AutoFillProgressDialog.this.btnCancel.setEnabled(false);
                    AutoFillProgressDialog.this.btnDone.setEnabled(true);
                    JRootPane rootPane = SwingUtilities.getRootPane(AutoFillProgressDialog.this.btnDone);
                    rootPane.setDefaultButton(AutoFillProgressDialog.this.btnDone);
                }
                boolean result = true;
                return result;
            }
        };
        this.progressWorker.execute();
    }

    private void refreshDisplay(ProgressStatus source) {
        this.progressBar.setValue(source.getCurrentRate());
        String counterValue = String.format("%d / %d (%3d %%)", source.getCurrent(), source.getMax(), source.getCurrentRate());
        this.lblCounter.setText(counterValue);
        String filledCounter = String.format("Filled places: %d", source.getExtra1());
        this.lblfilledPlaces.setText(filledCounter);
        String timerValue = Chronometer.toTimer((long)source.getChrono().stop().interval());
        this.lblTimer.setText(timerValue);
    }

    public static void showDialog() {
        AutoFillProgressDialog.showDialog(null, null);
    }

    public static void showDialog(Component parent, Places2 places) {
        AutoFillProgressDialog dialog = new AutoFillProgressDialog(places);
        dialog.pack();
        dialog.setLocationRelativeTo(parent);
        dialog.setVisible(true);
    }
}

