/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.util;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.flatdb4geonames.util.Chronometer;
import org.tip.puckgui.util.ProgressStatus;

public class ProgressDialog
extends JDialog {
    private static final long serialVersionUID = -3662078915774866957L;
    private static Logger logger = LoggerFactory.getLogger(ProgressDialog.class);
    private final JPanel contentPanel = new JPanel();
    private Timer progressUpdater;
    private JProgressBar progressBar;
    private JLabel lblTimer;
    private JLabel lblCounter;
    private JLabel lblfilledPlaces;

    public ProgressDialog(ProgressStatus status) {
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.setTitle("Download GeoNames dump files");
        this.setBounds(100, 100, 523, 293);
        this.setLocationRelativeTo(null);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout(new BoxLayout(this.contentPanel, 1));
        JPanel introPanel = new JPanel();
        this.contentPanel.add(introPanel);
        JLabel lblDescription = new JLabel(status.getDescription());
        introPanel.add(lblDescription);
        Component verticalStrut = Box.createVerticalStrut(10);
        this.contentPanel.add(verticalStrut);
        JPanel inputPanel = new JPanel();
        this.contentPanel.add(inputPanel);
        inputPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC}));
        this.progressBar = new JProgressBar();
        this.progressBar.setEnabled(false);
        inputPanel.add((Component)this.progressBar, "4, 2");
        this.lblCounter = new JLabel("- / - (  0 %)");
        inputPanel.add((Component)this.lblCounter, "4, 4, center, default");
        this.lblfilledPlaces = new JLabel("Secondary count: -");
        inputPanel.add((Component)this.lblfilledPlaces, "4, 6, center, default");
        this.lblTimer = new JLabel("00:00:00");
        inputPanel.add((Component)this.lblTimer, "4, 9, center, default");
        this.doWork();
    }

    private void doWork() {
        final ProgressStatus fillStatus = new ProgressStatus();
        ActionListener taskPerformer = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ProgressDialog.this.refreshDisplay(fillStatus);
            }
        };
        this.progressUpdater = new Timer(1000, taskPerformer);
        this.progressUpdater.setRepeats(true);
        this.progressUpdater.start();
    }

    private void refreshDisplay(ProgressStatus source) {
        this.progressBar.setValue(source.getCurrentRate());
        String counterValue = String.format("%d / %d (%3d %%)", source.getCurrent(), source.getMax(), source.getCurrentRate());
        this.lblCounter.setText(counterValue);
        String filledCounter = String.format("Secondary count: %d", source.getExtra1());
        this.lblfilledPlaces.setText(filledCounter);
        String timerValue = Chronometer.toTimer((long)source.getChrono().stop().interval());
        this.lblTimer.setText(timerValue);
    }

    public static void showDialog() {
        ProgressDialog.showDialog(null, null);
    }

    public static void showDialog(Component parent, ProgressStatus status) {
        ProgressDialog dialog = new ProgressDialog(status);
        dialog.pack();
        dialog.setLocationRelativeTo(parent);
        dialog.setVisible(true);
    }
}

