/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.models;

import fr.devinsy.util.StringSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.net.Attribute;
import org.tip.puck.net.AttributeComparator;
import org.tip.puck.net.Attributes;
import org.tip.puckgui.WindowGUI;

public class AttributesModel
extends AbstractTableModel {
    private static final long serialVersionUID = 4051885195814898307L;
    private static final Logger logger = LoggerFactory.getLogger(AttributesModel.class);
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("org.tip.puckgui.messages");
    private WindowGUI guim;
    private Attributes source;
    private List<Attribute> attributes;
    private StringSet attributeTemplates;
    private static boolean temporaryGlueActivated = false;

    public AttributesModel(WindowGUI guiManager, Attributes source, StringSet attributeTemplates) {
        this.guim = guiManager;
        this.source = source;
        if (source == null) {
            this.attributes = new ArrayList<Attribute>();
        } else {
            this.attributes = this.source.toSortedList();
            if (this.attributes.size() > 0 && this.attributes.get(0).getLabel().equals("")) {
                this.attributes.remove(0);
                this.attributes.add(new Attribute("", ""));
            }
        }
        this.attributeTemplates = attributeTemplates;
    }

    public Class getColumnClass(int columnIndex) {
        Class<String> result;
        if (this.source == null) {
            result = String.class;
        } else {
            switch (columnIndex) {
                case 0: {
                    result = String.class;
                    break;
                }
                case 1: {
                    result = String.class;
                    break;
                }
                default: {
                    result = String.class;
                }
            }
        }
        return result;
    }

    @Override
    public int getColumnCount() {
        int result = 2;
        return result;
    }

    @Override
    public String getColumnName(int columnIndex) {
        String result;
        switch (columnIndex) {
            case 0: {
                result = BUNDLE.getString("MainWindow.individual.label");
                break;
            }
            case 1: {
                result = BUNDLE.getString("MainWindow.individual.value");
                break;
            }
            default: {
                result = "";
            }
        }
        return result;
    }

    @Override
    public int getRowCount() {
        int result = this.attributes.size();
        return result;
    }

    public Attributes getSource() {
        Attributes result = this.source;
        return result;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        String result;
        if (this.source == null) {
            result = null;
        } else {
            switch (columnIndex) {
                case 0: {
                    result = this.attributes.get(rowIndex).getLabel();
                    break;
                }
                case 1: {
                    result = this.attributes.get(rowIndex).getValue();
                    break;
                }
                default: {
                    result = null;
                }
            }
        }
        return result;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        boolean result = true;
        return result;
    }

    public void removeBlankAttributes() {
        if (this.source != null) {
            this.source.removeBlankAttributes();
            this.setSource(this.source);
        }
    }

    public void setNewItem() {
        this.attributes.add(new Attribute("", ""));
        this.fireTableDataChanged();
    }

    public void setSource(Attributes source) {
        this.source = source;
        if (source == null) {
            this.attributes = new ArrayList<Attribute>();
        } else {
            this.attributes = this.source.toSortedList();
            if (this.attributes.size() > 0 && this.attributes.get(0).getLabel().equals("")) {
                this.attributes.remove(0);
                this.attributes.add(new Attribute("", ""));
            }
        }
        if (temporaryGlueActivated) {
            String[] extendedLabels;
            String[] stringArray = extendedLabels = new String[]{"COMPL", "SHEET", "NOTE", "CODEUR", "ALIVE", "INFO", "ORDH", "ORDW", "RENVOI", "MARTYPE", "DIV"};
            int n = extendedLabels.length;
            int n2 = 0;
            while (n2 < n) {
                String extendedLabel = stringArray[n2];
                if (this.source == null || !this.source.containsKey(extendedLabel)) {
                    this.attributes.add(new Attribute(extendedLabel, ""));
                }
                ++n2;
            }
            Collections.sort(this.attributes, new AttributeComparator());
        }
        this.fireTableDataChanged();
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        logger.debug("setValueAt " + rowIndex + " " + columnIndex);
        Attribute currentAttribute = this.attributes.get(rowIndex);
        if (columnIndex == 0) {
            if (rowIndex == this.source.size()) {
                if (StringUtils.isBlank((CharSequence)((String)value))) {
                    this.attributes.remove(rowIndex);
                    this.fireTableDataChanged();
                } else {
                    this.attributes.get(rowIndex).setLabel((String)value);
                    this.source.add(this.attributes.get(rowIndex));
                    if (this.attributeTemplates != null) {
                        this.attributeTemplates.put((String)value);
                    }
                }
            } else if (StringUtils.isBlank((CharSequence)((String)value))) {
                this.source.remove(currentAttribute.getLabel());
                this.setSource(this.source);
            } else {
                this.source.rename(currentAttribute, (String)value);
                if (this.attributeTemplates != null) {
                    this.attributeTemplates.put((String)value);
                }
            }
        } else if (columnIndex == 1) {
            if (StringUtils.isBlank((CharSequence)((String)value))) {
                this.source.remove(currentAttribute.getLabel());
                this.setSource(this.source);
            } else {
                currentAttribute.setValue((String)value);
                if (temporaryGlueActivated && StringUtils.isNotBlank((CharSequence)currentAttribute.getLabel()) && !this.source.containsKey(currentAttribute.getLabel())) {
                    this.source.add(currentAttribute);
                }
            }
        }
        this.guim.setChanged(true);
    }
}

