/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.visualization.layouts.hierarchical;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.EdgeIterable;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.MixedGraph;
import org.gephi.graph.api.Node;
import org.gephi.layout.plugin.AbstractLayout;
import org.gephi.layout.spi.LayoutBuilder;
import org.gephi.layout.spi.LayoutProperty;
import org.tip.puck.visualization.layouts.GraphSource;
import org.tip.puck.visualization.layouts.hierarchical.datastructs.ManyValuesMap;
import org.tip.puck.visualization.layouts.hierarchical.datastructs.chain.ChainCluster;
import org.tip.puck.visualization.layouts.hierarchical.datastructs.chain.ColoredChain;
import org.tip.puck.visualization.layouts.hierarchical.datastructs.chain.NodeLayoutData;
import org.tip.puck.visualization.layouts.hierarchical.datastructs.chain.Triad;
import org.tip.puck.visualization.layouts.hierarchical.datastructs.chain.containers.BorderContainer;
import org.tip.puck.visualization.layouts.hierarchical.datastructs.chain.containers.ChainContainer;
import org.tip.puck.visualization.layouts.hierarchical.datastructs.partition.Partition;
import org.tip.puck.visualization.layouts.hierarchical.datastructs.partition.PartitionItem;

public class HierarchicalLayout
extends AbstractLayout {
    private boolean executing = false;
    private static final int clusterDistance = 50;
    private static final int containerDistance = 50;
    private static final int nodeXDistance = 50;
    private static final int nodeYDistance = -550;
    private static final int marriedXDistance = 50;
    private static final int marriedYDistance = 100;
    private static final boolean centered = true;
    private GraphSource graphSource;
    private List<ChainCluster> rootsClusters = new ArrayList<ChainCluster>();

    public HierarchicalLayout(LayoutBuilder layoutBuilder) {
        super(layoutBuilder);
    }

    public void initAlgo() {
        Node[] nodes;
        this.executing = true;
        MixedGraph graph = this.graphModel.getMixedGraph();
        graph.readLock();
        HashSet<Node> rootNodes = new HashSet<Node>();
        Node[] nodeArray = nodes = graph.getNodes().toArray();
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeArray[n2];
            node.getNodeData().setX(0.0f);
            node.getNodeData().setY(5000.0f);
            Set<Node> parents = this.graphSource.getParents(node);
            if (parents.isEmpty()) {
                if (!this.graphSource.getChildren(node).isEmpty()) {
                    rootNodes.add(node);
                } else {
                    node.getNodeData().setColor(0.0f, 0.0f, 0.0f);
                    NodeLayoutData.color(node, NodeLayoutData.Color.BLACK);
                }
            } else if (parents.size() == 2) {
                node.getNodeData().setColor(1.0f, 0.0f, 0.0f);
                NodeLayoutData.color(node, NodeLayoutData.Color.RED);
            }
            ++n2;
        }
        graph.readUnlock();
        for (Node node : rootNodes) {
            ChainCluster rootCluster = ChainCluster.createCluster(this.graphSource, node, 0);
            this.rootsClusters.add(rootCluster);
        }
    }

    private ManyValuesMap<ChainCluster, ChainCluster> clusterGraph(Collection<ChainCluster> clusters) {
        ManyValuesMap<ChainCluster, ChainCluster> graph = new ManyValuesMap<ChainCluster, ChainCluster>();
        for (ChainCluster chainCluster : clusters) {
            Set<ChainCluster> allClusters = this.getClusterNeighborhood(chainCluster);
            if (allClusters.isEmpty()) continue;
            graph.addAll(chainCluster, clusters);
        }
        return graph;
    }

    private Partition<ChainCluster> partition(Collection<ChainCluster> elements, int level) {
        if (elements == null || level < 0) {
            return null;
        }
        Partition<ChainCluster> partitionForest = new Partition<ChainCluster>(elements);
        HashSet<ChainCluster> free = new HashSet<ChainCluster>();
        HashSet<ChainCluster> sources = new HashSet<ChainCluster>();
        HashSet<ChainCluster> targets = new HashSet<ChainCluster>();
        HashSet<ChainCluster> internal = new HashSet<ChainCluster>();
        HashSet<ChainCluster> temp = new HashSet<ChainCluster>(elements);
        while (!temp.isEmpty()) {
            ChainCluster element = (ChainCluster)temp.iterator().next();
            temp.remove(element);
            Set<ChainCluster> clusterTargets = this.getClusterTargets(element, level, level);
            Set<ChainCluster> clusterSources = this.getClusterSources(element, level, level);
            boolean isTarget = clusterSources.isEmpty();
            boolean isSource = clusterTargets.isEmpty();
            if (isTarget && isSource) {
                free.add(element);
                continue;
            }
            if (!isSource ^ !isTarget) {
                if (isSource) {
                    sources.add(element);
                    continue;
                }
                targets.add(element);
                continue;
            }
            internal.add(element);
        }
        if (sources.size() > targets.size()) {
            HashSet<ChainCluster> tmp = sources;
            sources = targets;
            targets = tmp;
        }
        this.partitionSources(partitionForest, internal, level);
        this.partitionSources(partitionForest, sources, level);
        return partitionForest;
    }

    private void partitionSources(Partition<ChainCluster> partitionForest, Collection<ChainCluster> sources, int level) {
        if (sources == null) {
            return;
        }
        if (sources.isEmpty()) {
            return;
        }
        for (ChainCluster source : sources) {
            PartitionItem<ChainCluster> sourcePartition = partitionForest.getPartition(source);
            Set<ChainCluster> clusterTargets = this.getClusterTargets(source, level, level);
            HashSet<PartitionItem<ChainCluster>> properClusters = new HashSet<PartitionItem<ChainCluster>>();
            HashSet<PartitionItem<ChainCluster>> specialClusters = new HashSet<PartitionItem<ChainCluster>>();
            for (ChainCluster chainCluster : clusterTargets) {
                PartitionItem<ChainCluster> partitionItem = partitionForest.getPartition(chainCluster);
                if (partitionItem.isSingleton()) {
                    properClusters.add(partitionItem);
                    continue;
                }
                specialClusters.add(partitionItem);
            }
            if (!sourcePartition.isSingleton()) {
                specialClusters.add(sourcePartition);
                if (!properClusters.isEmpty()) {
                    PartitionItem<ChainCluster> partitionItem;
                    sourcePartition = partitionItem = (PartitionItem<ChainCluster>)properClusters.iterator().next();
                    properClusters.remove(partitionItem);
                }
            }
            for (PartitionItem partitionItem : properClusters) {
                partitionForest.merge(sourcePartition, partitionItem);
            }
            HashMap hashMap = new HashMap();
            for (PartitionItem partitionItem : specialClusters) {
                PartitionItem root = partitionItem.find();
                Integer previousValue = hashMap.put(root, 1);
                if (previousValue == null) continue;
                hashMap.put(root, previousValue + 1);
            }
            ArrayList arrayList = new ArrayList(hashMap.entrySet());
            Collections.sort(arrayList, new Comparator<Map.Entry<PartitionItem<ChainCluster>, Integer>>(){

                @Override
                public int compare(Map.Entry<PartitionItem<ChainCluster>, Integer> o1, Map.Entry<PartitionItem<ChainCluster>, Integer> o2) {
                    return o1.getValue().compareTo(o2.getValue());
                }
            });
            for (Map.Entry entry : arrayList) {
                sourcePartition = partitionForest.merge((PartitionItem)entry.getKey(), sourcePartition);
            }
        }
    }

    public void goAlgo() {
        Node[] nodes;
        System.out.println("roots: " + this.rootsClusters.size());
        Partition<ChainCluster> partition = this.partition(this.rootsClusters, 0);
        this.rootsClusters.clear();
        Set<PartitionItem<ChainCluster>> roots = partition.getRoots();
        HashSet<ChainCluster> singletons = new HashSet<ChainCluster>();
        for (PartitionItem<ChainCluster> rootPartition : roots) {
            List<ChainCluster> toValues = PartitionItem.toValues(rootPartition);
            if (rootPartition.isSingleton()) {
                singletons.addAll(toValues);
                continue;
            }
            this.rootsClusters.addAll(0, toValues);
        }
        this.rootsClusters.addAll(singletons);
        List<ChainCluster> augmented = this.augmented(this.rootsClusters);
        int positionX = 0;
        int positionY = 0;
        int i = 0;
        while (i < augmented.size()) {
            ChainCluster chainCluster = augmented.get(i);
            positionX = this.drawCluster(chainCluster, positionX, positionY, this.randomPastelColor());
            ++i;
        }
        MixedGraph graph = this.graphModel.getMixedGraph();
        graph.readLock();
        Node[] nodeArray = nodes = graph.getNodes().toArray();
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeArray[n2];
            if (NodeLayoutData.isColored(node, NodeLayoutData.Color.BLACK)) {
                float cX = 0.0f;
                float cY = 0.0f;
                int counter = 0;
                EdgeIterable edges = graph.getEdges(node);
                for (Edge edge : edges) {
                    if (edge.isDirected()) continue;
                    Node opposite = graph.getOpposite(node, edge);
                    cX += opposite.getNodeData().x();
                    cY += opposite.getNodeData().y();
                    ++counter;
                }
                if (counter > 1) {
                    node.getNodeData().setX(cX / ((float)counter * 1.0f));
                    node.getNodeData().setY(cY / ((float)counter * 1.0f));
                } else if (counter == 1) {
                    node.getNodeData().setX(cX + 50.0f);
                    node.getNodeData().setY(cY + 100.0f);
                }
            }
            ++n2;
        }
        graph.readUnlock();
    }

    private int drawCluster(ChainCluster cluster, int x, int y, float[] rgbColor) {
        ChainContainer rootContainer = cluster.getCluster();
        return this.drawContainer(rootContainer, x, y, rgbColor) + 50;
    }

    private int drawChain(ColoredChain chain, int x, int y, float[] rgbColor) {
        Node[] nodes = chain.getNodes(this.graphSource);
        int distance = 0;
        Node[] nodeArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeArray[n2];
            node.getNodeData().setX((float)x * 1.0f);
            node.getNodeData().setY((float)(y + distance) * 1.0f);
            node.getNodeData().setR(rgbColor[0]);
            node.getNodeData().setG(rgbColor[1]);
            node.getNodeData().setB(rgbColor[2]);
            distance -= 550;
            ++n2;
        }
        return y + distance;
    }

    private int drawContainer(ChainContainer container, int x, int y, float[] rgbColor) {
        int result = 0;
        ColoredChain chain = container.getChain();
        int lastY = this.drawChain(chain, x, y, rgbColor);
        int tmpX = x;
        int tmpY = lastY;
        Set<ChainContainer> children = container.getChildren();
        ChainContainer[] toArray = children.toArray(new ChainContainer[children.size()]);
        Arrays.sort(toArray, new Comparator<ChainContainer>(){

            @Override
            public int compare(ChainContainer o1, ChainContainer o2) {
                return o1.getWidth() - o2.getWidth();
            }
        });
        ChainContainer[] chainContainerArray = toArray;
        int n = toArray.length;
        int n2 = 0;
        while (n2 < n) {
            int lastX;
            ChainContainer chainContainer = chainContainerArray[n2];
            tmpX = lastX = this.drawContainer(chainContainer, tmpX, tmpY, rgbColor);
            ++n2;
        }
        this.drawChain(chain, (x + tmpX - 50 - 50) / 2, y, rgbColor);
        result = tmpX + 50 + 50;
        return result;
    }

    public void endAlgo() {
        Node[] nodes;
        MixedGraph graph = this.graphModel.getMixedGraph();
        graph.readLock();
        Node[] nodeArray = nodes = graph.getNodes().toArray();
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeArray[n2];
            NodeLayoutData.clean(node);
            ++n2;
        }
        graph.readUnlock();
        this.executing = false;
    }

    public void setGraphModel(GraphModel graphModel) {
        super.setGraphModel(graphModel);
        this.graphSource = new GraphSource(graphModel.getMixedGraph());
    }

    private float[] randomPastelColor() {
        Random random = new Random();
        float hue = random.nextFloat();
        float saturation = 0.9f;
        float luminance = 1.0f;
        Color hsbColor = Color.getHSBColor(hue, 0.9f, 1.0f);
        float[] rgb = new float[]{1.0f * (float)hsbColor.getRed() / 255.0f, 1.0f * (float)hsbColor.getGreen() / 255.0f, 1.0f * (float)hsbColor.getBlue() / 255.0f};
        return rgb;
    }

    public LayoutProperty[] getProperties() {
        return null;
    }

    public void resetPropertiesValues() {
    }

    private Set<ChainCluster> getClusterSources(ChainCluster cluster, int clusterLevel, int sourceLevel) {
        Set<BorderContainer> borders = cluster.getBordersAtLevel(clusterLevel);
        HashSet<ChainCluster> neighbours = new HashSet<ChainCluster>();
        for (BorderContainer border : borders) {
            Triad[] triads;
            Triad[] triadArray = triads = border.getTriads();
            int n = triads.length;
            int n2 = 0;
            while (n2 < n) {
                BorderContainer sourceBorder;
                Triad triad = triadArray[n2];
                if (triad.isOn(border) && (sourceBorder = triad.getOtherBorder(border)).getOrigin() == sourceLevel) {
                    ChainCluster otherCluster = sourceBorder.getRootCluster();
                    neighbours.add(otherCluster);
                }
                ++n2;
            }
        }
        return neighbours;
    }

    private Set<ChainCluster> getClusterTargets(ChainCluster cluster, int clusterLevel, int targetLevel) {
        Set<BorderContainer> borders = cluster.getBordersAtLevel(clusterLevel);
        HashSet<ChainCluster> neighbours = new HashSet<ChainCluster>();
        if (borders == null) {
            return neighbours;
        }
        for (BorderContainer border : borders) {
            Triad[] triads;
            Triad[] triadArray = triads = border.getTriads();
            int n = triads.length;
            int n2 = 0;
            while (n2 < n) {
                BorderContainer targetBorder;
                Triad triad = triadArray[n2];
                if (!triad.isOn(border) && (targetBorder = triad.getOtherBorder(border)).getOrigin() == targetLevel) {
                    ChainCluster otherCluster = targetBorder.getRootCluster();
                    neighbours.add(otherCluster);
                }
                ++n2;
            }
        }
        return neighbours;
    }

    private Set<ChainCluster> getClusterNeighborhood(ChainCluster cluster) {
        Set<Integer> allLevels = cluster.getAllLevels();
        HashSet<ChainCluster> neighbours = new HashSet<ChainCluster>();
        for (Integer level : allLevels) {
            Set<BorderContainer> borders = cluster.getBordersAtLevel(level);
            for (BorderContainer border : borders) {
                Triad[] triads;
                Triad[] triadArray = triads = border.getTriads();
                int n = triads.length;
                int n2 = 0;
                while (n2 < n) {
                    Triad triad = triadArray[n2];
                    if (!triad.isInternal()) {
                        BorderContainer targetBorder = triad.getOtherBorder(border);
                        ChainCluster otherCluster = targetBorder.getRootCluster();
                        neighbours.add(otherCluster);
                    }
                    ++n2;
                }
            }
        }
        return neighbours;
    }

    private List<ChainCluster> augmented(List<ChainCluster> clusters) {
        ManyValuesMap<ChainCluster, ChainCluster> graph = this.clusterGraph(clusters);
        HashMap<ChainCluster, Integer> clusterPosition = new HashMap<ChainCluster, Integer>();
        int i = 0;
        while (i < clusters.size()) {
            clusterPosition.put(clusters.get(i), i);
            ++i;
        }
        LinkedList<ChainCluster> layout = new LinkedList<ChainCluster>();
        layout.add(clusters.get(0));
        int left = -1;
        int right = 1;
        int i2 = 1;
        while (i2 < clusters.size()) {
            int rightIncrement;
            ChainCluster chainCluster = clusters.get(i2);
            int leftIncrement = this.increment(chainCluster, left, graph, layout, clusterPosition);
            if (leftIncrement < (rightIncrement = this.increment(chainCluster, right, graph, layout, clusterPosition))) {
                clusterPosition.put(chainCluster, left);
                layout.add(0, chainCluster);
                --left;
            } else if (leftIncrement > rightIncrement) {
                clusterPosition.put(chainCluster, right);
                layout.add(layout.size(), chainCluster);
                ++right;
            } else {
                Random random = new Random();
                if (random.nextBoolean()) {
                    clusterPosition.put(chainCluster, left);
                    layout.add(0, chainCluster);
                    --left;
                } else {
                    clusterPosition.put(chainCluster, right);
                    layout.add(layout.size(), chainCluster);
                    ++right;
                }
            }
            ++i2;
        }
        return layout;
    }

    private int increment(ChainCluster cluster, int newPosition, ManyValuesMap<ChainCluster, ChainCluster> graph, List<ChainCluster> layout, Map<ChainCluster, Integer> positions) {
        int c = 0;
        int i = 0;
        while (i < layout.size()) {
            ChainCluster chainCluster = layout.get(i);
            if (graph.hasValue(chainCluster, cluster)) {
                c += Math.abs(positions.get(chainCluster) - newPosition);
            }
            ++i;
        }
        return c;
    }
}

